package com.biz.crm.notice.service;

import com.biz.crm.notice.model.SfaNoticeFileEntity;
import com.biz.crm.common.PageResult;
import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.nebular.sfa.notice.resp.SfaNoticeFileRespVo;
import com.biz.crm.nebular.sfa.notice.req.SfaNoticeFileReqVo;

import java.util.List;

/**
 * 公告附件 接口
 *
 * @author liuhongming
 * @date 2020-09-17 17:14:43
 */
public interface ISfaNoticeFileService extends IService<SfaNoticeFileEntity> {

    /**
     * 列表
     * @param sfaNoticeFileReqVo
     * @return PageResult<SfaNoticeFileRespVo>
     */
    PageResult<SfaNoticeFileRespVo> findList(SfaNoticeFileReqVo sfaNoticeFileReqVo);

    /**
     * 查询
     * @param sfaNoticeFileReqVo
     * @return SfaNoticeFileRespVo
     */
    SfaNoticeFileRespVo query(SfaNoticeFileReqVo sfaNoticeFileReqVo);

    /**
     * 新增
     * @param sfaNoticeFileReqVo
     * @return
     */
    void save(SfaNoticeFileReqVo sfaNoticeFileReqVo);

    /**
     * 更新
     * @param sfaNoticeFileReqVo
     * @return
     */
    void update(SfaNoticeFileReqVo sfaNoticeFileReqVo);

    /**
     * 删除
     * @param ids
     * @return
     */
    void deleteBatch(List<String> ids);

    /**
     * 启用
     * @param ids
     * @return
     */
    void enableBatch(List<String> ids);

    /**
     * 禁用
     * @param ids
     * @return
     */
    void disableBatch(List<String> ids);
}

