package com.biz.crm.notice.service;

import com.biz.crm.notice.model.SfaNoticeReceivingEntity;
import com.biz.crm.common.PageResult;
import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.nebular.sfa.notice.resp.SfaNoticeReceivingRespVo;
import com.biz.crm.nebular.sfa.notice.req.SfaNoticeReceivingReqVo;

import java.util.List;
import java.util.Map;

/**
 * 公告发布范围 接口
 *
 * @author liuhongming
 * @date 2020-09-17 17:14:43
 */
public interface ISfaNoticeReceivingService extends IService<SfaNoticeReceivingEntity> {

    /**
     * 列表
     * @param sfaNoticeReceivingReqVo
     * @return PageResult<SfaNoticeReceivingRespVo>
     */
    PageResult<SfaNoticeReceivingRespVo> findList(SfaNoticeReceivingReqVo sfaNoticeReceivingReqVo);

    /**
     * 查询
     * @param sfaNoticeReceivingReqVo
     * @return SfaNoticeReceivingRespVo
     */
    SfaNoticeReceivingRespVo query(SfaNoticeReceivingReqVo sfaNoticeReceivingReqVo);

    /**
     * 新增
     * @param sfaNoticeReceivingReqVo
     * @return
     */
    void save(SfaNoticeReceivingReqVo sfaNoticeReceivingReqVo);

    /**
     * 更新
     * @param sfaNoticeReceivingReqVo
     * @return
     */
    void update(SfaNoticeReceivingReqVo sfaNoticeReceivingReqVo);

    /**
     * 删除
     * @param ids
     * @return
     */
    void deleteBatch(List<String> ids);

    /**
     * 启用
     * @param ids
     * @return
     */
    void enableBatch(List<String> ids);

    /**
     * 禁用
     * @param ids
     * @return
     */
    void disableBatch(List<String> ids);
}

