package com.biz.crm.notice.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.aop.CrmLog;
import com.biz.crm.base.BusinessException;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.nebular.sfa.notice.req.SfaNoticeReadReqVo;
import com.biz.crm.nebular.sfa.notice.resp.SfaNoticeReadRespVo;
import com.biz.crm.notice.mapper.SfaNoticeReadMapper;
import com.biz.crm.notice.model.SfaNoticeReadEntity;
import com.biz.crm.notice.service.ISfaNoticeReadService;
import com.biz.crm.util.*;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.List;

/**
 * 公告读取信息 接口实现
 *
 * @author liuhongming
 * @date 2020-09-17 19:12:50
 */
@Slf4j
@Service
@ConditionalOnMissingBean(name="SfaNoticeReadServiceExpandImpl")
@Transactional
public class SfaNoticeReadServiceImpl<M extends BaseMapper<T>, T> extends ServiceImpl<SfaNoticeReadMapper, SfaNoticeReadEntity> implements ISfaNoticeReadService {

    @Resource
    private SfaNoticeReadMapper sfaNoticeReadMapper;

    /**
     * 列表
     * @param reqVo
     * @return
     */
    @Override
    @CrmLog
    public PageResult<SfaNoticeReadRespVo> findList(SfaNoticeReadReqVo reqVo){
        Page<SfaNoticeReadRespVo> page = new Page<>(reqVo.getPageNum(), reqVo.getPageSize());
        List<SfaNoticeReadRespVo> list = sfaNoticeReadMapper.findList(page, reqVo);
        return PageResult.<SfaNoticeReadRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    /**
     * 查询
     * @param reqVo
     * @return sfaNoticeReadRespVo
     */
    @Override
    @CrmLog
    public SfaNoticeReadRespVo query(SfaNoticeReadReqVo reqVo){
        return null;
    }

    /**
     * 新增
     * @param noticeCode
     * @return
     */
    @Override
    public void save(String noticeCode){
        AssertUtils.isNotEmpty(noticeCode,"公告编码不能为空");
        UserRedis user = UserUtils.getUser();
        String createCode = user.getUsername();
        String createPosCode = user.getPoscode();
        String createOrgCode = user.getOrgcode();
        SfaNoticeReadReqVo req = new SfaNoticeReadReqVo();
        req.setCreateCode(createCode);
        req.setCreatePosCode(createPosCode);
        req.setCreateOrgCode(createOrgCode);
        req.setNoticeCode(noticeCode);
        Integer count = sfaNoticeReadMapper.findReadSignCount(req);
        if(count==0) {
            SfaNoticeReadEntity entity = new SfaNoticeReadEntity();
            entity.setPosCode(createPosCode);
            entity.setUserName(createCode);
            entity.setNoticeCode(noticeCode);
            this.save(entity);
        }
    }


    /**
     * 更新
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    @CrmLog
    public void update(SfaNoticeReadReqVo reqVo){
        SfaNoticeReadEntity entity = this.getById(reqVo.getId());
        this.updateById(entity);
    }

    /**
     * 删除
     * @param ids
     * @return
     */
    @Override
    @CrmLog
    public void deleteBatch(List<String> ids){
        if (!CollectionUtil.listNotEmptyNotSizeZero(ids)){
            throw new BusinessException("数据主键不能为空");
        }
        List<SfaNoticeReadEntity> sfaNoticeReadEntities = sfaNoticeReadMapper.selectBatchIds(ids);
        if(CollectionUtils.isNotEmpty(sfaNoticeReadEntities)){
            sfaNoticeReadEntities.forEach(o -> {
                 o.setDelFlag(CrmDelFlagEnum.DELETE.getCode());
            });
        }
        this.updateBatchById(sfaNoticeReadEntities);
    }

    /**
     * 启用
     * @param ids
     * @return
     */
    @Override
    @CrmLog
    public void enableBatch(List<String> ids){
        if (!CollectionUtil.listNotEmptyNotSizeZero(ids)){
            throw new BusinessException("数据主键不能为空");
        }
        //设置状态为启用
        List<SfaNoticeReadEntity> sfaNoticeReadEntities = sfaNoticeReadMapper.selectBatchIds(ids);
        if(CollectionUtils.isNotEmpty(sfaNoticeReadEntities)){
            sfaNoticeReadEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
            });
        }
        this.updateBatchById(sfaNoticeReadEntities);
    }

    /**
     * 禁用
     * @param ids
     * @return
     */
    @Override
    @CrmLog
    public void disableBatch(List<String> ids){
        if (!CollectionUtil.listNotEmptyNotSizeZero(ids)){
            throw new BusinessException("数据主键不能为空");
        }
        //设置状态为禁用
        List<SfaNoticeReadEntity> sfaNoticeReadEntities = sfaNoticeReadMapper.selectBatchIds(ids);
        if(CollectionUtils.isNotEmpty(sfaNoticeReadEntities)){
                sfaNoticeReadEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode());
            });
        }
        this.updateBatchById(sfaNoticeReadEntities);
    }
}
