package com.biz.crm.picture.mapper;

import com.biz.crm.picture.model.SfaVisitPictureEntity;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Component;
import org.apache.ibatis.annotations.Mapper;
import com.biz.crm.nebular.sfa.picture.resp.SfaVisitPictureRespVo;
import com.biz.crm.nebular.sfa.picture.req.SfaVisitPictureReqVo;
import java.util.List;
import java.util.Map;

/**
 * 拜访相关照片信息 
 * 
 * @author liuhongming
 * @date 2020-10-15 15:32:29
 */
public interface SfaVisitPictureMapper extends BaseMapper<SfaVisitPictureEntity> {
    /**
     * 列表
     * @param page
     * @param sfaVisitPictureReqVo
     * @return
     */
    List<SfaVisitPictureRespVo> findList(Page<SfaVisitPictureRespVo> page, @Param("vo") SfaVisitPictureReqVo sfaVisitPictureReqVo);

    /**
     * 查询图片（不分页）
     *
     * @param sfaVisitPictureReqVo
     * @return
     */
    List<SfaVisitPictureRespVo> findSfaVisitPictureList(@Param("vo") SfaVisitPictureReqVo sfaVisitPictureReqVo);

}
