package com.biz.crm.picture.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

/**
 * 拜访相关照片信息 实体类
 *
 * @author liuhongming
 * @date 2020-10-15 15:32:29
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("sfa_visit_picture")
@CrmTable(name = "sfa_visit_picture", tableNote = "拜访相关照片信息")
public class SfaVisitPictureEntity extends CrmExtTenEntity<SfaVisitPictureEntity> {

    /**
     * 标题
     */
    @CrmColumn(name = "title", length = 200, note = "标题")
    private String title;

    /**
     * 照片类型
     */
    @CrmColumn(name = "pic_type", length = 32, note = "照片类型")
    private String picType;

    /**
     * 照片路径
     */
    @CrmColumn(name = "pic_path", length = 512, note = "照片路径")
    private String picPath;

    /**
     * 照片地址
     */
    @CrmColumn(name = "pic_url", length = 512, note = "照片地址")
    private String picUrl;

    /**
     * 照片描述
     */
    @CrmColumn(name = "pic_desc", length = 512, note = "照片描述")
    private String picDesc;

    /**
     * 拜访编码
     */
    @CrmColumn(name = "visit_id", length = 32, note = "拜访编码")
    private String visitId;

    /**
     * 业务明细关联
     */
    @CrmColumn(name = "business_id", length = 32, note = "业务明细关联")
    private String businessId;

}
