package com.biz.crm.tpmact.controller;

import com.biz.crm.nebular.sfa.tpmact.req.SfaTpmActDetailProductReqVo;
import com.biz.crm.nebular.sfa.tpmact.resp.SfaTpmActDetailProductRespVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import com.biz.crm.tpmact.service.ISfaTpmActDetailProductService;
import com.biz.crm.common.PageResult;
import com.biz.crm.util.Result;
import javax.validation.Valid;
import java.util.Objects;
import com.biz.crm.aop.CrmLog;

/**
 * tpm活动明细商品
 *
 * @author lf
 * @date 2021-06-10 16:44:26
 */
@Slf4j
@RestController
@RequestMapping("/sfaTpmActDetailProductController")
@Api(tags = "tpm活动明细商品")
public class SfaTpmActDetailProductController {
    @Autowired
    private ISfaTpmActDetailProductService sfaTpmActDetailProductService;

    /**
     * 列表
     */
    @ApiOperation(value = "查询列表")
    @PostMapping("/list")
    @CrmLog
    public Result<PageResult<SfaTpmActDetailProductRespVo>> list(@RequestBody SfaTpmActDetailProductReqVo sfaTpmActDetailProductReqVo) {
        PageResult<SfaTpmActDetailProductRespVo> result=sfaTpmActDetailProductService.findList(sfaTpmActDetailProductReqVo);
        return Result.ok(result);
    }

    /**
     * 查询
     */
    @ApiOperation(value = "查询")
    @PostMapping("/query")
    @CrmLog
    public Result<SfaTpmActDetailProductRespVo> query(@RequestBody SfaTpmActDetailProductReqVo sfaTpmActDetailProductReqVo) {
        SfaTpmActDetailProductRespVo respVo=sfaTpmActDetailProductService.query(sfaTpmActDetailProductReqVo);
        return Result.ok(respVo);
    }

    /**
     * 新增
     */
    @ApiOperation(value = "新增")
    @PostMapping("/save")
    @CrmLog
    public Result save(@RequestBody SfaTpmActDetailProductReqVo sfaTpmActDetailProductReqVo) {
        sfaTpmActDetailProductService.save(sfaTpmActDetailProductReqVo);
        return Result.ok();
    }

    /**
     * 更新
     */
    @ApiOperation(value = "更新")
    @PostMapping("/update")
    @CrmLog
    public Result update(@RequestBody SfaTpmActDetailProductReqVo sfaTpmActDetailProductReqVo) {
        sfaTpmActDetailProductService.update(sfaTpmActDetailProductReqVo);
        return Result.ok("修改成功");
    }

    /**
     * 删除
     */
    @ApiOperation(value = "删除")
    @PostMapping("/delete")
    @CrmLog
    public Result delete(@RequestBody SfaTpmActDetailProductReqVo sfaTpmActDetailProductReqVo) {
        sfaTpmActDetailProductService.deleteBatch(sfaTpmActDetailProductReqVo);
        return Result.ok("删除成功");
    }

    /**
     * 启用
     */
    @ApiOperation(value = "启用")
    @PostMapping("/enable")
    @CrmLog
    public Result enable(@RequestBody SfaTpmActDetailProductReqVo sfaTpmActDetailProductReqVo) {
        sfaTpmActDetailProductService.enableBatch(sfaTpmActDetailProductReqVo);
        return Result.ok("启用成功");
    }

    /**
     * 禁用
     */
    @ApiOperation(value = "禁用")
    @PostMapping("/disable")
    @CrmLog
    public Result disable(@RequestBody  SfaTpmActDetailProductReqVo sfaTpmActDetailProductReqVo) {
        sfaTpmActDetailProductService.disableBatch(sfaTpmActDetailProductReqVo);
        return Result.ok("禁用成功");
    }
}
