package com.biz.crm.tpmact.controller;

import com.biz.crm.nebular.sfa.tpmact.req.SfaTpmAuditCollectExampleReqVo;
import com.biz.crm.nebular.sfa.tpmact.resp.SfaTpmAuditCollectExampleRespVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import com.biz.crm.tpmact.service.ISfaTpmAuditCollectExampleService;
import com.biz.crm.common.PageResult;
import com.biz.crm.util.Result;
import javax.validation.Valid;
import java.util.Objects;
import com.biz.crm.aop.CrmLog;

/**
 * 活动细类（执行控制）
 *
 * @author lf
 * @date 2021-06-10 16:44:26
 */
@Slf4j
@RestController
@RequestMapping("/sfaTpmAuditCollectExampleController")
@Api(tags = "活动细类（执行控制）")
public class SfaTpmAuditCollectExampleController {
    @Autowired
    private ISfaTpmAuditCollectExampleService sfaTpmAuditCollectExampleService;

    /**
     * 列表
     */
    @ApiOperation(value = "查询列表")
    @PostMapping("/list")
    @CrmLog
    public Result<PageResult<SfaTpmAuditCollectExampleRespVo>> list(@RequestBody SfaTpmAuditCollectExampleReqVo sfaTpmAuditCollectExampleReqVo) {
        PageResult<SfaTpmAuditCollectExampleRespVo> result=sfaTpmAuditCollectExampleService.findList(sfaTpmAuditCollectExampleReqVo);
        return Result.ok(result);
    }

    /**
     * 查询
     */
    @ApiOperation(value = "查询")
    @PostMapping("/query")
    @CrmLog
    public Result<SfaTpmAuditCollectExampleRespVo> query(@RequestBody SfaTpmAuditCollectExampleReqVo sfaTpmAuditCollectExampleReqVo) {
        SfaTpmAuditCollectExampleRespVo respVo=sfaTpmAuditCollectExampleService.query(sfaTpmAuditCollectExampleReqVo);
        return Result.ok(respVo);
    }

    /**
     * 新增
     */
    @ApiOperation(value = "新增")
    @PostMapping("/save")
    @CrmLog
    public Result save(@RequestBody SfaTpmAuditCollectExampleReqVo sfaTpmAuditCollectExampleReqVo) {
        sfaTpmAuditCollectExampleService.save(sfaTpmAuditCollectExampleReqVo);
        return Result.ok();
    }

    /**
     * 更新
     */
    @ApiOperation(value = "更新")
    @PostMapping("/update")
    @CrmLog
    public Result update(@RequestBody SfaTpmAuditCollectExampleReqVo sfaTpmAuditCollectExampleReqVo) {
        sfaTpmAuditCollectExampleService.update(sfaTpmAuditCollectExampleReqVo);
        return Result.ok("修改成功");
    }

    /**
     * 删除
     */
    @ApiOperation(value = "删除")
    @PostMapping("/delete")
    @CrmLog
    public Result delete(@RequestBody SfaTpmAuditCollectExampleReqVo sfaTpmAuditCollectExampleReqVo) {
        sfaTpmAuditCollectExampleService.deleteBatch(sfaTpmAuditCollectExampleReqVo);
        return Result.ok("删除成功");
    }

    /**
     * 启用
     */
    @ApiOperation(value = "启用")
    @PostMapping("/enable")
    @CrmLog
    public Result enable(@RequestBody SfaTpmAuditCollectExampleReqVo sfaTpmAuditCollectExampleReqVo) {
        sfaTpmAuditCollectExampleService.enableBatch(sfaTpmAuditCollectExampleReqVo);
        return Result.ok("启用成功");
    }

    /**
     * 禁用
     */
    @ApiOperation(value = "禁用")
    @PostMapping("/disable")
    @CrmLog
    public Result disable(@RequestBody  SfaTpmAuditCollectExampleReqVo sfaTpmAuditCollectExampleReqVo) {
        sfaTpmAuditCollectExampleService.disableBatch(sfaTpmAuditCollectExampleReqVo);
        return Result.ok("禁用成功");
    }
}
