package com.biz.crm.tpmact.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.nebular.sfa.tpmact.req.SfaTpmActDetailProductReqVo;
import com.biz.crm.nebular.sfa.tpmact.req.SfaTpmActDetailReqVo;
import com.biz.crm.nebular.sfa.tpmact.req.SfaTpmActReqVo;
import com.biz.crm.nebular.sfa.tpmact.resp.*;
import com.biz.crm.tpmact.model.SfaTpmActDetailEntity;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * tpm活动明细
 *
 * @author lf
 * @date 2021-06-10 16:44:26
 */
public interface SfaTpmActDetailMapper extends BaseMapper<SfaTpmActDetailEntity> {
    /**
     * 列表
     *
     * @param page
     * @param sfaTpmActDetailReqVo
     * @return
     */
    List<SfaTpmActDetailRespVo> findList(Page<SfaTpmActDetailRespVo> page, @Param("vo") SfaTpmActDetailReqVo sfaTpmActDetailReqVo);

    /**
     * 查询工作台的活动信息
     * @param page
     * @param reqVo
     * @return
     */
    List<SfaTpmActRespVo> findOnGoingWorkbench(Page<SfaTpmActRespVo> page, @Param("vo") SfaTpmActReqVo reqVo, @Param("now") String now, @Param("actDetailIdList")List<String> actDetailIdList);

    /**
     * 查询已完成的活动信息
     * @param page
     * @param reqVo
     * @param now
     * @param actDetailIdList
     * @return
     */
    List<SfaTpmActRespVo> findAlreadySuccessWorkbench(Page<SfaTpmActRespVo> page, @Param("vo") SfaTpmActReqVo reqVo, @Param("now") String now);

    /**
     * 查询当前时间内活动的组织，客户
     * @param now
     * @return
     */
    List<SfaTpmActDetailEntity> findOrgAndCustomerList(@Param("now")String now);

    /**
     * 通过活动明细编码查询活动详细信息
     * @param actDetailCode
     * @return
     */
    SfaTpmActDetailRespVo findActDetailByActDetailCode(@Param("actDetailCode") String actDetailCode);

    /**
     * 查询tpm活动执行过关联的分销订单
     * @param actDetailCode
     * @return
     */
    List<ExecuteDataRespVo> findDistributionOrderList(@Param("actDetailCode") String actDetailCode,@Param("terminalCode")String terminalCode,@Param("visitPlanInfoId") String visitPlanInfoId);

    /**
     * 查询tpm活动执行过关联的采集数据
     * @param actDetailCode
     * @return
     */
    List<ExecuteDataRespVo> findCollectDataList(@Param("actDetailCode") String actDetailCode,@Param("terminalCode")String terminalCode,@Param("visitPlanInfoId") String visitPlanInfoId);

    /**
     * 查询活动商品
     * @param page
     * @param reqVo
     * @return
     */
    List<SfaTpmActDetailProductRespVo> findActProductList(Page<SfaTpmActDetailProductRespVo> page,@Param("vo")SfaTpmActDetailProductReqVo reqVo);

    /**
     * 查询历史拜访tpm活动信息
     * @param visitPlanInfoId
     * @return
     */
    List<SfaTpmActRespVo> findVisitOldTpmAct(@Param("visitPlanInfoId") String visitPlanInfoId);

    /**
     * 查询拜访步骤报表tpm活动列表
     * @param visitPlanInfoId
     * @param terminalCode
     * @return
     */
    List<SfaTpmActRespVo> findVisitStepTpmActList(@Param("visitPlanInfoId") String visitPlanInfoId,@Param("terminalCode") String terminalCode);


    /**
     * 查询拜访步骤tpm活动信息详情
     * @param actDetailCode
     * @return
     */
    SfaTpmActReportRespVo findVisitStepTpmActDetail(@Param("actDetailCode") String actDetailCode);
}
