package com.biz.crm.tpmact.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.base.CrmThirtyNumberExtEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import lombok.EqualsAndHashCode;
import com.biz.crm.base.CrmBaseEntity;

import java.math.BigDecimal;
import java.util.Date;

import lombok.experimental.Accessors;

/**
 * tpm活动明细实体类
 *
 * @author lf
 * @date 2021-06-10 16:44:26
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("sfa_tpm_act_detail")
@CrmTable(name = "sfa_tpm_act_detail", tableNote = "tpm活动明细")
public class SfaTpmActDetailEntity extends CrmThirtyNumberExtEntity<SfaTpmActDetailEntity> {


    /**
     * 活动编码
     */
    @CrmColumn(name = "act_code", length = 64, note = "活动编码")
    private String actCode;


    /**
     * 活动名称
     */
    @CrmColumn(name = "act_name", length = 64, note = "活动名称")
    private String actName;


    /**
     * 活动明细编码
     */
    @CrmColumn(name = "act_detail_code", length = 64, note = "活动明细编码")
    private String actDetailCode;


    /**
     * 活动细类编码
     */
    @CrmColumn(name = "fine_code", length = 64, note = "活动细类编码")
    private String fineCode;


    /**
     * 活动细类类型
     */
    @CrmColumn(name = "act_detail_type", length = 10, note = "活动明细类型")
    private String actDetailType;


    /**
     * 活动细类名称
     */
    @CrmColumn(name = "fine_name", length = 64, note = "活动细类名称")
    private String fineName;


    /**
     * 企业组织
     */
    @CrmColumn(name = "org_code", length = 64, note = "企业组织")
    private String orgCode;


    /**
     * 企业组织名称
     */
    @CrmColumn(name = "org_name", length = 64, note = "企业组织名称")
    private String orgName;


    /**
     * 客户编码
     */
    @CrmColumn(name = "customer_code", length = 64, note = "客户编码")
    private String customerCode;


    /**
     * 客户名称
     */
    @CrmColumn(name = "customer_name", length = 64, note = "客户名称")
    private String customerName;


    /**
     * 终端编码
     */
    @CrmColumn(name = "terminal_code", length = 64, note = "终端编码")
    private String terminalCode;


    /**
     * 终端名称
     */
    @CrmColumn(name = "terminal_name", length = 64, note = "终端名称")
    private String terminalName;

    /**
     * 渠道编码
     */
    @CrmColumn(name = "channel",length = 12,note = "渠道编码")
    private String channel;

    /**
     * 渠道名称
     */
    @CrmColumn(name = "channel_name",length = 64,note = "渠道名称")
    private String channelName;

    /**
     * 费用申请金额
     */
    @CrmColumn(name = "apply_amount", mysqlType = "decimal(12,2)", oracleType = "NUMBER(12,2)", note = "费用申请金额")
    private BigDecimal applyAmount;


    /**
     * 是否完全核销
     */
    @CrmColumn(name = "is_all_audit", length = 12, note = "是否完全核销")
    private String isAllAudit;


    /**
     * 是否核销
     */
    @CrmColumn(name = "is_audit", length = 12, note = "是否核销")
    private String isAudit;


    /**
     * 以核销金额
     */
    @CrmColumn(name = "audit_amount", mysqlType = "decimal(12,2)", oracleType = "NUMBER(12,2)", note = "已核销金额")
    private BigDecimal auditAmount;


    /**
     * 支付方式
     */
    @CrmColumn(name = "pay_type", length = 32, note = "支付方式")
    private String payType;


    /**
     * 支付方式名称
     */
    @CrmColumn(name = "pay_type_name", length = 64, note = "支付方式名称")
    private String payTypeName;


    /**
     * 支付方式类型
     */
    @CrmColumn(name = "pay_type_type", length = 64, note = "支付方式类型")
    private String payTypeType;

    /**
     * 超额核销比例
     */
    @CrmColumn(name = "extra_audit_ratio", mysqlType = "decimal(12,2)", oracleType = "NUMBER(12,2)", note = "超额核销比例")
    private BigDecimal extraAuditRatio;

    /**
     * 活动折让价格
     */
    @CrmColumn(name = "event_price", mysqlType = "decimal(12,2)", oracleType = "NUMBER(12,2)", note = "活动折让价格")
    private BigDecimal eventPrice;

    /**
     * 公司承担金额
     */
    @CrmColumn(name = "hd_commitment", mysqlType = "decimal(12,2)", oracleType = "NUMBER(12,2)", note = "公司承担金额")
    private BigDecimal hdCommitment;


    /**
     * 陈列奖励产品编码
     */
    @CrmColumn(name = "display_award_product_code", length = 64, note = "陈列奖励产品编码")
    private String displayAwardProductCode;

    /**
     * 陈列奖励产品名称
     */
    @CrmColumn(name = "display_award_product_name", length = 200, note = "陈列奖励产品名称")
    private String displayAwardProductName;

}
