package com.biz.crm.tpmact.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import lombok.EqualsAndHashCode;
import com.biz.crm.base.CrmBaseEntity;

import java.math.BigDecimal;
import java.util.Date;

import lombok.experimental.Accessors;

/**
 * tpm活动实体类
 *
 * @author lf
 * @date 2021-06-10 16:44:26
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("sfa_tpm_act")
@CrmTable(name = "sfa_tpm_act", tableNote = "tpm活动")
public class SfaTpmActEntity extends CrmExtTenEntity<SfaTpmActEntity> {


    /**
     * 活动编码
     */
    @CrmColumn(name = "act_code", length = 64, note = "活动编码")
    private String actCode;


    /**
     * 活动名称
     */
    @CrmColumn(name = "act_name", length = 64, note = "活动名称")
    private String actName;


    /**
     * 审批状态
     */
    @CrmColumn(name = "approve_status", length = 12, note = "审批状态")
    private String approveStatus;


    /**
     * 活动描述
     */
    @CrmColumn(name = "act_desc", length = 255, note = "活动描述")
    private String actDesc;


    /**
     * 开始时间-年月日
     */
    @CrmColumn(name = "begin_date", length = 12, note = "开始时间-年月日")
    private String beginDate;


    /**
     * 开始时间-时分秒
     */
    @CrmColumn(name = "begin_date_second", length = 12, note = "开始时间-时分秒")
    private String beginDateSecond;


    /**
     * 结束时间-年月日
     */
    @CrmColumn(name = "end_date", length = 12, note = "结束时间-年月日")
    private String endDate;


    /**
     * 结束时间-时分秒
     */
    @CrmColumn(name = "end_date_second", length = 12, note = "结束时间-时分秒")
    private String endDateSecond;

    /**
     * 申请金额
     */
    @CrmColumn(name = "total_amount",mysqlType = "decimal(16,6)",oracleType = "NUMBER(16, 6)",note = "申请金额")
    private BigDecimal totalAmount;

    /**
     * 核销总金额
     */
    @CrmColumn(name = "audit_total_amount",mysqlType = "decimal(16,6)",oracleType = "NUMBER(16, 6)",note = "核销总金额")
    private BigDecimal auditTotalAmount;

}
