package com.biz.crm.tpmact.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.Getter;
import lombok.Setter;
import lombok.EqualsAndHashCode;
import com.biz.crm.base.CrmBaseEntity;

import java.util.Date;

import lombok.experimental.Accessors;

/**
 * 活动细类（执行控制）实体类
 *
 * @author lf
 * @date 2021-06-10 16:44:26
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("sfa_tpm_audit_collect_example")
@CrmTable(name = "sfa_tpm_audit_collect_example", tableNote = "活动细类（执行控制）")
public class SfaTpmAuditCollectExampleEntity extends CrmExtTenEntity<SfaTpmAuditCollectExampleEntity> {


    /**
     * 示例编码
     */
    @CrmColumn(name = "example_code", length = 64, note = "示例编码")
    private String exampleCode;


    /**
     * 示例名称
     */
    @CrmColumn(name = "example_name", length = 64, note = "示例名称")
    private String exampleName;


    /**
     * 类型名称
     */
    @CrmColumn(name = "example_type", length = 64, note = "类型名称")
    private String exampleType;


    /**
     * 排序
     */
    @CrmColumn(name = "sort", mysqlType = "int(10)", oracleType = "NUMBER(10,0)", note = "排序")
    private Integer sort;

}
