package com.biz.crm.tpmact.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.Getter;
import lombok.Setter;
import lombok.EqualsAndHashCode;
import com.biz.crm.base.CrmBaseEntity;

import java.util.Date;

import lombok.experimental.Accessors;

/**
 * 采集要求-照片实体类
 *
 * @author lf
 * @date 2021-06-10 16:44:26
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("sfa_tpm_audit_collect_example_picture")
@CrmTable(name = "sfa_tpm_audit_collect_example_picture", tableNote = "采集要求-照片")
public class SfaTpmAuditCollectExamplePictureEntity extends CrmExtTenEntity<SfaTpmAuditCollectExamplePictureEntity> {


    /**
     * 示例编码
     */
    @CrmColumn(name = "example_code", length = 64, note = "示例编码")
    private String exampleCode;


    /**
     * 图片地址
     */
    @CrmColumn(name = "url_address", length = 255, note = "图片地址")
    private String urlAddress;


    /**
     * 对象名称
     */
    @CrmColumn(name = "object_name", length = 255, note = "对象名称")
    private String objectName;

}
