package com.biz.crm.tpmact.service;

import com.biz.crm.moblie.controller.visit.req.step.ExecutorWorkbenchLoadReq;
import com.biz.crm.nebular.sfa.tpmact.actcollect.SfaTpmActCollectFormVo;
import com.biz.crm.nebular.sfa.tpmact.req.SfaTpmActDetailProductReqVo;
import com.biz.crm.nebular.sfa.tpmact.req.SfaTpmActDetailReqVo;
import com.biz.crm.nebular.sfa.tpmact.req.SfaTpmActReportReqVo;
import com.biz.crm.nebular.sfa.tpmact.req.SfaTpmActReqVo;
import com.biz.crm.nebular.sfa.tpmact.resp.SfaTpmActDetailProductRespVo;
import com.biz.crm.nebular.sfa.tpmact.resp.SfaTpmActDetailRespVo;
import com.biz.crm.nebular.sfa.tpmact.resp.SfaTpmActReportRespVo;
import com.biz.crm.nebular.sfa.tpmact.resp.SfaTpmActRespVo;
import com.biz.crm.tpmact.model.SfaTpmActDetailEntity;
import com.biz.crm.common.PageResult;
import com.baomidou.mybatisplus.extension.service.IService;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;
import java.util.Map;

/**
 * tpm活动明细接口
 *
 * @author lf
 * @date 2021-06-10 16:44:26
 */
public interface ISfaTpmActDetailService extends IService<SfaTpmActDetailEntity> {

    /**
     * 列表
     * @param sfaTpmActDetailReqVo
     * @return PageResult<SfaTpmActDetailRespVo>
     */
    PageResult<SfaTpmActDetailRespVo> findList(SfaTpmActDetailReqVo sfaTpmActDetailReqVo);

    /**
     * 查询
     * @param sfaTpmActDetailReqVo
     * @return SfaTpmActDetailRespVo
     */
    SfaTpmActDetailRespVo query(SfaTpmActDetailReqVo sfaTpmActDetailReqVo);

    /**
     * 工作台查询tpm活动
     * @param tpmActReqVo
     * @return
     */
    PageResult<SfaTpmActRespVo> getTpmActList(SfaTpmActReqVo tpmActReqVo);

    /**
     * 通过活动明细编码获得tpm活动详情
     * @param actDetailCode
     * @return
     */
    SfaTpmActDetailRespVo getTpmActDetailByActDetailCode(String actDetailCode,String terminalCode,String redisHashKey,String visitPlanInfoId);

    /**
     * 查询活动采集数据动态表单
     * @param fineCode
     * @return
     */
    List<SfaTpmActCollectFormVo> findActCollectDataForm(String fineCode,String actDetailCode);

    /**
     * 查询活动商品
     * @param reqVo
     * @return
     */
    PageResult<SfaTpmActDetailProductRespVo> findActProductList(SfaTpmActDetailProductReqVo reqVo);

    /**
     * 拜访步骤-tpm活动-查询已完成的拜访历史tpm活动
     * @param visitPlanInfoId
     * @return
     */
    List<SfaTpmActRespVo> getVisitSuccessTpmAct(String visitPlanInfoId);

    /**
     * tpm活动-查询拜访步骤报表tpm活动列表
     * @param req
     * @return
     */
    List<SfaTpmActRespVo> loadVisitStepTpmReport(SfaTpmActReportReqVo req);

    /**
     * tpm活动-查询拜访步骤明细报表tpm活动列表信息-查询活动明细
     * @param reqVo
     * @return
     */
    SfaTpmActReportRespVo getTpmActDetailReport(SfaTpmActReportReqVo reqVo);



}

