package com.biz.crm.tpmact.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.nebular.sfa.tpmact.SfaTpmActOrderCollectVo;
import com.biz.crm.nebular.sfa.tpmact.VisitBaseVo;
import com.biz.crm.nebular.sfa.tpmact.actcollect.SfaTpmActCollectVo;
import com.biz.crm.tpmact.model.SfaVisitStepTpmActCollectEntity;

import java.util.List;


/**
 * 拜访步骤-tpm活动数据采集接口
 *
 * @author lf
 * @date 2021-06-13 20:32:45
 */
public interface ISfaVisitStepTpmActCollectService extends IService<SfaVisitStepTpmActCollectEntity> {

    /**
     * tpm活动-活动数据采集
     * @param vo
     */
    String saveWorkBenchActCollect(SfaTpmActCollectVo vo);

    /**
     * tpm活动-活动数据采集-查询详情
     * @param id
     * @return
     */
    SfaTpmActCollectVo loadTpmActCollectDetail(String id);

    /**
     * 拜访步骤-tpm活动-活动数据采集
     * @param vo
     */
    String saveVisitStepActCollect(VisitBaseVo<SfaTpmActCollectVo> vo);


    /**
     * 分销订单、活动数据采集接口
     * @param vo
     */
    void saveWorkBenchActOrderCollect(SfaTpmActOrderCollectVo vo);

    /**
     * tpm活动-根据活动明细编码查询活动执行数据
     * @param actDetailCode
     * @return
     */
    List<SfaTpmActCollectVo> getTpmActExecuteDataByActDetailCode(String actDetailCode);
}

