package com.biz.crm.tpmact.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.asexecution.model.SfaAsTreatyEntity;
import com.biz.crm.asexecution.service.ISfaAsTreatyService;
import com.biz.crm.base.BusinessException;
import com.biz.crm.base.attachment.ISfaAttachmentService;
import com.biz.crm.base.attachment.SfaAttachmentEntity;
import com.biz.crm.common.PageResult;
import com.biz.crm.common.param.RedisParam;
import com.biz.crm.config.CrmDictMethod;
import com.biz.crm.enums.SfaVisitStatusEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.eunm.sfa.SfaActivityEnum;
import com.biz.crm.eunm.sfa.SfaCommonEnum;
import com.biz.crm.eunm.tpm.ActAdvancePayApproveStatusEnum;
import com.biz.crm.mdm.pricesetting.MdmPriceSettingFeign;
import com.biz.crm.mdm.product.MdmProductFeign;
import com.biz.crm.mdm.terminal.MdmTerminalFeign;
import com.biz.crm.nebular.activiti.vo.AttachmentVo;
import com.biz.crm.nebular.mdm.pricesetting.req.MdmPriceSearchReqVo;
import com.biz.crm.nebular.mdm.pricesetting.resp.MdmPriceResp;
import com.biz.crm.nebular.mdm.product.req.MdmProductReqVo;
import com.biz.crm.nebular.mdm.product.resp.MdmProductRespVo;
import com.biz.crm.nebular.sfa.tpmact.SfaTpmOrgRCusVo;
import com.biz.crm.nebular.sfa.tpmact.actcollect.SfaTpmActCollectFormVo;
import com.biz.crm.nebular.sfa.tpmact.req.SfaTpmActDetailProductReqVo;
import com.biz.crm.nebular.sfa.tpmact.req.SfaTpmActDetailReqVo;
import com.biz.crm.nebular.sfa.tpmact.req.SfaTpmActReportReqVo;
import com.biz.crm.nebular.sfa.tpmact.req.SfaTpmActReqVo;
import com.biz.crm.nebular.sfa.tpmact.resp.ExecuteDataRespVo;
import com.biz.crm.nebular.sfa.tpmact.resp.SfaTpmActDetailProductRespVo;
import com.biz.crm.nebular.sfa.tpmact.resp.SfaTpmActDetailRespVo;
import com.biz.crm.nebular.sfa.tpmact.resp.SfaTpmActReportRespVo;
import com.biz.crm.nebular.sfa.tpmact.resp.SfaTpmActRespVo;
import com.biz.crm.service.RedisService;
import com.biz.crm.tpmact.mapper.SfaTpmActDetailMapper;
import com.biz.crm.tpmact.model.SfaTpmActDetailEntity;
import com.biz.crm.tpmact.model.SfaTpmActDetailProductEntity;
import com.biz.crm.tpmact.model.SfaTpmAuditCollectExampleEntity;
import com.biz.crm.tpmact.model.SfaTpmAuditCollectExamplePictureEntity;
import com.biz.crm.tpmact.model.SfaTpmCostTypeFineEntity;
import com.biz.crm.tpmact.model.SfaVisitStepTpmActCollectEntity;
import com.biz.crm.tpmact.service.ISfaTpmActDetailProductService;
import com.biz.crm.tpmact.service.ISfaTpmActDetailService;
import com.biz.crm.tpmact.service.ISfaTpmAuditCollectExamplePictureService;
import com.biz.crm.tpmact.service.ISfaTpmAuditCollectExampleService;
import com.biz.crm.tpmact.service.ISfaTpmCostTypeFineService;
import com.biz.crm.tpmact.service.ISfaVisitStepTpmActCollectService;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.CrmDateUtils;
import com.biz.crm.util.PageUtil;
import com.biz.crm.util.Result;
import com.biz.crm.util.StringUtils;
import com.biz.crm.visitinfo.model.SfaVisitPlanInfoEntity;
import com.biz.crm.visitstep.model.SfaVisitStepOrderEntity;
import com.biz.crm.visitstep.model.SfaVisitStepOrderItemEntity;
import com.biz.crm.visitstep.service.ISfaVisitStepOrderItemService;
import com.biz.crm.visitstep.service.ISfaVisitStepOrderService;
import com.biz.crm.visitstepbase.VisitBaseComponent;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * tpm活动明细接口实现
 *
 * @author lf
 * @date 2021-06-10 16:44:26
 */
@Slf4j
@Service
@ConditionalOnMissingBean(name = "SfaTpmActDetailServiceExpandImpl")
public class SfaTpmActDetailServiceImpl<M extends BaseMapper<T>, T> extends ServiceImpl<SfaTpmActDetailMapper, SfaTpmActDetailEntity> implements ISfaTpmActDetailService {

    @Resource
    private SfaTpmActDetailMapper sfaTpmActDetailMapper;
    @Resource
    private MdmTerminalFeign mdmterminalfeign;
    @Resource
    private ISfaTpmActDetailProductService sfaTpmActDetailProductService;
    @Resource
    private RedisService redisService;
    @Autowired
    private ISfaTpmCostTypeFineService sfaTpmCostTypeFineService;
    @Autowired
    private ISfaTpmAuditCollectExampleService sfaTpmAuditCollectExampleService;
    @Autowired
    private ISfaTpmAuditCollectExamplePictureService sfaTpmAuditCollectExamplePictureService;
    @Autowired
    private ISfaVisitStepOrderService sfaVisitStepOrderService;
    @Autowired
    private ISfaAsTreatyService sfaAsTreatyService;
    @Autowired
    private ISfaVisitStepTpmActCollectService sfaVisitStepTpmActCollectService;
    @Resource
    private VisitBaseComponent visitBaseComponent;
    @Autowired
    private ISfaVisitStepOrderItemService sfaVisitStepOrderItemService;
    @Autowired
    private ISfaAttachmentService sfaAttachmentService;
    @Resource
    private MdmProductFeign mdmProductFeign;
    @Autowired
    private MdmPriceSettingFeign  mdmPriceSettingFeign;

    /**
     * 列表
     *
     * @param reqVo
     * @return
     */
    @Override
    public PageResult<SfaTpmActDetailRespVo> findList(SfaTpmActDetailReqVo reqVo) {
        Page<SfaTpmActDetailRespVo> page = PageUtil.buildPage(reqVo.getPageNum(), reqVo.getPageSize());
        List<SfaTpmActDetailRespVo> list = sfaTpmActDetailMapper.findList(page, reqVo);
        return PageResult.<SfaTpmActDetailRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    /**
     * 查询
     *
     * @param reqVo
     * @return sfaTpmActDetailRespVo
     */
    @Override
    public SfaTpmActDetailRespVo query(SfaTpmActDetailReqVo reqVo) {
        return null;
    }

    /**
     * 查询tpm工作台活动
     *
     * @param reqVo
     * @return
     */
    @Override
    public PageResult<SfaTpmActRespVo> getTpmActList(SfaTpmActReqVo reqVo) {
        log.info("------------------------------------方法开始1-------"+System.currentTimeMillis());
        AssertUtils.isNotEmpty(reqVo.getTerminalCode(), "终端编码不能为空!");
        AssertUtils.isNotEmpty(reqVo.getSfaTpmActStatus(), "活动状态不能为空");
        String now = LocalDate.now().format(CrmDateUtils.yyyyMMdd);
        Page<SfaTpmActRespVo> page = new Page<>(reqVo.getPageNum(), reqVo.getPageSize());
        List<SfaTpmActRespVo> list = null;
        if (SfaCommonEnum.sfaTpmActStatus.onGoing.getValue().equals(reqVo.getSfaTpmActStatus())) {
            List<String> actDetailIdList = this.getActDetailIdList(now, reqVo.getTerminalCode());
            //查询进行中的活动
            list = sfaTpmActDetailMapper.findOnGoingWorkbench(page, reqVo, now, actDetailIdList);
            log.info("------------------------------------方法开始2-------"+System.currentTimeMillis());
        } else if (SfaCommonEnum.sfaTpmActStatus.alreadySuccess.getValue().equals(reqVo.getSfaTpmActStatus())) {
            list = sfaTpmActDetailMapper.findAlreadySuccessWorkbench(page, reqVo, now);
        }
        if (CollectionUtil.listNotEmptyNotSizeZero(list)) {
            Set<String> actDetailCodes = list.stream().filter(s -> StringUtils.isNotEmpty(s.getActDetailCode())).map(SfaTpmActRespVo::getActDetailCode).collect(Collectors.toSet());
            List<SfaVisitStepOrderEntity> orderEntities = this.sfaVisitStepOrderService.lambdaQuery()
                .in(SfaVisitStepOrderEntity::getActDetailCode, actDetailCodes).list();
            List<SfaAsTreatyEntity> treatyEntities = this.sfaAsTreatyService.lambdaQuery()
                .in(SfaAsTreatyEntity::getActivityCode, actDetailCodes).list();
            log.info("------------------------------------方法开始3-------"+System.currentTimeMillis());
            Map<String, List<SfaVisitStepOrderEntity>> orderMap = new HashMap<>();
            Map<String, List<SfaAsTreatyEntity>> treatMap = new HashMap<>();

            if(CollectionUtil.listNotEmptyNotSizeZero(orderEntities)){
                Map<String, List<SfaVisitStepOrderEntity>> ordMap = orderEntities.stream().filter(item -> Objects.nonNull(item.getActDetailCode()))
                    .collect(Collectors.groupingBy(SfaVisitStepOrderEntity::getActDetailCode));
                if(CollectionUtil.mapNotEmpty(ordMap)){
                    orderMap.putAll(ordMap);
                }
            }
            if(CollectionUtil.listNotEmptyNotSizeZero(treatyEntities)){
                Map<String, List<SfaAsTreatyEntity>> treMap = treatyEntities.stream().filter(item -> Objects.nonNull(item.getActivityCode()))
                    .collect(Collectors.groupingBy(SfaAsTreatyEntity::getActivityCode));
                if(CollectionUtil.mapNotEmpty(treMap)){
                    treatMap.putAll(treMap);
                }
            }
            log.info("------------------------------------方法开始4-------"+System.currentTimeMillis());
            //进行金额统计计算
            list.forEach(data -> {
                List<SfaVisitStepOrderEntity> orderEntitie = orderMap.get(data.getActDetailCode());
                List<SfaAsTreatyEntity> treatyEntitie = treatMap.get(data.getActDetailCode());
                BigDecimal treatyPrice = BigDecimal.ZERO;
                BigDecimal orderPrice = BigDecimal.ZERO;
                data.setCurrentUsedAmount(BigDecimal.ZERO);
                if(CollectionUtil.listNotEmptyNotSizeZero(orderEntitie)){
                    BigDecimal orPrice = orderEntitie.stream().map(SfaVisitStepOrderEntity::getTotalPrice).reduce(BigDecimal.ZERO, BigDecimal::add);
                    BigDecimal terminalOrderPrice = orderEntitie.stream().filter(o -> o.getClientCode().equals(reqVo.getTerminalCode()))
                        .map(SfaVisitStepOrderEntity::getTotalPrice).reduce(BigDecimal.ZERO, BigDecimal::add);
                    data.setCurrentUsedAmount(terminalOrderPrice);
                    orderPrice = orderPrice.add(orPrice);
                }
                if(CollectionUtil.listNotEmptyNotSizeZero(treatyEntitie)){
                    BigDecimal trPrice = treatyEntitie.stream().map(SfaAsTreatyEntity::getTotalPrice).reduce(BigDecimal.ZERO, BigDecimal::add);
                    treatyPrice = treatyPrice.add(trPrice);
                }
                //判断是否有签署协议的配置  有协议配置计算协议金额 否则计算订单
                if (YesNoEnum.yesNoEnum.Y.getValue().equals(data.getIsSignDisplayAgreement())) {
                    data.setUsedAmount(treatyPrice);
                } else {
                    data.setUsedAmount(orderPrice);
                }
//
//                //本店已使用金额不算协议金额
//                BigDecimal terminalTreatyPrice = treatyEntitie.stream().filter(t -> t.getTerminalCode().equals(reqVo.getTerminalCode()))
//                        .map(SfaAsTreatyEntity::getTotalPrice).reduce(BigDecimal.ZERO, BigDecimal::add);
            });
            log.info("------------------------------------方法开始5-------"+System.currentTimeMillis());
        }
        return PageResult.<SfaTpmActRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    /**
     * tpm活动-通过活动明细编码获得活动详情信息
     *
     * @param actDetailCode
     * @return
     */
    @Override
    @CrmDictMethod
    public SfaTpmActDetailRespVo getTpmActDetailByActDetailCode(String actDetailCode, String terminalCode, String redisHashKey, String visitPlanInfoId) {
        AssertUtils.isNotEmpty(actDetailCode, "活动明细编码为空");
        AssertUtils.isNotEmpty(terminalCode, "终端编码为空");
        SfaTpmActDetailRespVo respVo = sfaTpmActDetailMapper.findActDetailByActDetailCode(actDetailCode);
        Map<String, List<SfaTpmActDetailProductEntity>> productMap = this.sfaTpmActDetailProductService
                .lambdaQuery()
                .eq(SfaTpmActDetailProductEntity::getActDetailCode, respVo.getActDetailCode())
                .like(SfaTpmActDetailProductEntity::getIsGiftProduct, YesNoEnum.yesNoEnum.Y.getValue())
                .list().stream().collect(Collectors.groupingBy(SfaTpmActDetailProductEntity::getIsGiftProduct));
        if (productMap != null && productMap.size() > 0) {
            respVo.setDistributionOrderType(SfaActivityEnum.bpItemType.zp.getVal());
            respVo.setDistributionOrderTypeName(SfaActivityEnum.bpItemType.zp.getDesc());
        } else {
            respVo.setDistributionOrderType(SfaActivityEnum.bpItemType.bp.getVal());
            respVo.setDistributionOrderTypeName(SfaActivityEnum.bpItemType.bp.getDesc());
        }
        //订单类型（有无赠品区别）-临时放到redis，下次进行分销订单保存时可以直接取出
        redisService.hmset(SfaTpmActDetailRespVo.buildRedisKey(actDetailCode), SfaTpmActDetailRespVo.buildRedisDistributionOrderType(respVo.getDistributionOrderType()), SfaTpmActDetailRespVo.REDIS_EXPIRE_TIME);
        //查询是否签署协议，如果没有签署，那么分销订单，活动数据采集均不返回
        SfaAsTreatyEntity treatyEntity = sfaAsTreatyService.lambdaQuery()
                .eq(SfaAsTreatyEntity::getActivityCode, actDetailCode)
                .eq(SfaAsTreatyEntity::getTerminalCode, terminalCode)
                .select(SfaAsTreatyEntity::getId)
                .one();
        if (YesNoEnum.yesNoEnum.Y.getValue().equals(respVo.getIsSignDisplayAgreement())) {
            if (treatyEntity != null) {
                respVo.setDisplayAgreementId(treatyEntity.getId());
            } else {
                respVo.setIsCollectDistributionOrder(YesNoEnum.yesNoEnum.N.getValue());
                respVo.setIsCollectActData(YesNoEnum.yesNoEnum.N.getValue());
            }
        }
        List<ExecuteDataRespVo> actCollectDataList = null;
        List<ExecuteDataRespVo> actCollectDistributionOrderList = null;
        //redisHashKey 表示当前进行的拜访数据查询
        if (StringUtils.isNotEmpty(redisHashKey)) {
            SfaVisitPlanInfoEntity.VisitRedisHashKey visitRedisHashKey = new SfaVisitPlanInfoEntity.VisitRedisHashKey(redisHashKey);
            SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity = visitBaseComponent.loadAndCheckSfaVisitPlanInfoEntity(redisHashKey, visitRedisHashKey.getVisitBigType());
            visitPlanInfoId = sfaVisitPlanInfoEntity.getId();
            SfaVisitStepOrderEntity orderEntity = sfaVisitStepOrderService.lambdaQuery()
                    .eq(SfaVisitStepOrderEntity::getActDetailCode, actDetailCode)
                    .eq(SfaVisitStepOrderEntity::getVisitPlanInfoId, visitPlanInfoId)
                    .select(SfaVisitStepOrderEntity::getId).one();
            if (orderEntity != null) {
                respVo.setDistributionOrderId(orderEntity.getId());
            }
            SfaVisitStepTpmActCollectEntity collectEntity = sfaVisitStepTpmActCollectService.lambdaQuery()
                    .eq(SfaVisitStepTpmActCollectEntity::getActDetailCode, actDetailCode)
                    .eq(SfaVisitStepTpmActCollectEntity::getVisitPlanInfoId, visitPlanInfoId)
                    .select(SfaVisitStepTpmActCollectEntity::getId).one();
            if (collectEntity != null) {
                respVo.setActCollectDataId(collectEntity.getId());
            }
        } else if (StringUtils.isNotEmpty(visitPlanInfoId)) {
            //查询历史的拜访记录数据
            actCollectDataList = sfaTpmActDetailMapper.findCollectDataList(actDetailCode, terminalCode, visitPlanInfoId);
            actCollectDistributionOrderList = sfaTpmActDetailMapper.findDistributionOrderList(actDetailCode, terminalCode, visitPlanInfoId);
        } else {
            actCollectDataList = sfaTpmActDetailMapper.findCollectDataList(actDetailCode, terminalCode, null);
            actCollectDistributionOrderList = sfaTpmActDetailMapper.findDistributionOrderList(actDetailCode, terminalCode, null);
        }
        if (CollectionUtil.listNotEmptyNotSizeZero(actCollectDataList)) {
            respVo.setActCollectDataList(actCollectDataList);
        }
        if (CollectionUtil.listNotEmptyNotSizeZero(actCollectDistributionOrderList)) {
            respVo.setActCollectDistributionOrderList(actCollectDistributionOrderList);
        }
        return respVo;
    }

    @Override
    public List<SfaTpmActCollectFormVo> findActCollectDataForm(String fineCode, String actDetailCode) {
        AssertUtils.isNotEmpty(fineCode, "活动细类编码为空");
        AssertUtils.isNotEmpty(actDetailCode, "活动明细编码为空");
        SfaTpmCostTypeFineEntity fineEntity = this.sfaTpmCostTypeFineService.lambdaQuery()
                .eq(SfaTpmCostTypeFineEntity::getFineCode, fineCode)
                .select(SfaTpmCostTypeFineEntity::getCollectRequireList).one();
        List<SfaTpmActCollectFormVo> formVos = Lists.newArrayList();
        if (fineEntity != null && StringUtils.isNotEmpty(fineEntity.getCollectRequireList())) {
            List<String> exampleList = JSONObject.parseArray(fineEntity.getCollectRequireList(), String.class);
            List<SfaTpmAuditCollectExampleEntity> exampleEntities = this.sfaTpmAuditCollectExampleService.lambdaQuery()
                    .in(SfaTpmAuditCollectExampleEntity::getExampleCode, exampleList)
                    .orderByAsc(SfaTpmAuditCollectExampleEntity::getSort)
                    .list();
            if (CollectionUtil.listNotEmptyNotSizeZero(exampleEntities)) {
                //转换为map进行顺序处理
                Map<String, SfaTpmAuditCollectExampleEntity> map = exampleEntities.stream()
                        .collect(Collectors.toMap(SfaTpmAuditCollectExampleEntity::getExampleCode, k -> k));
                for (String x : exampleList) {
                    if (map.containsKey(x)) {
                        formVos.add(CrmBeanUtil.copy(map.get(x), SfaTpmActCollectFormVo.class));
                    }
                }
                formVos.forEach(data -> {
                    List<String> picList = this.sfaTpmAuditCollectExamplePictureService.lambdaQuery()
                            .eq(SfaTpmAuditCollectExamplePictureEntity::getExampleCode, data.getExampleCode())
                            .list().stream().map(SfaTpmAuditCollectExamplePictureEntity::getUrlAddress).collect(Collectors.toList());
                    data.setPictList(picList);
                });
            }
        } else {
            throw new BusinessException("tpm活动未配置活动采集示例");
        }
        redisService.hmset(SfaTpmActCollectFormVo.buildRedisKey(actDetailCode), SfaTpmActCollectFormVo.buildRedisMap(actDetailCode, formVos), SfaTpmActCollectFormVo.REDIS_EXPIRE_TIME);
        return formVos;
    }

    /**
     * 查询
     *
     * @param reqVo
     * @return
     */
    @Override
    public PageResult<SfaTpmActDetailProductRespVo> findActProductList(SfaTpmActDetailProductReqVo reqVo) {
        AssertUtils.isNotEmpty(reqVo.getActDetailCode(), "活动明细编码为空");
        MdmProductReqVo productReqVo = new MdmProductReqVo();
        productReqVo.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
        productReqVo.setPageNum(reqVo.getPageNum());
        productReqVo.setPageSize(reqVo.getPageSize());
        PageResult<MdmProductRespVo> productPageResult = mdmProductFeign.pageList(productReqVo).getResult();
        List<SfaTpmActDetailProductRespVo> list = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(productPageResult.getData())) {
            MdmPriceSearchReqVo searchReqVo = new MdmPriceSearchReqVo();
            searchReqVo.setConditionTypeCodeList(Lists.newArrayList("sale_price"));
            searchReqVo.setProductCodeList(productPageResult.getData().stream().map(MdmProductRespVo::getProductCode).collect(Collectors.toList()));
            Map<String, Map<String, MdmPriceResp>> productPriceMap = mdmPriceSettingFeign.inquiry(searchReqVo).getResult();
            list = productPageResult.getData().stream().map(mdmProductRespVo -> {
                Map<String, MdmPriceResp> priceMap = productPriceMap.get(mdmProductRespVo.getProductCode());
                SfaTpmActDetailProductRespVo productRespVo = new SfaTpmActDetailProductRespVo();
                productRespVo.setProductCode(mdmProductRespVo.getProductCode());
                productRespVo.setProductName(mdmProductRespVo.getProductName());
                productRespVo.setSpec(mdmProductRespVo.getSpec());
                productRespVo.setSfaPicUrl(mdmProductRespVo.getPicUrl());
                productRespVo.setSaleUnit(mdmProductRespVo.getSaleUnit());
                productRespVo.setSaleUnitName(mdmProductRespVo.getSaleUnitName());
                productRespVo.setPrimaryPictureUrl(mdmProductRespVo.getPrimaryPictureUrl());
                productRespVo.setPrice(priceMap != null
                    ? Lists.newArrayList(priceMap.values()).get(0).getPrice() : null);
                return productRespVo;
            }).collect(Collectors.toList());
        }
        return PageResult.<SfaTpmActDetailProductRespVo>builder()
                .data(list)
                .count(productPageResult.getCount())
                .build();
    }

    /**
     * 拜访步骤-tpm活动-查询已完成的拜访历史tpm活动
     *
     * @param visitPlanInfoId
     * @return
     */
    @Override
    public List<SfaTpmActRespVo> getVisitSuccessTpmAct(String visitPlanInfoId) {
        List<SfaTpmActRespVo> respVoList = sfaTpmActDetailMapper.findVisitOldTpmAct(visitPlanInfoId);
        if (CollectionUtil.listNotEmptyNotSizeZero(respVoList)) {
            respVoList.forEach(respVo -> {
                List<SfaVisitStepOrderEntity> orderEntities = this.sfaVisitStepOrderService.lambdaQuery()
                        .eq(SfaVisitStepOrderEntity::getActDetailCode, respVo.getActDetailCode()).list();
                List<SfaAsTreatyEntity> treatyEntities = this.sfaAsTreatyService.lambdaQuery()
                        .eq(SfaAsTreatyEntity::getActivityCode, respVo.getActDetailCode()).list();
                BigDecimal orderPrice = BigDecimal.ZERO;
                BigDecimal treatyPrice = BigDecimal.ZERO;
                BigDecimal terminalOrderPrice = BigDecimal.ZERO;
                BigDecimal terminalTreatyPrice = BigDecimal.ZERO;
                if (CollectionUtil.listNotEmptyNotSizeZero(orderEntities)) {
                    orderPrice = orderEntities.stream().map(SfaVisitStepOrderEntity::getTotalPrice).reduce(BigDecimal.ZERO, BigDecimal::add);
                    terminalOrderPrice = orderEntities.stream().filter(o -> o.getClientCode().equals(respVo.getTerminalCode()))
                            .map(SfaVisitStepOrderEntity::getTotalPrice).reduce(BigDecimal.ZERO, BigDecimal::add);
                }
                if (CollectionUtil.listNotEmptyNotSizeZero(treatyEntities)) {
                    treatyPrice = treatyEntities.stream().map(SfaAsTreatyEntity::getTotalPrice).reduce(BigDecimal.ZERO, BigDecimal::add);
                    terminalTreatyPrice = treatyEntities.stream().filter(t -> t.getTerminalCode().equals(respVo.getTerminalCode()))
                            .map(SfaAsTreatyEntity::getTotalPrice).reduce(BigDecimal.ZERO, BigDecimal::add);
                }
                respVo.setUsedAmount(orderPrice.add(treatyPrice));
                respVo.setCurrentUsedAmount(terminalTreatyPrice.add(terminalOrderPrice));
            });
        }
        return respVoList;
    }

    /**
     * tpm活动-查询拜访步骤tpm活动列表
     *
     * @param req
     * @return
     */
    @Override
    public List<SfaTpmActRespVo> loadVisitStepTpmReport(SfaTpmActReportReqVo req) {
        AssertUtils.isNotEmpty(req.getVisitPlanInfoId(), "拜访明细id为空");
        AssertUtils.isNotEmpty(req.getTerminalCode(), "终端编码为空");
        List<SfaTpmActRespVo> respVoList = sfaTpmActDetailMapper.findVisitStepTpmActList(req.getVisitPlanInfoId(), req.getTerminalCode());
        return respVoList;
    }

    /**
     * tpm活动-查询拜访步骤明细报表tpm活动列表信息-查询活动明细
     *
     * @param reqVo
     * @return
     */
    @Override
    public SfaTpmActReportRespVo getTpmActDetailReport(SfaTpmActReportReqVo reqVo) {
        AssertUtils.isNotEmpty(reqVo.getVisitPlanInfoId(), "拜访明细id为空");
        AssertUtils.isNotEmpty(reqVo.getTerminalCode(), "终端编码为空");
        AssertUtils.isNotEmpty(reqVo.getActDetailCode(), "活动明细编码为空");
        SfaTpmActReportRespVo reportRespVo = (SfaTpmActReportRespVo) redisService.hmget(SfaTpmActReportRespVo.buildRedisHashKey(reqVo), SfaTpmActReportRespVo.REDIS_HASH_KEY);
        if (null == reportRespVo) {
            reportRespVo = sfaTpmActDetailMapper.findVisitStepTpmActDetail(reqVo.getActDetailCode());
            LocalDate now = LocalDate.now();
            LocalDate beginDate = LocalDate.parse(reportRespVo.getBeginDate());
            LocalDate endDate = LocalDate.parse(reportRespVo.getEndDate());
            //进行活动状态判断
            if ((beginDate.isBefore(now) || beginDate.isEqual(now)) && (endDate.isAfter(now) || endDate.isEqual(now)) &&
                    ActAdvancePayApproveStatusEnum.APPROVED.getCode().equals(reportRespVo.getApproveStatus()) && reportRespVo.getAuditAmount() == null) {
                reportRespVo.setActStatusName(SfaVisitStatusEnum.PROCESSING.getDesc());
            } else {
                reportRespVo.setActStatusName(SfaVisitStatusEnum.FINISHED.getDesc());
            }
            List<SfaVisitStepOrderEntity> orderEntities = this.sfaVisitStepOrderService.lambdaQuery()
                    .eq(SfaVisitStepOrderEntity::getActDetailCode, reqVo.getActDetailCode()).list();
            List<SfaAsTreatyEntity> treatyEntities = this.sfaAsTreatyService.lambdaQuery()
                    .eq(SfaAsTreatyEntity::getActivityCode, reqVo.getActDetailCode()).list();
            BigDecimal orderPrice = BigDecimal.ZERO;
            BigDecimal treatyPrice = BigDecimal.ZERO;
            BigDecimal terminalOrderPrice = BigDecimal.ZERO;
            BigDecimal terminalTreatyPrice = BigDecimal.ZERO;
            if (CollectionUtil.listNotEmptyNotSizeZero(orderEntities)) {
                orderPrice = orderEntities.stream().map(SfaVisitStepOrderEntity::getTotalPrice).reduce(BigDecimal.ZERO, BigDecimal::add);
                terminalOrderPrice = orderEntities.stream().filter(o -> o.getClientCode().equals(reqVo.getTerminalCode()))
                        .map(SfaVisitStepOrderEntity::getTotalPrice).reduce(BigDecimal.ZERO, BigDecimal::add);
            }
            if (CollectionUtil.listNotEmptyNotSizeZero(treatyEntities)) {
                treatyPrice = treatyEntities.stream().map(SfaAsTreatyEntity::getTotalPrice).reduce(BigDecimal.ZERO, BigDecimal::add);
                terminalTreatyPrice = treatyEntities.stream().filter(t -> t.getTerminalCode().equals(reqVo.getTerminalCode()))
                        .map(SfaAsTreatyEntity::getTotalPrice).reduce(BigDecimal.ZERO, BigDecimal::add);
            }
            if (YesNoEnum.yesNoEnum.Y.getValue().equals(reportRespVo.getIsSignDisplayAgreement())) {
                reportRespVo.setUsedAmount(treatyPrice);
            } else {
                reportRespVo.setUsedAmount(orderPrice);
            }
            reportRespVo.setCurrentUsedAmount(terminalOrderPrice);
            SfaVisitStepTpmActCollectEntity actCollectEntity = sfaVisitStepTpmActCollectService.lambdaQuery()
                    .eq(SfaVisitStepTpmActCollectEntity::getActDetailCode, reqVo.getActDetailCode())
                    .eq(SfaVisitStepTpmActCollectEntity::getVisitPlanInfoId, reqVo.getVisitPlanInfoId()).one();
            //组装数据
            this.buildVisitStepTpmActReport(orderEntities, treatyEntities, actCollectEntity, reportRespVo, reqVo);
        }
        redisService.hmset(SfaTpmActReportRespVo.buildRedisHashKey(reqVo), SfaTpmActReportRespVo.buildRedisMap(reportRespVo), SfaTpmActReportRespVo.REDIS_EXPIRE_TIME);
        return reportRespVo;
    }


    /**
     * 获取当前时间内活动的明细id
     *
     * @param now
     * @return
     */
    protected List<String> getActDetailIdList(String now, String terminalCode) {
        List<String> actDetailIdList = new ArrayList<>();
        List<SfaTpmActDetailEntity> detailEntities = sfaTpmActDetailMapper.findOrgAndCustomerList(now);
        SfaTpmOrgRCusVo orgRCusVo = new SfaTpmOrgRCusVo();
        orgRCusVo.setTerminalCode(terminalCode);
        List<SfaTpmOrgRCusVo.OrgRCus> orgRCusList = new ArrayList<>();
        detailEntities.forEach(data -> {
            SfaTpmOrgRCusVo.OrgRCus orgRCus = new SfaTpmOrgRCusVo.OrgRCus();
            orgRCus.setId(data.getId());
            if (StringUtils.isNotEmpty(data.getTerminalCode()) && data.getTerminalCode().equals(terminalCode)) {
                actDetailIdList.add(data.getId());
            } else if (StringUtils.isNotEmpty(data.getCustomerCode())) {
                orgRCus.setCustomerCode(data.getCustomerCode());
                orgRCusList.add(orgRCus);
            } else if (StringUtils.isNotEmpty(data.getOrgCode())) {
                orgRCus.setOrgCode(data.getOrgCode());
                orgRCusList.add(orgRCus);
            }
        });
        if (CollectionUtil.listNotEmptyNotSizeZero(orgRCusList)) {
            orgRCusVo.setOrgRCusList(orgRCusList);
            Result<List<String>> result = mdmterminalfeign.checkTerminalCodeRelByOrgOrCusCode(orgRCusVo);
            if (result.isSuccess()) {
                if (CollectionUtil.listNotEmptyNotSizeZero(result.getResult())) {
                    actDetailIdList.addAll(result.getResult());
                }
            } else {
                throw new BusinessException("TPM活动:查询当前终端是否在TPM配置范围内超时!");
            }
        }
        return actDetailIdList;
    }

    /**
     * 组装拜访步骤明细报表tpm活动数据
     *
     * @param orderEntities
     * @param treatyEntities
     * @param reportRespVo
     * @param reqVo
     */
    protected void buildVisitStepTpmActReport(List<SfaVisitStepOrderEntity> orderEntities, List<SfaAsTreatyEntity> treatyEntities, SfaVisitStepTpmActCollectEntity actCollectEntity,
                                              SfaTpmActReportRespVo reportRespVo, SfaTpmActReportReqVo reqVo) {
        if (CollectionUtil.listNotEmptyNotSizeZero(orderEntities)) {
            SfaTpmActReportRespVo.DistributionOrder order = new SfaTpmActReportRespVo.DistributionOrder();
            orderEntities.forEach(data -> {
                if (StringUtils.isNotEmpty(data.getVisitPlanInfoId()) && data.getVisitPlanInfoId().equals(reqVo.getVisitPlanInfoId())) {
                    Map<String, List<SfaVisitStepOrderItemEntity>> itemEntityMap = sfaVisitStepOrderItemService.lambdaQuery()
                            .eq(SfaVisitStepOrderItemEntity::getOrderId, data.getId()).list()
                            .stream().collect(Collectors.groupingBy(SfaVisitStepOrderItemEntity::getItmeType));
                    itemEntityMap.entrySet().forEach(item -> {
                        List<SfaTpmActReportRespVo.DistributionOrderItem> itemList = CrmBeanUtil.copyList(item.getValue(), SfaTpmActReportRespVo.DistributionOrderItem.class);
                        if (SfaActivityEnum.bpItemType.bp.getVal().equals(item.getKey())) {
                            order.setBpProductList(itemList);
                        } else {
                            order.setZpProductList(itemList);
                        }
                    });
                    reportRespVo.setDistributionOrder(order);
                }
            });
        }
        if (CollectionUtil.listNotEmptyNotSizeZero(treatyEntities)) {
            treatyEntities.forEach(data -> {
                if (StringUtils.isNotEmpty(data.getTerminalCode()) && data.getTerminalCode().equals(reqVo.getTerminalCode())) {
                    reportRespVo.setTreatyPdfUrl(data.getUrlPathPrefix() + data.getUrlPath());
                    reportRespVo.setUrlPath(data.getUrlPath());
                    reportRespVo.setUrlPathPrefix(data.getUrlPathPrefix());
                    reportRespVo.setObjectName(data.getObjectName());
                }
//                if (StringUtils.isNotEmpty(data.getVisitPlanInfoId()) && data.getVisitPlanInfoId().equals(reqVo.getVisitPlanInfoId())) {
//                }
            });
        }
        if (null != actCollectEntity) {
            SfaTpmActReportRespVo.ActCollectData actCollectData = new SfaTpmActReportRespVo.ActCollectData();
            actCollectData.setActDesc(actCollectEntity.getActDesc());
            Map<String, List<SfaAttachmentEntity>> attachmentMap = sfaAttachmentService.lambdaQuery()
                    .eq(SfaAttachmentEntity::getBizId, actCollectEntity.getId()).list()
                    .stream().collect(Collectors.groupingBy(at -> at.getAttachmentBizType() + RedisParam.DELIMITER + at.getAttachmentBizTypeName()));
            List<SfaTpmActReportRespVo.CollectForm> collectFormList = new ArrayList<>();
            attachmentMap.entrySet().forEach(am -> {
                String[] expandType = am.getKey().split(RedisParam.DELIMITER);
                List<AttachmentVo> attachmentVos = CrmBeanUtil.copyList(am.getValue(), AttachmentVo.class);
                SfaTpmActReportRespVo.CollectForm collectForm = new SfaTpmActReportRespVo.CollectForm();
                collectForm.setExampleCode(expandType[0]);
                collectForm.setExampleName(expandType[1]);
                collectForm.setAttachmentList(attachmentVos);
                collectFormList.add(collectForm);
            });
            actCollectData.setCollectFormList(collectFormList);
            reportRespVo.setActCollectData(actCollectData);
        }
    }


}
