package com.biz.crm.tpmact.service.impl;

import com.alibaba.excel.util.CollectionUtils;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.ApiResultUtil;
import com.biz.crm.common.GlobalDictConstants;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.mdm.product.MdmProductFeign;
import com.biz.crm.nebular.mdm.product.resp.MdmProductBaseDataRespVo;
import com.biz.crm.nebular.mdm.product.resp.MdmProductRespVo;
import com.biz.crm.nebular.sfa.tpmact.actcollect.SfaTpmActCollectVo;
import com.biz.crm.nebular.sfa.tpmact.req.*;
import com.biz.crm.nebular.sfa.tpmact.resp.SfaTpmActRespVo;
import com.biz.crm.nebular.sfa.tpmact.resp.SfaTpmActTableRespVo;
import com.biz.crm.nebular.tpm.act.resp.TpmActDetailRespVo;
import com.biz.crm.nebular.tpm.act.resp.TpmActRespVo;
import com.biz.crm.nebular.tpm.auditcollectexample.resp.TpmAuditCollectExampleRespVo;
import com.biz.crm.nebular.tpm.costtypefine.resp.TpmCostTypeFineRespVo;
import com.biz.crm.tpm.act.TpmActFeign;
import com.biz.crm.tpmact.mapper.SfaTpmActMapper;
import com.biz.crm.tpmact.model.*;
import com.biz.crm.tpmact.service.*;
import com.biz.crm.util.*;
import com.biz.crm.visitstep.model.SfaVisitStepOrderEntity;
import com.biz.crm.visitstep.service.ISfaVisitStepOrderItemService;
import com.biz.crm.visitstep.service.ISfaVisitStepOrderService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * tpm活动接口实现
 *
 * @author lf
 * @date 2021-06-10 16:44:26
 */
@Slf4j
@Service
@ConditionalOnMissingBean(name = "SfaTpmActServiceExpandImpl")
public class SfaTpmActServiceImpl<M extends BaseMapper<T>, T> extends ServiceImpl<SfaTpmActMapper, SfaTpmActEntity> implements ISfaTpmActService {

  @Resource
  private SfaTpmActMapper sfaTpmActMapper;
  @Resource
  private TpmActFeign tpmActFeign;
  @Autowired
  private ISfaTpmActDetailService sfaTpmActDetailService;
  @Autowired
  private ISfaTpmActDetailProductService sfaTpmActDetailProductService;
  @Autowired
  private ISfaTpmCostTypeFineService sfaTpmCostTypeFineService;
  @Autowired
  private ISfaTpmAuditCollectExampleService sfaTpmAuditCollectExampleService;
  @Autowired
  private ISfaTpmAuditCollectExamplePictureService sfaTpmAuditCollectExamplePictureService;
  @Resource
  private MdmProductFeign mdmProductFeign;
  @Resource
  private ISfaVisitStepTpmActCollectService sfaVisitStepTpmActCollectService;

  @Autowired
  private ISfaVisitStepOrderService iSfaVisitStepOrderService;

  /**
   * 列表
   *
   * @param reqVo
   * @return
   */
  @Override
  public PageResult<SfaTpmActRespVo> findList(SfaTpmActReqVo reqVo) {
    Page<SfaTpmActRespVo> page = PageUtil.buildPage(reqVo.getPageNum(), reqVo.getPageSize());
    List<SfaTpmActRespVo> list = sfaTpmActMapper.findList(page, reqVo);
    if (!CollectionUtils.isEmpty(list)) {
      List<String> orderCodes = list.stream().map(SfaTpmActRespVo::getActDetailCode).collect(Collectors.toList());
      List<SfaVisitStepOrderEntity> orders = iSfaVisitStepOrderService.findByActCodes(orderCodes);
      Map<String, List<SfaVisitStepOrderEntity>> orderMap = Maps.newHashMap();
      orders.forEach(order -> {
        List<SfaVisitStepOrderEntity> orderEntities = Lists.newArrayList();
        if (orderMap.containsKey(order.getActDetailCode())) {
          orderEntities.addAll(orderMap.get(order.getActDetailCode()));
        }
        orderEntities.add(order);
        orderMap.put(order.getActDetailCode(), orderEntities);
      });
      list.forEach(act -> {
        if (orderMap.containsKey(act.getActDetailCode())) {
          List<SfaVisitStepOrderEntity> orderEntities = orderMap.get(act.getActDetailCode());
          BigDecimal amount = BigDecimal.ZERO;
          for (SfaVisitStepOrderEntity orderEntity : orderEntities) {
            amount = amount.add(orderEntity.getTotalPrice());
          }
          act.setUsedAmount(amount);
        }
      });
    }
    return PageResult.<SfaTpmActRespVo>builder()
            .data(list)
            .count(page.getTotal())
            .build();
  }

  /**
   * 查询
   *
   * @param reqVo
   * @return sfaTpmActRespVo
   */
  @Override
  public SfaTpmActRespVo query(SfaTpmActReqVo reqVo) {
    return null;
  }

  /**
   * 新增
   *
   * @param reqVo
   * @return
   */
  @Override
  @Transactional(rollbackFor = Exception.class)
  public void save(SfaTpmActReqVo reqVo) {
    SfaTpmActEntity entity = CrmBeanUtil.copy(reqVo, SfaTpmActEntity.class);
    this.save(entity);
  }

  @Override
  public void saveTpmAct(String actId) {
    Result<TpmActRespVo> result = tpmActFeign.query(actId);
    if (result.isSuccess() && null != result.getResult()) {
      TpmActRespVo tpmActVo = result.getResult();
      SfaTpmActEntity actEntity = CrmBeanUtil.copy(tpmActVo, SfaTpmActEntity.class);
      actEntity.setBeginDate(actEntity.getBeginDate().split(" ")[0]);
      actEntity.setEndDate(actEntity.getEndDate().split(" ")[0]);
      //活动明细
      List<TpmActDetailRespVo> tpmActDetailVos = tpmActVo.getDetailVos();
      List<SfaTpmActDetailEntity> actDetailEntities = new ArrayList<>();
      List<SfaTpmCostTypeFineEntity> sfaTpmCostTypeFineEntities = new ArrayList<>();
      List<SfaTpmActDetailProductEntity> tpmActDetailProductEntityList = new ArrayList<>();
      tpmActDetailVos.forEach(data -> {
        if (YesNoEnum.yesNoEnum.Y.getValue().equals(data.getIsSendSfa())) {
          SfaTpmActDetailEntity detailEntity = CrmBeanUtil.copy(data, SfaTpmActDetailEntity.class);
          //活动明细
          this.actDetailProductList(data, tpmActDetailProductEntityList);
          //活动细类
          this.actCostTypeFine(data, sfaTpmCostTypeFineEntities);
          actDetailEntities.add(detailEntity);
        }
      });
      if (CollectionUtil.listNotEmptyNotSizeZero(actDetailEntities)) {
        this.saveOrUpdate(actEntity);
        this.sfaTpmActDetailService.saveOrUpdateBatch(actDetailEntities);
      }
    }
  }

  @Override
  public void closedTpmAct(String actId) {
    Result<TpmActRespVo> result = tpmActFeign.query(actId);
    if (result.isSuccess() && null != result.getResult()) {
      SfaTpmActEntity sfaTpmActEntity = this.lambdaQuery()
              .eq(SfaTpmActEntity::getId, actId)
              .or()
              .eq(SfaTpmActEntity::getActCode, result.getResult().getActCode()).one();
      if (null != sfaTpmActEntity) {
        sfaTpmActEntity = CrmBeanUtil.copy(result.getResult(), SfaTpmActEntity.class);
        sfaTpmActEntity.setBeginDate(sfaTpmActEntity.getBeginDate().split(" ")[0]);
        sfaTpmActEntity.setEndDate(sfaTpmActEntity.getEndDate().split(" ")[0]);
        this.saveOrUpdate(sfaTpmActEntity);
      }
    }
  }

  /**
   * 进行活动完全核销
   *
   * @param actId
   */
  @Override
  public void allAudit(String actId) {
    Result<TpmActRespVo> result = tpmActFeign.query(actId);
    if (result.isSuccess() && null != result.getResult()) {
      TpmActRespVo tpmActRespVo = result.getResult();
      List<TpmActDetailRespVo> detailVos = tpmActRespVo.getDetailVos();
      SfaTpmActEntity sfaTpmActEntity = this.lambdaQuery()
              .eq(SfaTpmActEntity::getId, actId)
              .or()
              .eq(SfaTpmActEntity::getActCode, tpmActRespVo.getActCode())
              .one();
      if (null != sfaTpmActEntity) {
        sfaTpmActEntity = CrmBeanUtil.copy(result.getResult(), SfaTpmActEntity.class);
        sfaTpmActEntity.setBeginDate(sfaTpmActEntity.getBeginDate().split(" ")[0]);
        sfaTpmActEntity.setEndDate(sfaTpmActEntity.getEndDate().split(" ")[0]);
        this.saveOrUpdate(sfaTpmActEntity);
      }
      detailVos.forEach(data -> {
        SfaTpmActDetailEntity actDetailEntity = this.sfaTpmActDetailService.lambdaQuery()
                .eq(SfaTpmActDetailEntity::getActDetailCode, data.getActDetailCode()).one();
        if (actDetailEntity != null) {
          actDetailEntity = CrmBeanUtil.copy(data, SfaTpmActDetailEntity.class);
          this.sfaTpmActDetailService.saveOrUpdate(actDetailEntity);
        }
      });
    }
  }

  /**
   * tpm活动-执行数据明细报表
   *
   * @param reqVo
   * @return
   */
  @Override
  public PageResult<SfaTpmActTableRespVo> findTpmActExecuteDataTable(SfaTpmActTableReqVo reqVo) {
    Page<SfaTpmActTableRespVo> page = new Page<>(reqVo.getPageNum(), reqVo.getPageSize());
    List<SfaTpmActTableRespVo> result = sfaTpmActMapper.findTableList(page, reqVo);
    return PageResult.<SfaTpmActTableRespVo>builder()
            .data(result)
            .count(page.getTotal())
            .build();
  }

  /**
   * tpm活动-执行数据明细报表详情
   *
   * @param id
   * @return
   */
  @Override
  public SfaTpmActTableRespVo loadTpmActCollectDetailTableById(String id) {
    Page<SfaTpmActTableRespVo> page = new Page<>();
    SfaTpmActTableReqVo reqVo = new SfaTpmActTableReqVo();
    reqVo.setId(id);
    List<SfaTpmActTableRespVo> tableList = sfaTpmActMapper.findTableList(page, reqVo);
    if (tableList.isEmpty()) {
      return new SfaTpmActTableRespVo();
    }
    SfaTpmActTableRespVo result = tableList.get(0);
    SfaTpmActCollectVo sfaTpmActCollectVo = sfaVisitStepTpmActCollectService.loadTpmActCollectDetail(id);
    if (!ObjectUtils.isEmpty(sfaTpmActCollectVo)) {
      result.setActDemand(sfaTpmActCollectVo.getActDemand());
      result.setCollectFormList(sfaTpmActCollectVo.getCollectFormList());
    }
    return result;
  }

  /**
   * 活动商品
   *
   * @param data                          活动明细
   * @param tpmActDetailProductEntityList 活动商品
   */
  protected void actDetailProductList(TpmActDetailRespVo data, List<SfaTpmActDetailProductEntity> tpmActDetailProductEntityList) {
    if (CollectionUtil.listNotEmptyNotSizeZero(data.getGiftProductList())) {
      List<SfaTpmActDetailProductEntity> zpProductList = data.getGiftProductList().stream().map(pd -> {
        SfaTpmActDetailProductEntity productEntity = CrmBeanUtil.copy(pd, SfaTpmActDetailProductEntity.class);
        productEntity.setIsGiftProduct(YesNoEnum.yesNoEnum.Y.getValue());
        return productEntity;
      }).collect(Collectors.toList());
      tpmActDetailProductEntityList.addAll(zpProductList);
    }
    if (CollectionUtil.listNotEmptyNotSizeZero(data.getNormalProductList())) {
      List<SfaTpmActDetailProductEntity> bpProductList = data.getNormalProductList().stream().map(pd -> {
        SfaTpmActDetailProductEntity productEntity = CrmBeanUtil.copy(pd, SfaTpmActDetailProductEntity.class);
        productEntity.setIsGiftProduct(YesNoEnum.yesNoEnum.N.getValue());
        return productEntity;
      }).collect(Collectors.toList());
      tpmActDetailProductEntityList.addAll(bpProductList);
    }
    if (StringUtils.isNotEmpty(data.getProductCode())) {
      SfaTpmActDetailProductEntity productEntity = new SfaTpmActDetailProductEntity();
      productEntity.setActCode(data.getActCode());
      productEntity.setActDetailCode(data.getActDetailCode());
      productEntity.setIsGiftProduct(YesNoEnum.yesNoEnum.N.getValue());
      productEntity.setProductCode(data.getProductCode());
      productEntity.setProductName(data.getProductName());
      tpmActDetailProductEntityList.add(productEntity);
    }
    if (CollectionUtil.listNotEmptyNotSizeZero(tpmActDetailProductEntityList)) {
      List<String> productCodeList = tpmActDetailProductEntityList.stream().map(SfaTpmActDetailProductEntity::getProductCode).collect(Collectors.toList());
      Result<List<MdmProductBaseDataRespVo>> productResult = mdmProductFeign.findProductBaseSourceSfaTpmAct(productCodeList);
      Map<String, MdmProductBaseDataRespVo> productMap = ApiResultUtil.objResult(productResult, productResult.isSuccess())
              .stream().collect(Collectors.toMap(MdmProductBaseDataRespVo::getProductCode, k -> k));
      tpmActDetailProductEntityList.forEach(pd -> {
        if (productMap.containsKey(pd.getProductCode())) {
          MdmProductBaseDataRespVo respVo = productMap.get(pd.getProductCode());
          //价格的重新设置
          pd.setPrice(respVo.getPrice() != null ? respVo.getPrice() : BigDecimal.ZERO);
          pd.setSpec(StringUtils.isNotEmpty(respVo.getSpec()) ? respVo.getSpec() : "");
          pd.setSfaPicUrl(StringUtils.isNotEmpty(respVo.getSfaPicUrl()) ? respVo.getSfaPicUrl() : "");
          pd.setSaleUnit(respVo.getSaleUnit());
          pd.setSaleUnitName(respVo.getSaleUnitName());
          pd.setPrimaryPictureUrl(StringUtils.isNotEmpty(respVo.getPrimaryPictureUrl()) ? respVo.getPrimaryPictureUrl() : "");
        }
      });
      this.sfaTpmActDetailProductService.saveOrUpdateBatch(tpmActDetailProductEntityList);
    }
  }

  /**
   * 活动细类
   *
   * @param data
   * @param tpmCostTypeFineEntities
   */
  protected void actCostTypeFine(TpmActDetailRespVo data, List<SfaTpmCostTypeFineEntity> tpmCostTypeFineEntities) {
    if (null != data.getFineRespVo()) {
      TpmCostTypeFineRespVo costTypeFineRespVo = data.getFineRespVo();
      SfaTpmCostTypeFineEntity costTypeFineEntity = CrmBeanUtil.copy(costTypeFineRespVo, SfaTpmCostTypeFineEntity.class);
      tpmCostTypeFineEntities.add(costTypeFineEntity);
      if (CollectionUtil.listNotEmptyNotSizeZero(costTypeFineRespVo.getCollectRequires())) {
        List<TpmAuditCollectExampleRespVo> collectRequires = costTypeFineRespVo.getCollectRequires();
        List<SfaTpmAuditCollectExamplePictureEntity> pictureEntities = new ArrayList<>();
        collectRequires.forEach(c -> {
          if (CollectionUtil.listNotEmptyNotSizeZero(c.getPictureRespVos())) {
            List<SfaTpmAuditCollectExamplePictureEntity> pictureEntityList = CrmBeanUtil.copyList(c.getPictureRespVos(), SfaTpmAuditCollectExamplePictureEntity.class);
            pictureEntities.addAll(pictureEntityList);
          }
        });
        List<SfaTpmAuditCollectExampleEntity> collectExampleEntities = CrmBeanUtil.copyList(collectRequires, SfaTpmAuditCollectExampleEntity.class);
        //保存活动细类-执行控制
        this.sfaTpmAuditCollectExampleService.saveOrUpdateBatch(collectExampleEntities);
        if (CollectionUtil.listNotEmptyNotSizeZero(pictureEntities)) {
          //活动细类-执行控制(示例图片)
          this.sfaTpmAuditCollectExamplePictureService.saveOrUpdateBatch(pictureEntities);
        }
      }
      //保存活动细类
      this.sfaTpmCostTypeFineService.saveOrUpdate(costTypeFineEntity);
    }
  }


}
