package com.biz.crm.tpmact.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BusinessException;
import com.biz.crm.base.attachment.ISfaAttachmentService;
import com.biz.crm.base.attachment.SfaAttachmentEntity;
import com.biz.crm.common.param.RedisParam;
import com.biz.crm.eunm.sfa.SfaCodeEnum;
import com.biz.crm.eunm.sfa.SfaVisitEnum;
import com.biz.crm.mdm.terminal.MdmTerminalFeign;
import com.biz.crm.nebular.activiti.vo.AttachmentVo;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalVo;
import com.biz.crm.nebular.sfa.tpmact.SfaTpmActOrderCollectVo;
import com.biz.crm.nebular.sfa.tpmact.VisitBaseVo;
import com.biz.crm.nebular.sfa.tpmact.actcollect.SfaTpmActCollectVo;
import com.biz.crm.nebular.sfa.tpmact.resp.SfaTpmActDetailExecuteRespVo;
import com.biz.crm.service.RedisService;
import com.biz.crm.tpmact.mapper.SfaVisitStepTpmActCollectMapper;
import com.biz.crm.tpmact.model.SfaTpmAuditCollectExamplePictureEntity;
import com.biz.crm.tpmact.model.SfaVisitStepTpmActCollectEntity;
import com.biz.crm.tpmact.service.ISfaTpmActDetailExecuteService;
import com.biz.crm.tpmact.service.ISfaTpmAuditCollectExamplePictureService;
import com.biz.crm.tpmact.service.ISfaVisitStepTpmActCollectService;
import com.biz.crm.util.*;
import com.biz.crm.visitinfo.model.SfaVisitPlanInfoEntity;
import com.biz.crm.visitstep.resp.SfaVisitStepFromRespVo;
import com.biz.crm.visitstep.service.ISfaVisitStepOrderService;
import com.biz.crm.visitstepbase.VisitBaseCheck;
import com.biz.crm.visitstepbase.VisitBaseComponent;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

import javax.annotation.Resource;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 拜访步骤-tpm活动数据采集接口实现
 *
 * @author lf
 * @date 2021-06-13 20:32:45
 */
@Slf4j
@Service
@ConditionalOnMissingBean(name = "SfaVisitStepTpmActCollectServiceExpandImpl")
@Transactional
public class SfaVisitStepTpmActCollectServiceImpl<M extends BaseMapper<T>, T> extends ServiceImpl<SfaVisitStepTpmActCollectMapper, SfaVisitStepTpmActCollectEntity> implements ISfaVisitStepTpmActCollectService {

    @Resource
    private SfaVisitStepTpmActCollectMapper sfaVisitStepTpmActCollectMapper;
    @Resource
    private MdmTerminalFeign mdmTerminalFeign;
    @Autowired
    private ISfaAttachmentService sfaAttachmentService;
    @Resource
    private RedisService redisService;
    @Resource
    private VisitBaseComponent visitBaseComponent;
    @Resource
    private ISfaTpmAuditCollectExamplePictureService sfaTpmAuditCollectExamplePictureService;
    @Resource
    private ISfaVisitStepOrderService sfaVisitStepOrderService;
    @Autowired
    private ISfaTpmActDetailExecuteService sfaTpmActDetailExecuteService;


    /**
     * tpm活动-活动数据采集保存
     *
     * @param vo
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public String saveWorkBenchActCollect(SfaTpmActCollectVo vo) {
        AssertUtils.isNotEmpty(vo.getClientCode(), "终端编码为空");
        AssertUtils.isNotEmpty(vo.getClientName(), "终端名称为空");
        AssertUtils.isNotEmpty(vo.getActDetailCode(), "活动明细编码为空");
        if (null == vo.getLineStatus() || SfaVisitEnum.VISIT_OFF_LINE.online.getVal().equals(vo.getLineStatus())) {
            AssertUtils.isNotEmpty(vo.getCollectFormList(), "活动图片采集为空");
            this.visitBaseComponent.checkActTpmCollectPicList(vo.getCollectFormList());
        }
        SfaVisitStepTpmActCollectEntity collectEntity = CrmBeanUtil.copy(vo, SfaVisitStepTpmActCollectEntity.class);
        if (StringUtils.isNotEmpty(vo.getVisitPlanInfoId())) {
            SfaVisitStepTpmActCollectEntity oldCollectEntity = this.lambdaQuery()
                    .eq(SfaVisitStepTpmActCollectEntity::getVisitPlanInfoId, vo.getVisitPlanInfoId())
                    .eq(SfaVisitStepTpmActCollectEntity::getActDetailCode, vo.getActDetailCode()).one();
            if (oldCollectEntity != null) {
                collectEntity = CrmBeanUtil.copy(oldCollectEntity, SfaVisitStepTpmActCollectEntity.class);
            }
        }
        this.buildEntity(collectEntity, vo.getClientCode());
        this.saveOrUpdate(collectEntity);
        vo.setId(collectEntity.getId());
//        Map<String, List<SfaTpmActCollectFormVo>> collectMap = (Map<String, List<SfaTpmActCollectFormVo>>) redisService.hmget(SfaTpmActDetailRespVo.buildRedisKey(vo.getActDetailCode()));
//        List<SfaTpmActCollectFormVo> formVos = collectMap.get(vo.getActDetailCode());
        if (null == vo.getLineStatus() || SfaVisitEnum.VISIT_OFF_LINE.online.getVal().equals(vo.getLineStatus())) {
            //图片保存
            this.saveExtAttachmentList(vo.getCollectFormList(), collectEntity.getId());
        }
        this.redisService.hmset(SfaTpmActCollectVo.getRedisHashKey(collectEntity.getId()), SfaTpmActCollectVo.buildMap(collectEntity.getId(), vo), SfaTpmActCollectVo.redis_expire_time);
        //进行业务动态的保存
        collectEntity.setId(collectEntity.getActDetailCode());
        visitBaseComponent.tpmDoListener(collectEntity);
        //保存活动执行数据
        SfaTpmActDetailExecuteRespVo executeRespVo = new SfaTpmActDetailExecuteRespVo();
        executeRespVo.setTerminalCode(vo.getClientCode());
        executeRespVo.setActDetailCode(vo.getActDetailCode());
        sfaTpmActDetailExecuteService.saveTpmActExecute(executeRespVo);
        return collectEntity.getId();
    }

    /**
     * tpm活动-活动数据采集-查询详情
     *
     * @param id
     * @return
     */
    @Override
    public SfaTpmActCollectVo loadTpmActCollectDetail(String id) {
        SfaTpmActCollectVo collectVo = (SfaTpmActCollectVo) this.redisService.hmget(SfaTpmActCollectVo.getRedisHashKey(id), id);
        if (null == collectVo) {
            SfaVisitStepTpmActCollectEntity collectEntity = this.lambdaQuery()
                    .eq(SfaVisitStepTpmActCollectEntity::getId, id).one();
            if (null == collectEntity) {
                throw new BusinessException("主键id错误,未查询到活动采集数据信息");
            }
            collectVo = CrmBeanUtil.copy(collectEntity, SfaTpmActCollectVo.class);
            List<SfaAttachmentEntity> attachmentEntities = this.sfaAttachmentService.lambdaQuery()
                    .eq(SfaAttachmentEntity::getBizId, id).list();
            Map<String, List<SfaAttachmentEntity>> attachmentMap = attachmentEntities.stream()
                    .collect(Collectors.groupingBy(data -> data.getAttachmentBizType() + RedisParam.DELIMITER + data.getAttachmentBizTypeName()));
            List<SfaTpmActCollectVo.CollectForm> collectFormList = new ArrayList<>();
            for (Map.Entry<String, List<SfaAttachmentEntity>> data : attachmentMap.entrySet()) {
                String[] param = data.getKey().split(RedisParam.DELIMITER);
                List<AttachmentVo> attachmentVos = CrmBeanUtil.copyList(data.getValue(), AttachmentVo.class);
                SfaTpmActCollectVo.CollectForm form = new SfaTpmActCollectVo.CollectForm();
                form.setExampleCode(param[0]);
                form.setExampleName(param[1]);
                form.setAttachmentList(attachmentVos);
                List<SfaTpmAuditCollectExamplePictureEntity> pictureEntityList = this.sfaTpmAuditCollectExamplePictureService.lambdaQuery()
                        .eq(SfaTpmAuditCollectExamplePictureEntity::getExampleCode, param[0]).list();
                if (CollectionUtil.listNotEmptyNotSizeZero(pictureEntityList)) {
                    form.setPictList(pictureEntityList.stream().map(SfaTpmAuditCollectExamplePictureEntity::getUrlAddress).collect(Collectors.toList()));
                }
                collectFormList.add(form);
            }
            collectVo.setCollectFormList(collectFormList);

            //采集要求（照片类型名称）
            String actDemand = attachmentEntities.stream().distinct().map(SfaAttachmentEntity::getAttachmentBizTypeName)
                    .collect(Collectors.toList()).stream().collect(Collectors.joining("、"));
            collectVo.setActDemand(actDemand);
        }
        this.redisService.hmset(SfaTpmActCollectVo.getRedisHashKey(id), SfaTpmActCollectVo.buildMap(id, collectVo), SfaTpmActCollectVo.redis_expire_time);
        return collectVo;
    }

    /**
     * 拜访步骤-tpm活动-活动数据采集
     *
     * @param vo
     */
    @Override
    public String saveVisitStepActCollect(VisitBaseVo<SfaTpmActCollectVo> vo) {
        //基础数据校验
        VisitBaseCheck.checkBaseData(vo);
        SfaTpmActCollectVo collectVo = vo.getStepExecuteData();
        collectVo.setStepCode(SfaVisitEnum.visitStep.tpm);
        collectVo.setFormId(vo.getFormId());
        SfaVisitPlanInfoEntity.VisitRedisHashKey visitRedisHashKey = new SfaVisitPlanInfoEntity.VisitRedisHashKey(vo.getRedisHashKey());
        SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity = visitBaseComponent.loadAndCheckSfaVisitPlanInfoEntity(vo.getRedisHashKey(), visitRedisHashKey.getVisitBigType());
        collectVo.setVisitPlanInfoId(sfaVisitPlanInfoEntity.getId());
        collectVo.setStepCode(SfaCodeEnum.VisitStepCode.SFA_STEP_CODE_TPM.getVal());
        SfaVisitStepFromRespVo fromRespVo = visitBaseComponent.getFormData(vo.getFormId(), SfaCodeEnum.VisitStepCode.SFA_STEP_CODE_TPM.getVal());
        //判断为在线数据
        if (null == collectVo.getLineStatus() || SfaVisitEnum.VISIT_OFF_LINE.online.getVal().equals(collectVo.getLineStatus())) {
            VisitBaseCheck.checkVisitStepDistance(sfaVisitPlanInfoEntity, fromRespVo, collectVo.getLongitude(), collectVo.getLatitude());
        }
        //状态更新
        visitBaseComponent.updateStepStatus(vo.getRedisHashKey(), fromRespVo.getStepCode(), visitRedisHashKey.getVisitBigType());
        return this.saveWorkBenchActCollect(collectVo);
    }

    /**
     * tpm活动-分销订单、活动数据采集保存接口
     *
     * @param vo
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void saveWorkBenchActOrderCollect(SfaTpmActOrderCollectVo vo) {
        if (vo != null) {
            if (vo.getCollectVo() != null) {
                this.saveWorkBenchActCollect(vo.getCollectVo());
            }
            if (vo.getOrderVo() != null) {
                this.sfaVisitStepOrderService.saveWorkBenchDistributionOrder(vo.getOrderVo());
            }
        }
    }

    /**
     * tpm活动-根据活动明细编码查询活动执行数据
     *
     * @param actDetailCode
     * @return
     */
    @Override
    public List<SfaTpmActCollectVo> getTpmActExecuteDataByActDetailCode(String actDetailCode) {
        if (StringUtils.isEmpty(actDetailCode)) {
            throw new BusinessException("活动明细编码不能为空");
        }
        //tpm活动数据采集实体
        List<SfaVisitStepTpmActCollectEntity> sfaVisitStepTpmActCollectEntity = this.sfaVisitStepTpmActCollectMapper.selectList(Wrappers.lambdaQuery(SfaVisitStepTpmActCollectEntity.class)
                .eq(SfaVisitStepTpmActCollectEntity::getActDetailCode, actDetailCode));
        if (null == sfaVisitStepTpmActCollectEntity) {
            throw new BusinessException("未查询到活动采集数据信息");
        }
        List<SfaTpmActCollectVo> sfaTpmActCollectVos = CrmBeanUtil.copyList(sfaVisitStepTpmActCollectEntity, SfaTpmActCollectVo.class);
        sfaTpmActCollectVos.forEach(o -> {
            SfaTpmActCollectVo sfaTpmActCollectVo = this.loadTpmActCollectDetail(o.getId());
            if (!ObjectUtils.isEmpty(sfaTpmActCollectVo)) {
                o.setCollectFormList(sfaTpmActCollectVo.getCollectFormList());
            }
        });
        return sfaTpmActCollectVos;
    }


    /**
     * 组装entity
     *
     * @param entity
     * @param terminalCode
     */
    protected void buildEntity(SfaVisitStepTpmActCollectEntity entity, String terminalCode) {
        Result<MdmTerminalVo> terminalResult = mdmTerminalFeign.query(null, terminalCode);
        if (null != terminalResult && terminalResult.isSuccess() && terminalResult.getResult() != null) {
            MdmTerminalVo terminalVo = terminalResult.getResult();
            entity.setClientType(SfaVisitEnum.ClientType.TERMINAL.getVal());
            entity.setClientTypeName(SfaVisitEnum.ClientType.TERMINAL.getDesc());
            entity.setClientSubclass(terminalVo.getTerminalType());
            entity.setClientSubclassName(terminalVo.getTerminalTypeName());
        } else {
            throw new BusinessException("未查询到该终端信息,终端编码[" + terminalResult + "]");
        }
        UserRedis userRedis = UserUtils.getUser();
        entity.setUserName(userRedis.getUsername());
        entity.setRealName(userRedis.getRealname());
        entity.setPosCode(userRedis.getPoscode());
        entity.setPosName(userRedis.getPosname());
        entity.setOrgCode(userRedis.getOrgcode());
        entity.setOrgName(userRedis.getOrgname());

        entity.setCollectTime(LocalDateTime.now().format(CrmDateUtils.yyyyMMddHHmmss));
        entity.setCollectDate(LocalDateTime.now().format(CrmDateUtils.yyyyMMdd));
    }

    /**
     * 图片保存
     *
     * @param collectFormList
     * @param bizId
     */
    protected void saveExtAttachmentList(List<SfaTpmActCollectVo.CollectForm> collectFormList, String bizId) {
        this.sfaAttachmentService.remove(Wrappers.lambdaQuery(SfaAttachmentEntity.class)
                .eq(SfaAttachmentEntity::getBizId, bizId));
        List<SfaAttachmentEntity> attachmentEntities = new ArrayList<>();
        collectFormList.forEach(data -> {
            AssertUtils.isNotEmpty(data.getExampleCode(), "采集类型编码为空");
            AssertUtils.isNotEmpty(data.getExampleName(), "采集类型名称为空");
            List<SfaAttachmentEntity> picList = CrmBeanUtil.copyList(data.getAttachmentList(), SfaAttachmentEntity.class);
            picList.forEach(p -> {
                p.setBizId(bizId);
                p.setAttachmentBizType(data.getExampleCode());
                p.setAttachmentBizTypeName(data.getExampleName());
            });
            attachmentEntities.addAll(picList);
        });
        this.sfaAttachmentService.saveBatch(attachmentEntities);
    }
}
