package com.biz.crm.util;

import lombok.extern.slf4j.Slf4j;

import java.util.Calendar;
import java.util.Date;

/**
 * @author: chenlong
 * @date: 2022/3/28 16:18
 * @description:
 */
@Slf4j
public class DateStringUtils {

    /**
     * 根据时间维度获取开始年月日字符窜
     */
    public static String getStartTimeByDate(String dateType, String date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(DateUtil.parseDate(date, "yyyy-MM-dd"));
        if ("WEEK".equals(dateType)) {
            //若为周天-日期往前推减一周在加一天获取周一
            if (calendar.get(Calendar.DAY_OF_WEEK) == 1) {
                calendar.add(Calendar.WEEK_OF_MONTH, -1);
                calendar.add(Calendar.DAY_OF_MONTH, 1);
            } else {
                //日期设置本周第二天获取周一
                calendar.set(Calendar.DAY_OF_WEEK, 2);
            }
        } else if ("MONTH".equals(dateType)) {
            calendar.set(Calendar.DAY_OF_MONTH, 1);
        }
        return DateUtil.format(calendar.getTime(), "yyyy-MM-dd");
    }

    /**
     * 根据时间维度获取结束年月日字符窜
     */
    public static String getEndTimeByDate(String dateType, String date) {
        Calendar calendar = Calendar.getInstance();
        long time = calendar.getTime().getTime();
        calendar.setTime(DateUtil.parseDate(date, "yyyy-MM-dd"));
        if ("WEEK".equals(dateType)) {
            //若不为周天-日期往后推一周，获取周第一天（周天）
            if (calendar.get(Calendar.DAY_OF_WEEK) != 1) {
                calendar.add(Calendar.WEEK_OF_MONTH, 1);
                calendar.set(Calendar.DAY_OF_WEEK, 1);
            }
        } else if ("MONTH".equals(dateType)) {
            calendar.add(Calendar.MONTH, 1);
            calendar.set(Calendar.DAY_OF_MONTH, 1);
            calendar.add(Calendar.DAY_OF_MONTH, -1);
        }
        if (calendar.getTime().getTime() > time) {
            return DateUtil.format(new Date(time), "yyyy-MM-dd");
        } else {
            return DateUtil.format(calendar.getTime(), "yyyy-MM-dd");
        }
    }

    /**
     * 获取月度日期yyyy-MM
     */
    public static String getMonthTimeByDate(String date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(DateUtil.parseDate(date, "yyyy-MM-dd"));
        return DateUtil.format(calendar.getTime(), "yyyy-MM");
    }
}
