package com.biz.crm.visitdealer.controller;

import com.biz.crm.aop.CrmAPIDiscard;
import com.biz.crm.aop.CrmLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.config.CrmDictMethod;
import com.biz.crm.eunm.sfa.SfaVisitEnum;
import com.biz.crm.nebular.mdm.customer.MdmCustomerCountReqVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerCountRespVo;
import com.biz.crm.nebular.sfa.visitdealer.req.SfaVisitDealerDetailReqVo;
import com.biz.crm.nebular.sfa.visitdealer.resp.SfaVisitDealerDetailRespVo;
import com.biz.crm.util.Result;
import com.biz.crm.visitdealer.service.ISfaVisitDealerDetailService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.List;

/**
 * 经销商拜访明细;
 *
 * @author lf
 * @date 2020-11-17 11:22:50
 */
@Slf4j
@RestController
@RequestMapping("/sfaVisitDealerDetailController")
@Api(tags = "经销商拜访明细;")
public class SfaVisitDealerDetailController {
    @Resource
    private ISfaVisitDealerDetailService sfaVisitDealerDetailService;

    /**
     * 列表
     */
    @ApiOperation(value = "查询列表")
    @PostMapping("/list")
    @Deprecated
    @CrmLog
    @CrmAPIDiscard
    public Result<PageResult<SfaVisitDealerDetailRespVo>> list(@RequestBody SfaVisitDealerDetailReqVo sfaVisitDealerDetailReqVo) {
        PageResult<SfaVisitDealerDetailRespVo> result=sfaVisitDealerDetailService.findList(sfaVisitDealerDetailReqVo);
        return Result.ok(result);
    }






    /**
     * 查询经销商异常拜访明细报表
     */
    @ApiOperation(value = "查询经销商异常拜访明细报表")
    @PostMapping("/findDealerDetailExceptionReportList")
    @CrmLog
    @Deprecated
    @CrmAPIDiscard
    public Result<PageResult<SfaVisitDealerDetailRespVo>> findDealerDetailExceptionReportList(@RequestBody SfaVisitDealerDetailReqVo reqVo) {
        reqVo.setVisitStatus(SfaVisitEnum.visitStatus.V4.getVal());
        PageResult<SfaVisitDealerDetailRespVo> result=sfaVisitDealerDetailService.findList(reqVo);
        return Result.ok(result);
    }




    /**
     * 通过id查询拜访明细报表详情
     * @param id
     * @return
     */
    @CrmLog
    @ApiOperation(value = "通过id查询拜访明细报表详情")
    @GetMapping("queryVisitDetailReportById")
    @Deprecated
    @CrmAPIDiscard
    public Result<SfaVisitDealerDetailRespVo> queryVisitDetailReportById(@RequestParam String id){
        SfaVisitDealerDetailRespVo respVo = sfaVisitDealerDetailService.queryVisitDetailReportById(id);
        return Result.ok(respVo);
    }



    /**
     * 查询经销商异常拜访明细报表
     */
    @ApiOperation(value = "查询异常拜访明细报表")
    @PostMapping("/findVisitDetailExceptionReportList")
    @CrmLog
    @Deprecated
    @CrmAPIDiscard
    public Result<PageResult<SfaVisitDealerDetailRespVo>> findVisitDetailExceptionReportList(@RequestBody SfaVisitDealerDetailReqVo reqVo) {
        reqVo.setVisitStatus(SfaVisitEnum.visitStatus.V4.getVal());
        PageResult<SfaVisitDealerDetailRespVo> result=sfaVisitDealerDetailService.findList(reqVo);
        return Result.ok(result);
    }


    /**
     * 查询
     */
    @ApiOperation(value = "查询")
    @PostMapping("/query")
    @CrmLog
    @CrmDictMethod
    public Result<SfaVisitDealerDetailRespVo> query(@RequestBody SfaVisitDealerDetailReqVo sfaVisitDealerDetailReqVo) {
        SfaVisitDealerDetailRespVo respVo=sfaVisitDealerDetailService.query(sfaVisitDealerDetailReqVo);
        return Result.ok(respVo);
    }

    /**
     * 新增
     */
    @ApiOperation(value = "新增")
    @PostMapping("/save")
    @CrmLog
    @Deprecated
    @CrmAPIDiscard
    public Result save(@RequestBody SfaVisitDealerDetailReqVo sfaVisitDealerDetailReqVo) {
        sfaVisitDealerDetailService.save(sfaVisitDealerDetailReqVo);
        return Result.ok();
    }

    /**
     * 更新
     */
    @ApiOperation(value = "更新")
    @PostMapping("/update")
    @CrmLog
    @Deprecated
    @CrmAPIDiscard
    public Result update(@RequestBody SfaVisitDealerDetailReqVo sfaVisitDealerDetailReqVo) {
        sfaVisitDealerDetailService.update(sfaVisitDealerDetailReqVo);
        return Result.ok("修改成功");
    }

    /**
     * 删除
     */
    @ApiOperation(value = "删除")
    @PostMapping("/delete")
    @CrmLog
    @Deprecated
    @CrmAPIDiscard
    public Result delete(@RequestBody List<String> ids) {
        sfaVisitDealerDetailService.deleteBatch(ids);
        return Result.ok("删除成功");
    }

    /**
     * 启用
     */
    @ApiOperation(value = "启用")
    @PostMapping("/enable")
    @CrmLog
    @Deprecated
    @CrmAPIDiscard
    public Result enable(@RequestBody List<String> ids) {
        sfaVisitDealerDetailService.enableBatch(ids);
        return Result.ok("启用成功");
    }

    /**
     * 禁用
     */
    @ApiOperation(value = "禁用")
    @PostMapping("/disable")
    @CrmLog
    @Deprecated
    @CrmAPIDiscard
    public Result disable(@RequestBody List<String> ids) {
        sfaVisitDealerDetailService.disableBatch(ids);
        return Result.ok("禁用成功");
    }

    @ApiOperation(value = "查询本期对应拜访数")
    @PostMapping("/findVisitNumber")
    @CrmLog
    public Result<MdmCustomerCountRespVo> findVisitNumber(@RequestBody MdmCustomerCountReqVo reqVo){
        return Result.ok(sfaVisitDealerDetailService.findVisitNumber(reqVo));
    }


}
