package com.biz.crm.visitdealer.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.interceptor.SqlPrivilege;
import com.biz.crm.nebular.sfa.visitdealer.req.SfaVisitDealerMonthlyReportReqVo;
import com.biz.crm.nebular.sfa.visitdealer.resp.SfaVisitDealerMonthlyReportRespVo;
import com.biz.crm.visitdealer.model.SfaVisitDealerMonthlyReportEntity;
import com.bizunited.platform.saturn.engine.annotation.SaturnQueryMethod;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 经销商拜访月度报表;
 *
 * @author lf
 * @date 2020-11-20 11:21:59
 */
public interface SfaVisitDealerMonthlyReportMapper extends BaseMapper<SfaVisitDealerMonthlyReportEntity> {
    /**
     * 列表
     *
     * @param page
     * @param sfaVisitDealerMonthlyReportReqVo
     * @return
     */
    @SqlPrivilege(orgCode = "sfa_visit_dealer_monthly_report.visit_org_code",posCode = "sfa_visit_dealer_monthly_report.visit_pos_code")
    List<SfaVisitDealerMonthlyReportRespVo> findList(Page<SfaVisitDealerMonthlyReportRespVo> page, @Param("vo") SfaVisitDealerMonthlyReportReqVo sfaVisitDealerMonthlyReportReqVo);



}
