package com.biz.crm.visitdealer.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

/**
 * 经销商拜访月度报表;实体类
 *
 * @author lf
 * @date 2020-11-20 11:21:59
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("sfa_visit_dealer_monthly_report")
@CrmTable(name = "sfa_visit_dealer_monthly_report", tableNote = "经销商拜访月度报表;")
public class SfaVisitDealerMonthlyReportEntity extends CrmExtTenEntity<SfaVisitDealerMonthlyReportEntity> {

    /**
     * 人员账号;人员账号
     */
    @CrmColumn(name = "visit_user_name", length = 32, note = "人员账号;人员账号")
    private String visitUserName;

    /**
     * 人员姓名;人员姓名
     */
    @CrmColumn(name = "visit_real_name", length = 100, note = "人员姓名;人员姓名")
    private String visitRealName;

    /**
     * 人员职位编码;人员职位编码
     */
    @CrmColumn(name = "visit_pos_code", length = 32, note = "人员职位编码;人员职位编码")
    private String visitPosCode;

    /**
     * 人员职位名称;人员职位名称
     */
    @CrmColumn(name = "visit_pos_name", length = 100, note = "人员职位名称;人员职位名称")
    private String visitPosName;

    /**
     * 人员所属组织编码;人员所属组织编码
     */
    @CrmColumn(name = "visit_org_code", length = 32, note = "人员所属组织编码;人员所属组织编码")
    private String visitOrgCode;

    /**
     * 人员所属组织名称;人员所属组织名称
     */
    @CrmColumn(name = "visit_org_name", length = 100, note = "人员所属组织名称;人员所属组织名称")
    private String visitOrgName;

    /**
     * 上级组织编码
     */
    @CrmColumn(name = "visit_parent_org_code", length = 32, note = "上级组织编码")
    private String visitParentOrgCode;

    /**
     * 上级组织名称
     */
    @CrmColumn(name = "visit_parent_org_name", length = 100, note = "上级组织名称")
    private String visitParentOrgName;

    /**
     * 拜访年;拜访年yyyy
     */
    @CrmColumn(name = "visit_year", length = 4, note = "拜访年;拜访年yyyy")
    private String visitYear;

    /**
     * 拜访月;拜访年MM
     */
    @CrmColumn(name = "visit_month", length = 5, note = "拜访月;拜访年MM")
    private String visitMonth;

    /**
     * 当月已拜访客户数量
     */
    @CrmColumn(name = "visit_already_num", length = 5, note = "当月已拜访客户数量")
    private String visitAlreadyNum;

    /**
     * 销售人员客户数量
     */
    @CrmColumn(name = "sale_client_num", length = 5, note = "销售人员客户数量")
    private String saleClientNum;

    /**
     * 当月拜访客户数量
     */
    @CrmColumn(name = "visit_client_num", length = 5, note = "当月拜访客户数量")
    private String visitClientNum;

    /**
     * 未拜访客户数量
     */
    @CrmColumn(name = "visit_not_client_num", length = 5, note = "未拜访客户数量")
    private String visitNotClientNum;

    /**
     * 客户拜访率
     */
    @CrmColumn(name = "visit_client_probability", length = 6, note = "客户拜访率")
    private String visitClientProbability;

}
