package com.biz.crm.visitdealer.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.achievement.controller.AchievementRecordsMQSend;
import com.biz.crm.achievement.mapper.SfaAchievementAccomplishRecordMapper;
import com.biz.crm.achievement.model.SfaAchievementAccomplishRecordEntity;
import com.biz.crm.achievement.service.ISfaAchievementAccomplishRecordService;
import com.biz.crm.aop.CrmAPIDiscard;
import com.biz.crm.base.ApiResultUtil;
import com.biz.crm.base.BusinessException;
import com.biz.crm.base.CrmAttachment;
import com.biz.crm.collection.controller.resp.VisitStepResp;
import com.biz.crm.collection.service.ISfaVisitRoleDirectoryService;
import com.biz.crm.common.CrmRedisHashKeyVo;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.eunm.sfa.SfaVisitEnum;
import com.biz.crm.mdm.customer.MdmCustomerMsgFeign;
import com.biz.crm.mdm.org.MdmOrgFeign;
import com.biz.crm.mdm.terminal.MdmTerminalFeign;
import com.biz.crm.moblie.controller.visit.req.SfaVisitExceptionReq;
import com.biz.crm.moblie.controller.visit.req.SfaVisitInOutReq;
import com.biz.crm.moblie.controller.visit.resp.SfaVisitExceptionResp;
import com.biz.crm.moblie.controller.visit.resp.SfaVisitExecuteResp;
import com.biz.crm.moblie.visitoffline.stepcomponent.photoutil.SfaVisitStepOffLineUtil;
import com.biz.crm.nebular.mdm.customer.*;
import com.biz.crm.nebular.mdm.org.req.MdmOrgReqVo;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgRespVo;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalContactPageReqVo;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalContactPageVo;
import com.biz.crm.nebular.mdm.terminal.req.UpdateCoordinateReqVo;
import com.biz.crm.nebular.sfa.achievement.req.SfaAchievementAccomplishRecordReqVo;
import com.biz.crm.nebular.sfa.achievement.resp.SfaAchievementTimeTotalRespVo;
import com.biz.crm.nebular.sfa.collection.req.FindVisitDetailReqVo;
import com.biz.crm.nebular.sfa.collection.req.SfaVisitRoleConfigReqVo;
import com.biz.crm.nebular.sfa.collection.resp.SfaVisitRoleDirectoryRespVo;
import com.biz.crm.nebular.sfa.picture.req.SfaVisitPictureReqVo;
import com.biz.crm.nebular.sfa.picture.resp.SfaVisitPictureRespVo;
import com.biz.crm.nebular.sfa.visitdealer.req.SfaVisitDealerDetailReqVo;
import com.biz.crm.nebular.sfa.visitdealer.resp.SfaVisitDealerDetailRespVo;
import com.biz.crm.nebular.sfa.visitinfo.req.SfaVisitPlanInfoReqVo;
import com.biz.crm.nebular.sfa.visitinfo.resp.SfaVisitPlanInfoRespVo;
import com.biz.crm.picture.model.SfaVisitPictureEntity;
import com.biz.crm.picture.service.ISfaVisitPictureService;
import com.biz.crm.service.RedisService;
import com.biz.crm.util.*;
import com.biz.crm.visitdealer.mapper.SfaVisitDealerDetailMapper;
import com.biz.crm.visitdealer.model.SfaVisitDealerDetailEntity;
import com.biz.crm.visitdealer.service.ISfaVisitDealerDetailService;
import com.biz.crm.visitinfo.mapper.SfaVisitPlanInfoMapper;
import com.biz.crm.visitinfo.model.SfaVisitPlanInfoEntity;
import com.biz.crm.visitinfo.model.SfaVisitPlanInfoExecuteRedisData;
import com.biz.crm.visitinfo.model.SfaVisitPlanInfoRedisData;
import com.biz.crm.visitinfo.repositories.SfaVisitPlanInfoEntityRepositories;
import com.biz.crm.visitinfo.req.VisitPlanInfoEsReq;
import com.biz.crm.visitinfo.service.ISfaVisitInfoStepFormService;
import com.biz.crm.visitinfo.service.ISfaVisitPlanInfoService;
import com.biz.crm.visitstep.model.SfaVisitStepFromEntity;
import com.biz.crm.visitstep.resp.SfaVisitStepFromRespVo;
import com.biz.crm.visitstep.service.ISfaVisitStepFromService;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

/**
 * 经销商拜访明细;接口实现
 *
 * @author lf
 * @date 2020-11-17 11:22:50
 */
@Slf4j
@Service
@ConditionalOnMissingBean(name = "SfaVisitDealerDetailServiceExpandImpl")
public class SfaVisitDealerDetailServiceImpl<M extends BaseMapper<T>, T> extends ServiceImpl<SfaVisitDealerDetailMapper, SfaVisitDealerDetailEntity> implements ISfaVisitDealerDetailService {

    @Resource
    protected SfaVisitDealerDetailMapper sfaVisitDealerDetailMapper;
    @Resource
    protected SfaVisitPlanInfoMapper sfaVisitPlanInfoMapper;
    @Resource
    protected MdmOrgFeign mdmOrgFeign;
    @Resource
    protected MdmTerminalFeign mdmTerminalFeign;
    @Resource
    protected MdmCustomerMsgFeign mdmCustomerMsgFeign;
    @Resource
    protected ISfaVisitRoleDirectoryService sfaVisitRoleDirectoryService;
    @Resource
    protected RedisService redisService;
    @Resource
    protected ISfaVisitPlanInfoService sfaVisitPlanInfoService;

    @Resource
    protected ISfaVisitStepFromService sfaVisitStepFromService;
    @Resource
    protected SfaAchievementAccomplishRecordMapper achievementAccomplishRecordMapper;
    @Resource
    protected ISfaAchievementAccomplishRecordService sfaAchievementAccomplishRecordService;

    @Resource
    protected SfaVisitPlanInfoEntityRepositories sfaVisitPlanInfoEntityRepositories;
    @Resource
    private ISfaVisitInfoStepFormService sfaVisitInfoStepFormService;

    /**
     * 列表
     *
     * @param reqVo
     * @return
     */
    @Override
    public PageResult<SfaVisitDealerDetailRespVo> findList(SfaVisitDealerDetailReqVo reqVo) {
        Page<SfaVisitDealerDetailRespVo> page = new Page<>(reqVo.getPageNum(), reqVo.getPageSize());
        List<SfaVisitDealerDetailRespVo> list = sfaVisitDealerDetailMapper.findList(page, reqVo);
        for (SfaVisitDealerDetailRespVo data : list) {
            SfaVisitPictureReqVo pictureReqVo = new SfaVisitPictureReqVo() {{
                this.setBusinessId(data.getId());
            }};
            List<SfaVisitPictureRespVo> sfaVisitPictureRespVos = sfaVisitPictureService.findSfaVisitPictureList(pictureReqVo);
            if (CollectionUtil.listNotEmptyNotSizeZero(sfaVisitPictureRespVos)) {
                data.setPhotoList(sfaVisitPictureRespVos);
                Map<String, List<SfaVisitPictureRespVo>> picMap = sfaVisitPictureRespVos.stream().collect(Collectors.groupingBy(SfaVisitPictureRespVo::getPicType));
                List<String> inStorePicList = Lists.newArrayList();
                List<String> outStorePicList = Lists.newArrayList();
                for (Map.Entry<String, List<SfaVisitPictureRespVo>> pic : picMap.entrySet()) {
                    if (pic.getKey().equals(SfaVisitEnum.visitPicType.DEALER_IN_STORE_PIC.getVal())) {
                        pic.getValue().forEach(p -> {
                            inStorePicList.add(p.getPicUrl() + p.getPicPath());
                        });
                    } else if (pic.getKey().equals(SfaVisitEnum.visitPicType.DEALER_OUT_STORE_PIC.getVal())) {
                        pic.getValue().forEach(p -> {
                            outStorePicList.add(p.getPicUrl() + p.getPicPath());
                        });
                    }
                }
            }
        }
        return PageResult.<SfaVisitDealerDetailRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    /**
     * 通过id查询拜访明细报表信息
     *
     * @param id
     * @return
     */
    @Override
    @Deprecated
    @CrmAPIDiscard
    public SfaVisitDealerDetailRespVo queryVisitDetailReportById(String id) {
        SfaVisitDealerDetailEntity sfaVisitDealerDetailEntity = this.lambdaQuery()
                .eq(SfaVisitDealerDetailEntity::getId, id).one();
        if (sfaVisitDealerDetailEntity == null) {
            throw new BusinessException("未查询到拜访明细报表详细信息");
        }
        FindVisitDetailReqVo reqVo = new FindVisitDetailReqVo() {{
            this.setVisitType(SfaVisitEnum.sfaVisitType.VISIT.getVal());
            this.setVisitId(id);
            this.setVisitUserName(sfaVisitDealerDetailEntity.getVisitUserName());
            this.setVisitPosCode(sfaVisitDealerDetailEntity.getVisitPosCode());
            this.setSfacusType(sfaVisitDealerDetailEntity.getClientType());
        }};
        List<SfaVisitRoleDirectoryRespVo> roleDirectoryRespVos = sfaVisitRoleDirectoryService.findVisitDetail(reqVo);
        Map<String, String> stepMap = this.stepVisitDetail(roleDirectoryRespVos);
        SfaVisitDealerDetailRespVo respVo = CrmBeanUtil.copy(sfaVisitDealerDetailEntity, SfaVisitDealerDetailRespVo.class);
        respVo.setVisitDetailStep(stepMap);
        respVo.setRoleDirectoryRespVos(roleDirectoryRespVos);
        return respVo;
    }

    /**
     * 拜访步骤汇总
     *
     * @param roleDirectoryRespVos
     * @return
     */
    private Map<String, String> stepVisitDetail(List<SfaVisitRoleDirectoryRespVo> roleDirectoryRespVos) {
        Map<String, String> stepMap = new HashMap<>();
        roleDirectoryRespVos.forEach(data -> {
            stepMap.put("是否" + data.getDirectoryName(), data.getIsSuccessDesc());
        });
        return stepMap;
    }

    /**
     * 查询
     *
     * @param reqVo
     * @return sfaVisitDealerDetailRespVo
     */
    @Override
    @Deprecated
    @CrmAPIDiscard
    public SfaVisitDealerDetailRespVo query(SfaVisitDealerDetailReqVo reqVo) {
        if (null == reqVo || (StringUtils.isEmpty(reqVo.getId()) && CollectionUtil.listEmpty(reqVo.getIds()))) {
            return new SfaVisitDealerDetailRespVo();
        }
        SfaVisitDealerDetailRespVo sfaVisitDealerDetailRespVo = sfaVisitDealerDetailMapper.findSfaVisitDealerDetailRespVo(reqVo);
        if (sfaVisitDealerDetailRespVo == null) {
            return null;
        }
        String nowDate = LocalDate.now().format(CrmDateUtils.yyyyMMdd);
        if (!sfaVisitDealerDetailRespVo.getVisitDate().equals(nowDate)) {
            throw new BusinessException("不是当前时间内的无法进行拜访");
        }
        SfaVisitDealerDetailReqVo param = new SfaVisitDealerDetailReqVo() {{
            this.setVisitUserName(sfaVisitDealerDetailRespVo.getVisitUserName());
            this.setClientCode(sfaVisitDealerDetailRespVo.getClientCode());
            this.setId(reqVo.getId());
        }};
        String lastVisitSummary = sfaVisitDealerDetailMapper.selectSfaVisitDealerDetailLsatVisitSummary(param);
        if (StringUtils.isNotEmpty(lastVisitSummary)) {
            sfaVisitDealerDetailRespVo.setLastVisitSummary(lastVisitSummary);
        }
        SfaVisitPictureReqVo pictureReqVo = new SfaVisitPictureReqVo() {{
            this.setBusinessId(reqVo.getId());
        }};
        List<SfaVisitPictureRespVo> sfaVisitPictureRespVos = sfaVisitPictureService.findSfaVisitPictureList(pictureReqVo);
        if (CollectionUtil.listNotEmptyNotSizeZero(sfaVisitPictureRespVos)) {
            sfaVisitDealerDetailRespVo.setPhotoList(sfaVisitPictureRespVos);
        }
        return sfaVisitDealerDetailRespVo;
    }


    @Autowired
    private ISfaVisitPictureService sfaVisitPictureService;

    /**
     * 新增
     *
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    @Deprecated
    @CrmAPIDiscard
    public void save(SfaVisitDealerDetailReqVo reqVo) {
        SfaVisitDealerDetailEntity entity = CrmBeanUtil.copy(reqVo, SfaVisitDealerDetailEntity.class);
        entity.setVisitDateMonth(LocalDate.now().format(CrmDateUtils.yyyyMM));
        this.save(entity);
    }


    /**
     * @param redisHashKey
     * @return
     */
    private SfaVisitPlanInfoEntity loadAndCheckPlanInfo(String redisHashKey, String visitBigType) {
        UserRedis userRedis = UserUtils.getUser();
        String nowDate = LocalDate.now().format(CrmDateUtils.yyyyMMdd);

        SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity = (SfaVisitPlanInfoEntity) this.redisService
                .hmget(SfaVisitPlanInfoEntity.getInstance().redisHashCurrent(nowDate, visitBigType).toString(), redisHashKey);
        if (null == sfaVisitPlanInfoEntity) {
            throw new BusinessException("不存在的拜访计划，或该计划不在今日计划内！");
        }
        if (!org.apache.commons.lang3.StringUtils.equals(sfaVisitPlanInfoEntity.getVisitPosCode(), userRedis.getPoscode())) {
            throw new BusinessException("你没有权限访问该数据，请重新登陆或切换职位再尝试！");
        }

//        this.visitInStoreCheck(sfaVisitPlanInfoEntity);
        return sfaVisitPlanInfoEntity;
    }

    /**
     * 拜访-查询拜访客户信息、步骤列表
     *
     * @param redisHashKeyVo
     * @return
     */
    @Override
    @Transactional(readOnly = true)
    public SfaVisitExecuteResp getVisitSteps(CrmRedisHashKeyVo redisHashKeyVo) {
        SfaVisitPlanInfoEntity.VisitRedisHashKey visitRedisHashKey = new SfaVisitPlanInfoEntity.VisitRedisHashKey(redisHashKeyVo.getRedisHashKey());
        SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity = this.loadAndCheckPlanInfo(redisHashKeyVo.getRedisHashKey(), visitRedisHashKey.getVisitBigType());
        if (SfaVisitEnum.visitStatus.V4.getVal().equals(sfaVisitPlanInfoEntity.getVisitStatus())) {
            throw new BusinessException("该拜访计划已标注为异常状态！");
        }
        if (SfaVisitEnum.visitStatus.V1.getVal().equals(sfaVisitPlanInfoEntity.getVisitStatus())) {
            throw new BusinessException("请先进店打卡！");
        }
        SfaVisitPlanInfoRedisData doingData = (SfaVisitPlanInfoRedisData) this.redisService
                .hmget(SfaVisitPlanInfoRedisData.getInstance().redisHashCurrent(sfaVisitPlanInfoEntity.getVisitDate(), visitRedisHashKey.getVisitBigType()).toString(), redisHashKeyVo.getRedisHashKey());
        SfaVisitExecuteResp executeResp = CrmBeanUtil.copy(doingData.getSfaVisitPlanInfoExecuteRedisData(), SfaVisitExecuteResp.class);

        executeResp.setClientPhoto(doingData.getClientPhoto());
        executeResp.setSteps(doingData.getStep());
        return executeResp;

    }

    /**
     * 步骤状态检查
     *
     * @param visitRedisHashKey
     */
    private SfaVisitPlanInfoRedisData stepStatusCheck(SfaVisitPlanInfoEntity.VisitRedisHashKey visitRedisHashKey) {
        //拜访计划明细执行
        SfaVisitPlanInfoRedisData sfaVisitPlanInfoRedisData = (SfaVisitPlanInfoRedisData) this.redisService
                .hmget(SfaVisitPlanInfoRedisData.getInstance().redisHashCurrent(visitRedisHashKey.getVisitDate(), visitRedisHashKey.getVisitBigType()).toString()
                        , visitRedisHashKey.getRedisHashKey());
        List<VisitStepResp> steps = sfaVisitPlanInfoRedisData.getStep();
        StringJoiner msg = new StringJoiner(",");
        for (VisitStepResp stepResp : steps) {
            if (YesNoEnum.yesNoEnum.yes.getValue().equals(stepResp.getDoNot())
                    && !SfaVisitEnum.isSuccess.ALREADY_SUCCESS.getVal().equals(stepResp.getIsSuccess())) {
                msg.add(stepResp.getStepName());
            }
        }
        if (msg.length() > 0) {
            throw new BusinessException("步骤[" + msg.toString() + "]为必做项!");
        }
        return sfaVisitPlanInfoRedisData;
    }

    /**
     * 注入离店数据
     *
     * @param inOutReq
     * @param planInfoExecuteRedisData
     */
    private void injectOutStoreData(SfaVisitInOutReq inOutReq, SfaVisitPlanInfoExecuteRedisData planInfoExecuteRedisData, Map<String, VisitStepResp> roleVisitStepMap) {
        planInfoExecuteRedisData.setOutStore(LocalDateTime.now().format(CrmDateUtils.yyyyMMddHHmmss));
        YesNoEnum.yesNoEnum yesNoEnum = YesNoEnum.yesNoEnum.NO;
        if (roleVisitStepMap.containsKey(SfaVisitEnum.SfaStepCode.SFA_STEP_CODE_OUT_STORE.getVal())) {
            CrmBeanUtil.copyPropertiesIgnoreEmpty(inOutReq, planInfoExecuteRedisData);
            yesNoEnum = YesNoEnum.yesNoEnum.YES;
            planInfoExecuteRedisData.setFormIdAsOutStore(inOutReq.getFormId());
            planInfoExecuteRedisData.setOutStoreAddress(inOutReq.getAddress());
            planInfoExecuteRedisData.setOutStoreLatitude(inOutReq.getLatitude());
            planInfoExecuteRedisData.setOutStoreLongitude(inOutReq.getLongitude());

            if (null == inOutReq.getVisitInOutPics()) {
                planInfoExecuteRedisData.setVisitOutPics(Lists.newArrayList());
            } else {
                planInfoExecuteRedisData.setVisitOutPics(inOutReq.getVisitInOutPics());
            }
        }
        planInfoExecuteRedisData.setNeedOutStoreStep(yesNoEnum.getValue());
    }

    private void doVisitOutStore(SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity, SfaVisitPlanInfoRedisData sfaVisitPlanInfoRedisData) {
        //添加拜访完成信息到拜访完成进度报表中
//        SfaVisitCompleteInfoEntity sfaVisitCompleteInfoEntity = CrmBeanUtil.copy(sfaVisitPlanInfoEntity, SfaVisitCompleteInfoEntity.class);
//        sfaVisitCompleteInfoService.addVisitCompleteInfoDaily(sfaVisitPlanInfoEntity.getVisitStatus(), sfaVisitPlanInfoEntity.getVisitBigType(), sfaVisitCompleteInfoEntity);
        this.sfaVisitPlanInfoService.dataDurability(sfaVisitPlanInfoEntity, sfaVisitPlanInfoRedisData);

        //计划明细执行数据
        this.redisService.hmset(sfaVisitPlanInfoRedisData.redisHashCurrent(sfaVisitPlanInfoEntity.getVisitDate(), sfaVisitPlanInfoEntity.getVisitBigType()).toString()
                , sfaVisitPlanInfoRedisData.buildRedisDataForWrite(), SfaVisitPlanInfoEntity.CACHE_TIME);

        this.redisService.hmset(sfaVisitPlanInfoEntity.redisHashCurrent(sfaVisitPlanInfoEntity.getVisitDate(), sfaVisitPlanInfoEntity.getVisitBigType()).toString()
                , sfaVisitPlanInfoEntity.buildRedisDataForWrite(), SfaVisitPlanInfoEntity.CACHE_TIME);
        //mq写入绩效表
        UserRedis user = UserUtils.getUser();
        SfaAchievementAccomplishRecordReqVo reqVo = CrmBeanUtil.copy(sfaVisitPlanInfoRedisData, SfaAchievementAccomplishRecordReqVo.class);
        reqVo.setRelationId(reqVo.getId())
                .setIndexCode(SfaVisitEnum.indexType.WDBF.getCode())
                .setCustomerCode(sfaVisitPlanInfoRedisData.getClientCode())
                .setUsername(user.getUsername())
                .setObjectPosCode(user.getPoscode())
                .setCreateOrgCode(user.getOrgcode());
        AchievementRecordsMQSend.saveAchievementRecordsMQ(reqVo);

    }

    /**
     * 进离店、拜访总结表单数据
     *
     * @param sfaVisitPlanInfoRedisData
     */
    private void buildFormData(SfaVisitPlanInfoRedisData sfaVisitPlanInfoRedisData) {
        SfaVisitPlanInfoExecuteRedisData sfaVisitPlanInfoExecuteRedisData = sfaVisitPlanInfoRedisData.getSfaVisitPlanInfoExecuteRedisData();
        String formId = sfaVisitPlanInfoExecuteRedisData.getFormIdAsInStore();
        if (org.apache.commons.lang3.StringUtils.isNotBlank(formId)) {
            SfaVisitStepFromRespVo fromRespVo = this.sfaVisitStepFromService.queryById(formId);
            if (null == fromRespVo) {
                throw new BusinessException("未查询到表单配置数据");
            }
            sfaVisitPlanInfoExecuteRedisData.setSfaVisitStepFromAsInStore(fromRespVo);
        }
        formId = sfaVisitPlanInfoExecuteRedisData.getFormIdAsOutStore();
        if (org.apache.commons.lang3.StringUtils.isNotBlank(formId)) {
            SfaVisitStepFromRespVo fromRespVo = this.sfaVisitStepFromService.queryById(formId);
            if (null == fromRespVo) {
                throw new BusinessException("未查询到表单配置数据");
            }
            sfaVisitPlanInfoExecuteRedisData.setSfaVisitStepFromAsOutStore(fromRespVo);
        }
        formId = sfaVisitPlanInfoExecuteRedisData.getFormIdAsSummary();
        if (org.apache.commons.lang3.StringUtils.isNotBlank(formId)) {
            SfaVisitStepFromRespVo fromRespVo = this.sfaVisitStepFromService.queryById(formId);
            if (null == fromRespVo) {
                throw new BusinessException("未查询到表单配置数据");
            }
            sfaVisitPlanInfoExecuteRedisData.setSfaVisitStepFromAsSummary(fromRespVo);
        }
        sfaVisitPlanInfoExecuteRedisData.setVisitDetailStep(sfaVisitPlanInfoRedisData.summaryStepStatus());
    }

    /**
     * 离店打卡更新数据
     *
     * @param inOutReq
     */
    @Override
    @Transactional
    public void visitOutStore(SfaVisitInOutReq inOutReq) {
        //hashKey 对象
        SfaVisitPlanInfoEntity.VisitRedisHashKey visitRedisHashKey = new SfaVisitPlanInfoEntity.VisitRedisHashKey(inOutReq.getRedisHashKey());
        //计划明细数据
        SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity = this.loadAndCheckPlanInfo(inOutReq.getRedisHashKey(), visitRedisHashKey.getVisitBigType());
        //拜访状态检查
        this.visitInfoStatusCheck(sfaVisitPlanInfoEntity);
        //当前角色步骤列表
        Map<String, VisitStepResp> roleVisitStepMap = sfaVisitRoleDirectoryService.findRoleVisitStepMap(sfaVisitPlanInfoEntity);
        //步骤列表存在离店步骤，检查离店参数数据
        if (roleVisitStepMap.containsKey(SfaVisitEnum.SfaStepCode.SFA_STEP_CODE_OUT_STORE.getVal())) {
            this.checkSaveParamForInOut(inOutReq, sfaVisitPlanInfoEntity);
        }
        //业务步骤状态检查
        SfaVisitPlanInfoRedisData sfaVisitPlanInfoRedisData = this.stepStatusCheck(visitRedisHashKey);
        //注入离店数据
        this.injectOutStoreData(inOutReq, sfaVisitPlanInfoRedisData.getSfaVisitPlanInfoExecuteRedisData(), roleVisitStepMap);
        //进离店、拜访总结表单数据
        this.buildFormData(sfaVisitPlanInfoRedisData);
        String visitStatus, visitStatusName;
        if (SfaVisitEnum.VisitBigType.HELP_VISIT.getVal().equals(sfaVisitPlanInfoEntity.getVisitBigType())) {
            visitStatus = SfaVisitEnum.HelpVisitStatus.ALREADY_SUCCESS.getVal();
            visitStatusName = SfaVisitEnum.HelpVisitStatus.ALREADY_SUCCESS.getDesc();
        } else {
            visitStatus = SfaVisitEnum.visitStatus.V3.getVal();
            visitStatusName = SfaVisitEnum.visitStatus.V3.getDesc();
        }

        sfaVisitPlanInfoRedisData.setVisitStatus(visitStatus);
        sfaVisitPlanInfoRedisData.setVisitStatusName(visitStatusName);
        //计划明细数据
        sfaVisitPlanInfoEntity.setVisitStatus(visitStatus);
        sfaVisitPlanInfoEntity.setVisitStatusName(visitStatusName);

        this.doVisitOutStore(sfaVisitPlanInfoEntity, sfaVisitPlanInfoRedisData);
    }

    @Override
    @Transactional
    public SfaVisitExecuteResp visitInStore(SfaVisitInOutReq inOutReq) {
        SfaVisitPlanInfoEntity.VisitRedisHashKey visitRedisHashKey = new SfaVisitPlanInfoEntity.VisitRedisHashKey(inOutReq.getRedisHashKey());
        SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity = this.loadAndCheckPlanInfo(inOutReq.getRedisHashKey(), visitRedisHashKey.getVisitBigType());
        this.visitInfoStatusCheck(sfaVisitPlanInfoEntity);
        Map<String, VisitStepResp> roleVisitStepMap = sfaVisitRoleDirectoryService.findRoleVisitStepMap(sfaVisitPlanInfoEntity);
        //步骤列表存在进店步骤，检查进店参数数据
        if (roleVisitStepMap.containsKey(SfaVisitEnum.SfaStepCode.SFA_STEP_CODE_IN_STORE.getVal())) {
            this.checkSaveParamForInOut(inOutReq, sfaVisitPlanInfoEntity);
        }

        //重复打卡，直接返回
        if (!SfaVisitEnum.visitStatus.V1.getVal().equals(sfaVisitPlanInfoEntity.getVisitStatus())) {
            //正在拜访该计划
            SfaVisitPlanInfoRedisData doingData = (SfaVisitPlanInfoRedisData) this.redisService
                    .hmget(SfaVisitPlanInfoRedisData.getInstance().redisHashCurrent(sfaVisitPlanInfoEntity.getVisitDate(), visitRedisHashKey.getVisitBigType()).toString(), inOutReq.getRedisHashKey());
            SfaVisitExecuteResp executeResp = CrmBeanUtil.copy(doingData.getSfaVisitPlanInfoExecuteRedisData(), SfaVisitExecuteResp.class);
            executeResp.setSteps(doingData.getStep());
            return executeResp;
        }else {
            //进行拜访明细数据当前步骤的保存
            sfaVisitInfoStepFormService.saveSfaVisitInfoForm(Lists.newArrayList(roleVisitStepMap.values()),sfaVisitPlanInfoEntity);
        }

        //提前把离线数据放入到缓存
        SfaVisitStepOffLineUtil util = new SfaVisitStepOffLineUtil();
        this.redisService.hmset(util.getRedisHashKey(visitRedisHashKey.getVisitBigType()),
                util.buildOffLineMap(visitRedisHashKey.getClientCode(),visitRedisHashKey.getVisitBigType(),sfaVisitPlanInfoEntity),SfaVisitStepOffLineUtil.REDIS_EXPIRE_TIME);
        return this.doVisitInStore(inOutReq, sfaVisitPlanInfoEntity, roleVisitStepMap);
    }

    /**
     * 拜访执行-确认为离线拜访打卡数据
     * @param redisHashKey
     */
    @Override
    public void confirmVisitOffLine(String redisHashKey) {
        SfaVisitPlanInfoEntity.VisitRedisHashKey visitRedisHashKey = new SfaVisitPlanInfoEntity.VisitRedisHashKey(redisHashKey);
        SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity = this.loadAndCheckPlanInfo(redisHashKey, visitRedisHashKey.getVisitBigType());
        String visitDate = sfaVisitPlanInfoEntity.getVisitDate();
        sfaVisitPlanInfoEntity.setLineStatus(SfaVisitEnum.VISIT_OFF_LINE.offline.getVal());
        this.redisService.hmset(sfaVisitPlanInfoEntity.redisHashCurrent(visitDate, sfaVisitPlanInfoEntity.getVisitBigType()).toString()
                , sfaVisitPlanInfoEntity.buildRedisDataForWrite(), SfaVisitPlanInfoEntity.CACHE_TIME);
    }

    /**
     * 组装执行数据-拜访开始
     *
     * @param inOutReq
     * @param sfaVisitPlanInfoEntity
     * @param roleVisitStepMap
     * @return
     */
    private SfaVisitPlanInfoExecuteRedisData buildExecuteRedisDataVisitBegin(SfaVisitInOutReq inOutReq, SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity, Map<String, VisitStepResp> roleVisitStepMap) {
        SfaVisitPlanInfoExecuteRedisData planInfoExecuteRedisData = CrmBeanUtil.copy(inOutReq, SfaVisitPlanInfoExecuteRedisData.class);
        SfaVisitPlanInfoExecuteRedisData.buildDefEntityData(planInfoExecuteRedisData);
        this.buildExecuteRedisData(sfaVisitPlanInfoEntity, planInfoExecuteRedisData);

        planInfoExecuteRedisData.setInStore(LocalDateTime.now().format(CrmDateUtils.yyyyMMddHHmmss));
        YesNoEnum.yesNoEnum yesNoEnum = YesNoEnum.yesNoEnum.NO;
        //步骤列表存在进店步骤，需要进店拍照
        if (roleVisitStepMap.containsKey(SfaVisitEnum.SfaStepCode.SFA_STEP_CODE_IN_STORE.getVal())) {
            CrmBeanUtil.copyPropertiesIgnoreEmpty(inOutReq, planInfoExecuteRedisData);
            planInfoExecuteRedisData.setFormIdAsInStore(inOutReq.getFormId());
            planInfoExecuteRedisData.setInStoreAddress(inOutReq.getAddress());
            planInfoExecuteRedisData.setInStoreLatitude(inOutReq.getLatitude());
            planInfoExecuteRedisData.setInStoreLongitude(inOutReq.getLongitude());
            if (null == inOutReq.getVisitInOutPics()) {
                planInfoExecuteRedisData.setVisitInPics(Lists.newArrayList());
            } else {
                planInfoExecuteRedisData.setVisitInPics(inOutReq.getVisitInOutPics());
            }
            yesNoEnum = YesNoEnum.yesNoEnum.YES;
        }
        planInfoExecuteRedisData.setNeedInStoreStep(yesNoEnum.getValue());
        return planInfoExecuteRedisData;
    }

    /**
     * 组装执行数据-拜访开始
     *
     * @param sfaVisitPlanInfoEntity
     * @param roleVisitStepMap
     */
    private SfaVisitPlanInfoRedisData buildSfaVisitPlanInfoRedisData(SfaVisitInOutReq inOutReq, SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity, Map<String, VisitStepResp> roleVisitStepMap) {
        //组装执行数据-拜访开始
        SfaVisitPlanInfoExecuteRedisData sfaVisitPlanInfoExecuteRedisData = this.buildExecuteRedisDataVisitBegin(inOutReq, sfaVisitPlanInfoEntity, roleVisitStepMap);
        SfaVisitPlanInfoRedisData planInfoRedisData = CrmBeanUtil.copy(sfaVisitPlanInfoEntity, SfaVisitPlanInfoRedisData.class);
        planInfoRedisData.setSfaVisitPlanInfoExecuteRedisData(sfaVisitPlanInfoExecuteRedisData);

        String visitStatus, visitStatusName;
        if (SfaVisitEnum.VisitBigType.VISIT.getVal().equals(planInfoRedisData.getVisitBigType())) {
            visitStatus = SfaVisitEnum.visitStatus.V2.getVal();
            visitStatusName = SfaVisitEnum.visitStatus.V2.getDesc();
        } else {
            visitStatus = SfaVisitEnum.HelpVisitStatus.IN_HELP_DEFENSE.getVal();
            visitStatusName = SfaVisitEnum.HelpVisitStatus.IN_HELP_DEFENSE.getDesc();
        }
        planInfoRedisData.setVisitStatus(visitStatus);
        planInfoRedisData.setVisitStatusName(visitStatusName);
        List<VisitStepResp> step = roleVisitStepMap.values().stream().filter(v -> {
            //过滤进店离店步骤(在拜访中时，移动端不展示进离店步骤)
            if (SfaVisitEnum.visitStep.VISIT_STEP_IN_STORE.getVal().equals(v.getPageCode())
                    || SfaVisitEnum.visitStep.VISIT_STEP_OUT_STORE.getVal().equals(v.getPageCode())) {
                return false;
            }
            return true;
        }).sorted(Comparator.comparing(VisitStepResp::getSort)).collect(Collectors.toList());
        planInfoRedisData.setStep(step);
        return planInfoRedisData;
    }

    /**
     * 拜访进店
     *
     * @param inOutReq
     * @param sfaVisitPlanInfoEntity
     * @param roleVisitStepMap
     * @return
     */
    private SfaVisitExecuteResp doVisitInStore(SfaVisitInOutReq inOutReq, SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity, Map<String, VisitStepResp> roleVisitStepMap) {

        SfaVisitPlanInfoRedisData planInfoRedisData = this.buildSfaVisitPlanInfoRedisData(inOutReq, sfaVisitPlanInfoEntity, roleVisitStepMap);
        SfaVisitPlanInfoExecuteRedisData sfaVisitPlanInfoExecuteRedisData = planInfoRedisData.getSfaVisitPlanInfoExecuteRedisData();
        //更新纬度
        this.updateClientPoint(sfaVisitPlanInfoEntity, sfaVisitPlanInfoExecuteRedisData);
        String visitDate = sfaVisitPlanInfoEntity.getVisitDate();
        //计划明细执行数据
        this.redisService.hmset(planInfoRedisData.redisHashCurrent(visitDate, planInfoRedisData.getVisitBigType()).toString()
                , planInfoRedisData.buildRedisDataForWrite(), SfaVisitPlanInfoEntity.CACHE_TIME);
        //计划明细数据
        sfaVisitPlanInfoEntity.setVisitStatus(planInfoRedisData.getVisitStatus());
        sfaVisitPlanInfoEntity.setVisitStatusName(planInfoRedisData.getVisitStatusName());
        //设置默认状态为在线拜访
        sfaVisitPlanInfoEntity.setLineStatus(SfaVisitEnum.VISIT_OFF_LINE.online.getVal());
        this.redisService.hmset(sfaVisitPlanInfoEntity.redisHashCurrent(visitDate, sfaVisitPlanInfoEntity.getVisitBigType()).toString()
                , sfaVisitPlanInfoEntity.buildRedisDataForWrite(), SfaVisitPlanInfoEntity.CACHE_TIME);
        //是否离线数据
        String isOffLine = sfaVisitRoleDirectoryService.findRoleStepIsOffLine(sfaVisitPlanInfoEntity);
        SfaVisitExecuteResp executeResp = CrmBeanUtil.copy(sfaVisitPlanInfoExecuteRedisData, SfaVisitExecuteResp.class);
        executeResp.setIsOffLine(isOffLine);
        executeResp.setSteps(planInfoRedisData.getStep());
        return executeResp;
    }

    /**
     * 更新经纬度
     * @param sfaVisitPlanInfoEntity
     * @param entity
     */
    protected void updateClientPoint(SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity, SfaVisitPlanInfoExecuteRedisData entity) {
        if(null == sfaVisitPlanInfoEntity.getLatitude() || null == sfaVisitPlanInfoEntity.getLongitude()){
            if(null == entity.getInStoreLongitude() || null == entity.getInStoreLatitude()){
                return;
            }

            if(SfaVisitEnum.ClientType.TERMINAL.getVal().equals(sfaVisitPlanInfoEntity.getClientType())){
                List<UpdateCoordinateReqVo> updateCoordinateReqVos = Lists.newArrayList(new UpdateCoordinateReqVo() {{
                    this.setTerminalCode(entity.getClientCode());
                    this.setLongitude(entity.getInStoreLongitude().toString());
                    this.setLatitude(entity.getInStoreLatitude().toString());
                }});
                Result<Object> result = mdmTerminalFeign.updateCoordinate(updateCoordinateReqVos);
                ApiResultUtil.checkResult(result);
            }else{
                List<MdmCustomerMsgReqVo> mdmCustomerMsgReqVos = Lists.newArrayList(new MdmCustomerMsgReqVo() {{
                    this.setCustomerCode(entity.getClientCode());
                    this.setLongitude(entity.getInStoreLongitude().toString());
                    this.setLatitude(entity.getInStoreLatitude().toString());
                }});
                Result<Object> result = mdmCustomerMsgFeign.updateCoordinate(mdmCustomerMsgReqVos);
                ApiResultUtil.checkResult(result);
            }

        }

    }
    /**
     * 检查该拜访计划的状态和其他计划的状态
     */
    private void visitInfoStatusCheck(SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity) {
        //当前用户指定日期下的拜访计划明细列表
        List<SfaVisitPlanInfoEntity> planInfoEntities = (List<SfaVisitPlanInfoEntity>) this.redisService.hmValues(sfaVisitPlanInfoEntity.redisHashCurrent(sfaVisitPlanInfoEntity.getVisitDate(), sfaVisitPlanInfoEntity.getVisitBigType()).toString());
        for (SfaVisitPlanInfoEntity planInfoEntity : planInfoEntities) {
            // 未拜访
            if (SfaVisitEnum.visitStatus.V1.getVal().equals(planInfoEntity.getVisitStatus())) {
                continue;
            }
            if (SfaVisitEnum.visitStatus.V2.getVal().equals(planInfoEntity.getVisitStatus())
                    && !sfaVisitPlanInfoEntity.getRedisHashKey().equals(planInfoEntity.getRedisHashKey())) {
                throw new BusinessException("[" + planInfoEntity.getClientName() + "]正在拜访中，请先完成该网点的拜访业务！");
            }
            if (SfaVisitEnum.visitStatus.V3.getVal().equals(planInfoEntity.getVisitStatus())
                    || SfaVisitEnum.visitStatus.V4.getVal().equals(planInfoEntity.getVisitStatus())) {
                if (sfaVisitPlanInfoEntity.getRedisHashKey().equals(planInfoEntity.getRedisHashKey())) {
                    throw new BusinessException("该计划已完成或已标记异常状态！");
                }
            }

        }
    }

    /**
     * 进店打卡信息查询
     *
     * @param visitId
     * @return
     */
    @Override
    public SfaVisitDealerDetailRespVo findVisitInStoreByVisitId(String visitId) {
        SfaVisitDealerDetailEntity sfaVisitDealerDetailEntity = this.lambdaQuery()
                .eq(SfaVisitDealerDetailEntity::getId, visitId).one();
        SfaVisitDealerDetailRespVo sfaVisitDealerDetailRespVo;
        if (sfaVisitDealerDetailEntity == null) {
            sfaVisitDealerDetailRespVo = new SfaVisitDealerDetailRespVo();
            sfaVisitDealerDetailRespVo.setPhotoList(Lists.newArrayList());
            return sfaVisitDealerDetailRespVo;
        }
        sfaVisitDealerDetailRespVo = CrmBeanUtil.copy(sfaVisitDealerDetailEntity, SfaVisitDealerDetailRespVo.class);
        List<SfaVisitPictureEntity> sfaVisitPictureEntityList = sfaVisitPictureService.lambdaQuery()
                .eq(SfaVisitPictureEntity::getBusinessId, visitId)
                .eq(SfaVisitPictureEntity::getPicType, SfaVisitEnum.visitPicType.DEALER_IN_STORE_PIC.getVal()).list();
        if (CollectionUtil.listNotEmptyNotSizeZero(sfaVisitPictureEntityList)) {
            List<SfaVisitPictureRespVo> sfaVisitPictureRespVos = CrmBeanUtil.copyList(sfaVisitPictureEntityList, SfaVisitPictureRespVo.class);
            sfaVisitDealerDetailRespVo.setPhotoList(sfaVisitPictureRespVos);
        }
        return sfaVisitDealerDetailRespVo;
    }

    /**
     * 离店打卡信息查询
     *
     * @param visitId
     * @return
     */
    @Override
    public SfaVisitDealerDetailRespVo findVisitOutStoreByVisitId(String visitId) {
        SfaVisitDealerDetailEntity sfaVisitDealerDetailEntity = this.lambdaQuery()
                .eq(SfaVisitDealerDetailEntity::getId, visitId).one();
        SfaVisitDealerDetailRespVo sfaVisitDealerDetailRespVo;
        if (sfaVisitDealerDetailEntity == null) {
            sfaVisitDealerDetailRespVo = new SfaVisitDealerDetailRespVo();
            sfaVisitDealerDetailRespVo.setPhotoList(Lists.newArrayList());
            return sfaVisitDealerDetailRespVo;
        }
        sfaVisitDealerDetailRespVo = CrmBeanUtil.copy(sfaVisitDealerDetailEntity, SfaVisitDealerDetailRespVo.class);
        List<SfaVisitPictureEntity> sfaVisitPictureEntityList = sfaVisitPictureService.lambdaQuery()
                .eq(SfaVisitPictureEntity::getBusinessId, visitId)
                .eq(SfaVisitPictureEntity::getPicType, SfaVisitEnum.visitPicType.DEALER_OUT_STORE_PIC.getVal()).list();
        if (CollectionUtil.listNotEmptyNotSizeZero(sfaVisitPictureEntityList)) {
            List<SfaVisitPictureRespVo> sfaVisitPictureRespVos = CrmBeanUtil.copyList(sfaVisitPictureEntityList, SfaVisitPictureRespVo.class);
            sfaVisitDealerDetailRespVo.setPhotoList(sfaVisitPictureRespVos);
        }
        return sfaVisitDealerDetailRespVo;
    }

    /**
     * 拜访总结信息查询
     *
     * @param visitId
     * @return
     */
    @Override
    public SfaVisitDealerDetailRespVo findVisitSummaryByVisitId(String visitId) {
        SfaVisitDealerDetailEntity sfaVisitDealerDetailEntity = this.lambdaQuery()
                .eq(SfaVisitDealerDetailEntity::getId, visitId).one();
        if (sfaVisitDealerDetailEntity == null) {
            return new SfaVisitDealerDetailRespVo();
        }
        SfaVisitDealerDetailRespVo sfaVisitDealerDetailRespVo = CrmBeanUtil.copy(sfaVisitDealerDetailEntity, SfaVisitDealerDetailRespVo.class);
        return sfaVisitDealerDetailRespVo;
    }

    /**
     * 进店打卡参数校验
     */
    protected void checkSaveParamForInOut(SfaVisitInOutReq inOutReq, SfaVisitPlanInfoEntity entity) {
        if (org.apache.commons.lang3.StringUtils.isBlank(inOutReq.getFormId())) {
            throw new BusinessException("表单ID为空");
        }
        AssertUtils.isNotEmpty(inOutReq.getRedisHashKey(), "redisHashKey为空");
        AssertUtils.isNotEmpty(inOutReq.getAddress(), "定位地址为空");
        if (null == inOutReq.getLatitude() || null == inOutReq.getLongitude()) {
            throw new BusinessException("定位经纬度为空");
        }
        this.checkPoint(inOutReq, entity);
        List<CrmAttachment> visitInOutPics = inOutReq.getVisitInOutPics();
        if (org.springframework.util.CollectionUtils.isEmpty(visitInOutPics)) {
            throw new BusinessException("进离店打卡图片为空");
        }
        if (visitInOutPics.size() > 5) {
            throw new BusinessException("进离店打卡图片不能超过5张");
        }
    }

    /**
     * 校验表单内的距离配置
     *
     * @param inOutReq
     * @param entity
     */
    protected void checkPoint(SfaVisitInOutReq inOutReq, SfaVisitPlanInfoEntity entity) {
        //判断拜访客户经纬度不为空
        if (entity != null && entity.getLatitude() != null && entity.getLatitude() != null) {
            SfaVisitStepFromRespVo stepFromEntity = sfaVisitStepFromService.queryById(inOutReq.getFormId());
            if (stepFromEntity != null && stepFromEntity.getLocateType().equals(YesNoEnum.yesNoEnum.Y.getValue())) {
                if (StringUtils.isNotEmpty(stepFromEntity.getDistance())) {
                    BigDecimal distance = new BigDecimal(stepFromEntity.getDistance()).setScale(2, BigDecimal.ROUND_HALF_DOWN);
                    log.info("当前步骤配置的距离:{}", distance);
                    log.info("当前位置的经度:{},纬度:{},拜访客户的经度:{},纬度:{}", inOutReq.getLongitude(), inOutReq.getLatitude(), entity.getLongitude(), entity.getLatitude());
                    double data = LocationUtils.getDistance(inOutReq.getLongitude(), inOutReq.getLatitude(), entity.getLongitude(), entity.getLatitude());
                    BigDecimal nowDistance = new BigDecimal(data).setScale(2, BigDecimal.ROUND_HALF_DOWN);
                    log.info("当前位置距离拜访客户的距离:{}", nowDistance);
                    if (distance.compareTo(nowDistance) == -1) {
                        throw new BusinessException("您未在客户距离" + distance + "M内，请前往客户地址进行操作！");
                    }
                }
            }
        }
    }


    /**
     * 参数装配
     *
     * @param entity
     */
    private void buildExecuteRedisData(SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity, SfaVisitPlanInfoExecuteRedisData entity) {
//        private String inStoreAddress;
//        private BigDecimal inStoreLongitude;
//        private BigDecimal inStoreLatitude;
//        private String outStore;
//        private String outStoreAddress;
//        private BigDecimal outStoreLongitude;
//        private BigDecimal outStoreLatitude;
//        entity.setVisitPlanId(sfaVisitPlanInfoEntity.getId());
        entity.setVisitPlanInfoId(sfaVisitPlanInfoEntity.getId());
        entity.setVisitPlanCode(sfaVisitPlanInfoEntity.getVisitPlanCode());
        UserRedis userRedis = UserUtils.getUser();

        entity.setVisitUserName(userRedis.getUsername());
        entity.setVisitRealName(userRedis.getRealname());
        entity.setVisitPosCode(userRedis.getPoscode());
        entity.setVisitPosName(userRedis.getPosname());
        entity.setCoverHelpOrgCode(sfaVisitPlanInfoEntity.getCoverHelpOrgCode());
        entity.setCoverHelpOrgName(sfaVisitPlanInfoEntity.getCoverHelpOrgName());
        entity.setCoverHelpPosCode(sfaVisitPlanInfoEntity.getCoverHelpPosCode());
        entity.setCoverHelpPosName(sfaVisitPlanInfoEntity.getCoverHelpPosName());
        entity.setCoverHelpRealName(sfaVisitPlanInfoEntity.getCoverHelpRealName());
        entity.setCoverHelpUserName(sfaVisitPlanInfoEntity.getCoverHelpUserName());
        entity.setHelpDefenseId(sfaVisitPlanInfoEntity.getVisitPlanCode());


        entity.setVisitOrgCode(sfaVisitPlanInfoEntity.getVisitOrgCode());
        entity.setVisitOrgName(sfaVisitPlanInfoEntity.getVisitOrgName());
        MdmOrgRespVo mdmOrgRespVo = OrgUtil.getOrgByCode(sfaVisitPlanInfoEntity.getVisitOrgCode());
        if (null != mdmOrgRespVo) {
            entity.setVisitParentOrgCode(mdmOrgRespVo.getParentCode());
            entity.setVisitParentOrgName(mdmOrgRespVo.getParentName());
        }
        entity.setVisitType(sfaVisitPlanInfoEntity.getVisitType());
        entity.setVisitTypeName(sfaVisitPlanInfoEntity.getVisitTypeName());
        entity.setVisitBigType(sfaVisitPlanInfoEntity.getVisitBigType());
        entity.setVisitBigTypeName(sfaVisitPlanInfoEntity.getVisitBigTypeName());
        entity.setVisitSort(sfaVisitPlanInfoEntity.getVisitSort());
        entity.setClientCode(sfaVisitPlanInfoEntity.getClientCode());
        entity.setClientAddress(sfaVisitPlanInfoEntity.getClientAddress());
        entity.setClientName(sfaVisitPlanInfoEntity.getClientName());
        entity.setClientPhone(sfaVisitPlanInfoEntity.getClientPhone());
        entity.setClientType(sfaVisitPlanInfoEntity.getClientType());
        entity.setClientTypeName(sfaVisitPlanInfoEntity.getClientTypeName());
        entity.setClientPhoto(sfaVisitPlanInfoEntity.getClientPhoto());
        entity.setVisitDate(sfaVisitPlanInfoEntity.getVisitDate());
        entity.setVisitDateOfYearMonth(sfaVisitPlanInfoEntity.getVisitDateOfYearMonth());
        entity.setVisitDateOfYear(sfaVisitPlanInfoEntity.getVisitDateOfYear());
        entity.setClientSubclass(sfaVisitPlanInfoEntity.getClientSubclass());
        entity.setClientSubclassName(sfaVisitPlanInfoEntity.getClientSubclassName());
        entity.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
        entity.setDelFlag(CrmDelFlagEnum.NORMAL.getCode());
    }


    /**
     * 更新
     *
     * @param reqVo
     * @return
     */
    @Override
    @Deprecated
    @CrmAPIDiscard
    @Transactional(rollbackFor = Exception.class)
    public void update(SfaVisitDealerDetailReqVo reqVo) {
        AssertUtils.isNotEmpty(reqVo.getId(), "数据主键为空");
        AssertUtils.isNotEmpty(reqVo.getVisitSummary(), "拜访总结为空");
        SfaVisitDealerDetailEntity entity = this.getById(reqVo.getId());
        if (null == entity) {
            throw new BusinessException("查询拜访数据为空");
        }
        SfaVisitDealerDetailEntity entityUpdate = new SfaVisitDealerDetailEntity();
        entityUpdate.setId(entity.getId());
        entityUpdate.setVisitSummary(reqVo.getVisitSummary());
        this.updateById(entityUpdate);
    }


    @CrmAPIDiscard
    private void checkUpdateParam(SfaVisitDealerDetailReqVo reqVo) {
        AssertUtils.isNotEmpty(reqVo.getId(), "数据主键为空");
        AssertUtils.isNotEmpty(reqVo.getOutStore(), "离店时间为空");
        AssertUtils.isNotEmpty(reqVo.getOutStoreAddress(), "离店地址为空");
        if (null == reqVo.getOutStoreLatitude() || null == reqVo.getOutStoreLongitude()) {
            throw new BusinessException("离店坐标为空");
        }
        SfaVisitDealerDetailEntity entity = this.getById(reqVo.getId());
        if (null == entity) {
            throw new BusinessException("未查询到拜访数据");
        }
        UserRedis userRedis = UserUtils.getUser();
        SfaVisitRoleConfigReqVo sfaVisitRoleConfigReqVo = new SfaVisitRoleConfigReqVo() {{
            this.setVisitType(SfaVisitEnum.sfaVisitType.VISIT.getVal());
            this.setVisitId(reqVo.getId());
            this.setVisitPosCode(userRedis.getPoscode());
            this.setVisitUserName(userRedis.getUsername());
            this.setSfacusType(entity.getClientType());
        }};
        String redisHash = null;
        List<SfaVisitRoleDirectoryRespVo> sfaVisitRoleDirectoryRespVos = sfaVisitRoleDirectoryService.findVisitRoleDirectoryList(redisHash, null);
        List<SfaVisitRoleDirectoryRespVo> roleDirectoryList = sfaVisitRoleDirectoryRespVos.stream().
                filter(data -> data.getDoNot().equals(YesNoEnum.YesNoCodeNumberEnum.YES.getCode().toString())).collect(Collectors.toList());
        roleDirectoryList.forEach(data -> {
            if (data.getIsSuccess().equals(YesNoEnum.YesNoCodeNumberEnum.NO.getCode().toString())) {
                throw new BusinessException("拜访步骤：" + data.getDirectoryName() + "为必做步骤,请完成在离店打卡");
            }
        });

    }


    /**
     * 拜访异常提报
     *
     * @param exceptionReq
     * @return
     */
    @Override
    @Transactional
    public SfaVisitExceptionResp visitException(SfaVisitExceptionReq exceptionReq) {
//        AssertUtils.isNotEmpty(inOutReq.getVisitInOutPics(), "打卡照片为空");
        SfaVisitPlanInfoEntity.VisitRedisHashKey visitRedisHashKey = new SfaVisitPlanInfoEntity.VisitRedisHashKey(exceptionReq.getRedisHashKey());
        List<CrmAttachment> visitExceptionPics = exceptionReq.getVisitExceptionPics();
        if (org.springframework.util.CollectionUtils.isEmpty(visitExceptionPics)) {
            throw new BusinessException("异常提报图片为空");
        }
        if (visitExceptionPics.size() > 5) {
            throw new BusinessException("异常提报图片不能超过5张");
        }
        SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity = this.loadAndCheckPlanInfo(exceptionReq.getRedisHashKey(), visitRedisHashKey.getVisitBigType());
//        this.visitInfoCheck(sfaVisitPlanInfoEntity);
        if (SfaVisitEnum.visitStatus.V2.getVal().equals(sfaVisitPlanInfoEntity.getVisitStatus())
                || SfaVisitEnum.visitStatus.V3.getVal().equals(sfaVisitPlanInfoEntity.getVisitStatus())) {
            throw new BusinessException("该计划已在执行中或已完成！");
        }
        if (SfaVisitEnum.visitStatus.V4.getVal().equals(sfaVisitPlanInfoEntity.getVisitStatus())) {
            SfaVisitPlanInfoRedisData doingData = (SfaVisitPlanInfoRedisData) this.redisService
                    .hmget(SfaVisitPlanInfoRedisData.getInstance().redisHashCurrent(sfaVisitPlanInfoEntity.getVisitDate(), visitRedisHashKey.getVisitBigType()).toString(), exceptionReq.getRedisHashKey());
            SfaVisitExceptionResp exceptionResp = CrmBeanUtil.copy(doingData.getSfaVisitPlanInfoExecuteRedisData(), SfaVisitExceptionResp.class);
            exceptionResp.setVisitExceptionPics(doingData.getSfaVisitPlanInfoExecuteRedisData().getVisitExceptionPics());
            return exceptionResp;
        }
        return this.doVisitException(exceptionReq, sfaVisitPlanInfoEntity, sfaVisitPlanInfoEntity.getVisitDate());
    }

    private SfaVisitExceptionResp doVisitException(SfaVisitExceptionReq exceptionReq, SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity, String nowDate) {

        SfaVisitPlanInfoExecuteRedisData planInfoExecuteRedisData = new SfaVisitPlanInfoExecuteRedisData();
        this.buildExecuteRedisData(sfaVisitPlanInfoEntity, planInfoExecuteRedisData);
        planInfoExecuteRedisData.setExceptionTime(LocalDateTime.now().format(CrmDateUtils.yyyyMMddHHmmss));
        CrmBeanUtil.copyPropertiesIgnoreEmpty(exceptionReq, planInfoExecuteRedisData);

        if (null == exceptionReq.getVisitExceptionPics()) {
            planInfoExecuteRedisData.setVisitExceptionPics(Lists.newArrayList());
        } else {
            planInfoExecuteRedisData.setVisitExceptionPics(exceptionReq.getVisitExceptionPics());
        }

        SfaVisitPlanInfoRedisData planInfoRedisData = CrmBeanUtil.copy(sfaVisitPlanInfoEntity, SfaVisitPlanInfoRedisData.class);
        planInfoRedisData.setSfaVisitPlanInfoExecuteRedisData(planInfoExecuteRedisData);
        String visitStatus, visitStatusName;
        if (SfaVisitEnum.VisitBigType.HELP_VISIT.getVal().equals(sfaVisitPlanInfoEntity.getVisitBigType())) {
            visitStatus = SfaVisitEnum.HelpVisitStatus.EX.getVal();
            visitStatusName = SfaVisitEnum.HelpVisitStatus.EX.getDesc();
        } else {
            visitStatus = SfaVisitEnum.visitStatus.V4.getVal();
            visitStatusName = SfaVisitEnum.visitStatus.V4.getDesc();
        }
        planInfoRedisData.setVisitStatus(visitStatus);
        planInfoRedisData.setVisitStatusName(visitStatusName);
        //计划明细数据
        sfaVisitPlanInfoEntity.setVisitStatus(visitStatus);
        sfaVisitPlanInfoEntity.setVisitStatusName(visitStatusName);
//        //添加拜访完成信息到拜访完成进度报表中
//        SfaVisitCompleteInfoEntity sfaVisitCompleteInfoEntity = CrmBeanUtil.copy(sfaVisitPlanInfoEntity, SfaVisitCompleteInfoEntity.class);
//        sfaVisitCompleteInfoService.addVisitCompleteInfoDaily(sfaVisitPlanInfoEntity.getVisitStatus(), sfaVisitPlanInfoEntity.getVisitBigType(), sfaVisitCompleteInfoEntity);
        this.sfaVisitPlanInfoService.dataDurability(sfaVisitPlanInfoEntity, planInfoRedisData);
        //计划明细执行数据
        this.redisService.hmset(planInfoRedisData.redisHashCurrent(nowDate, sfaVisitPlanInfoEntity.getVisitBigType()).toString()
                , planInfoRedisData.buildRedisDataForWrite(), SfaVisitPlanInfoEntity.CACHE_TIME);

        this.redisService.hmset(sfaVisitPlanInfoEntity.redisHashCurrent(nowDate, sfaVisitPlanInfoEntity.getVisitBigType()).toString()
                , sfaVisitPlanInfoEntity.buildRedisDataForWrite(), SfaVisitPlanInfoEntity.CACHE_TIME);
        SfaVisitExceptionResp exceptionResp = CrmBeanUtil.copy(planInfoExecuteRedisData, SfaVisitExceptionResp.class);
        exceptionResp.setVisitExceptionPics(planInfoExecuteRedisData.getVisitExceptionPics());
        return exceptionResp;
    }

    /**
     * 校验异常拜访参数
     *
     * @param reqVo
     */
    private void checkExceptionSave(SfaVisitDealerDetailReqVo reqVo) {
        AssertUtils.isNotEmpty(reqVo.getExceptionTime(), "异常提交时间为空");
        AssertUtils.isNotEmpty(reqVo.getExceptionDetail(), "异常描述为空");
        AssertUtils.isNotEmpty(reqVo.getClientCode(), "门店编码为空");
        AssertUtils.isNotEmpty(reqVo.getPhotoList(), "图片为空");
        AssertUtils.isNotEmpty(reqVo.getVisitPlanCode(), "拜访编码为空");
        AssertUtils.isNotEmpty(reqVo.getVisitUserName(), "拜访人员为空");
        AssertUtils.isNotEmpty(reqVo.getClientCode(), "拜访门店信息为空");
        Date date = new Date();
        Date exceptionTime = null;
        SimpleDateFormat ymd = new SimpleDateFormat("yyyy-MM-dd");
        try {
            String now = ymd.format(date);
            date = ymd.parse(now);
            exceptionTime = ymd.parse(reqVo.getExceptionTime());
        } catch (Exception e) {
            throw new BusinessException("转换日期格式错误");
        }
        if (exceptionTime.getTime() != date.getTime()) {
            throw new BusinessException("该拜访计划不是当前时间内的");
        }
    }


    /**
     * 删除
     *
     * @param ids
     * @return
     */
    @Override
    public void deleteBatch(List<String> ids) {
        if (!CollectionUtil.listNotEmptyNotSizeZero(ids)) {
            throw new BusinessException("数据主键为空");
        }
        List<SfaVisitDealerDetailEntity> sfaVisitDealerDetailEntities = sfaVisitDealerDetailMapper.selectBatchIds(ids);
        if (CollectionUtils.isNotEmpty(sfaVisitDealerDetailEntities)) {
            sfaVisitDealerDetailEntities.forEach(o -> {
                o.setDelFlag(CrmDelFlagEnum.DELETE.getCode());
            });
        }
        this.updateBatchById(sfaVisitDealerDetailEntities);
    }

    /**
     * 启用
     *
     * @param ids
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void enableBatch(List<String> ids) {
        if (!CollectionUtil.listNotEmptyNotSizeZero(ids)) {
            throw new BusinessException("数据主键为空");
        }
        //设置状态为启用
        List<SfaVisitDealerDetailEntity> sfaVisitDealerDetailEntities = sfaVisitDealerDetailMapper.selectBatchIds(ids);
        if (CollectionUtils.isNotEmpty(sfaVisitDealerDetailEntities)) {
            sfaVisitDealerDetailEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
            });
        }
        this.updateBatchById(sfaVisitDealerDetailEntities);
    }

    /**
     * 禁用
     *
     * @param ids
     * @return
     */
    @Override
    public void disableBatch(List<String> ids) {
        if (!CollectionUtil.listNotEmptyNotSizeZero(ids)) {
            throw new BusinessException("数据主键为空");
        }
        //设置状态为禁用
        List<SfaVisitDealerDetailEntity> sfaVisitDealerDetailEntities = sfaVisitDealerDetailMapper.selectBatchIds(ids);
        if (CollectionUtils.isNotEmpty(sfaVisitDealerDetailEntities)) {
            sfaVisitDealerDetailEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode());
            });
        }
        this.updateBatchById(sfaVisitDealerDetailEntities);
    }


    /**
     * 列表
     *
     * @param reqVo
     * @return
     */
    @Override
    public PageResult<SfaVisitDealerDetailRespVo> findDealerDetailReportList(SfaVisitDealerDetailReqVo reqVo) {
        String orgCode = UserUtils.getUser().getOrgcode();
        MdmOrgReqVo mdmOrgReqVo = new MdmOrgReqVo() {{
            this.setOrgCode(orgCode);
        }};
        Result<List<MdmOrgRespVo>> result = mdmOrgFeign.findSingleChildrenOrgList(mdmOrgReqVo);
        List<String> orgCodeList = null;
        if (result != null && result.isSuccess()) {
            if (CollectionUtil.listNotEmptyNotSizeZero(result.getResult())) {
                orgCodeList = result.getResult().stream().map(MdmOrgRespVo::getOrgCode).collect(Collectors.toList());
                reqVo.setVisitOrgCodeList(orgCodeList);
            }
        }
        Page<SfaVisitDealerDetailRespVo> page = new Page<>(reqVo.getPageNum(), reqVo.getPageSize());
        List<SfaVisitDealerDetailRespVo> list = sfaVisitDealerDetailMapper.findList(page, reqVo);

        list.forEach(data -> {
            SfaVisitPictureReqVo pictureReqVo = new SfaVisitPictureReqVo() {{
                this.setBusinessId(data.getId());
            }};
            List<SfaVisitPictureRespVo> sfaVisitPictureRespVos = sfaVisitPictureService.findSfaVisitPictureList(pictureReqVo);
            if (CollectionUtil.listNotEmptyNotSizeZero(sfaVisitPictureRespVos)) {
                data.setPhotoList(sfaVisitPictureRespVos);
            }
        });
        return PageResult.<SfaVisitDealerDetailRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }


    /**
     * 查询拜访数据信息(小地图)
     *
     * @param reqVo
     * @return
     */
    @Override
    public List<SfaVisitPlanInfoRespVo> findSfaVisitMapComplete(SfaVisitPlanInfoReqVo reqVo) {
        AssertUtils.isNotEmpty(reqVo.getVisitDate(), "拜访日期不能为空");
        if (!StringUtils.isNotEmpty(reqVo.getVisitUserName())) {
            String username = UserUtils.getUser().getUsername();
            reqVo.setVisitUserName(username);
        }
        List<SfaVisitPlanInfoRespVo> sfaVisitPlanInfoRespVoList = sfaVisitPlanInfoMapper.findSfaMapList(reqVo);
        if (!CollectionUtil.listNotEmptyNotSizeZero(sfaVisitPlanInfoRespVoList)) {
            return null;
        }
        //查询客户信息
        List<String> customerCodes = sfaVisitPlanInfoRespVoList.stream().
                filter(data -> data.getClientType().equals(SfaVisitEnum.ClientType.DEALER.getVal())).
                map(SfaVisitPlanInfoRespVo::getClientCode).collect(Collectors.toList());
        //终端编码
        List<String> terminalCodes = sfaVisitPlanInfoRespVoList.stream().
                filter(data -> data.getClientType().equals(SfaVisitEnum.ClientType.TERMINAL.getVal())).
                map(SfaVisitPlanInfoRespVo::getClientCode).collect(Collectors.toList());

        Map<String, MdmCustomerMsgContactPageRespVo> customerMap = new HashMap<>();
        Map<String, MdmTerminalContactPageVo> terminalMap = new HashMap<>();
        Result<PageResult<MdmCustomerMsgContactPageRespVo>> customerResult = mdmCustomerMsgFeign.customerContactPage(new MdmCustomerContactPageReqVo() {{
            this.setCustomerCodeList(customerCodes);
            this.setPageSize(-1);
        }});
        Result<PageResult<MdmTerminalContactPageVo>> terminalResult = mdmTerminalFeign.terminalContactPage(new MdmTerminalContactPageReqVo() {{
            this.setPageSize(-1);
            this.setTerminalCodeList(terminalCodes);
        }});

        List<SfaVisitPlanInfoRespVo> sfaVisitPlanInfoRespVos = new ArrayList<>();

        if (customerResult.isSuccess() && CollectionUtil.listNotEmptyNotSizeZero(customerResult.getResult().getData())) {
            customerMap = customerResult.getResult().getData().stream().collect(Collectors.toMap(MdmCustomerMsgContactPageRespVo::getCustomerCode, Function.identity()));
        }
        if (terminalResult.isSuccess() && CollectionUtil.listNotEmptyNotSizeZero(terminalResult.getResult().getData())) {
            terminalMap = terminalResult.getResult().getData().stream().collect(Collectors.toMap(MdmTerminalContactPageVo::getTerminalCode, Function.identity()));
        }
        for (SfaVisitPlanInfoRespVo data : sfaVisitPlanInfoRespVoList) {
            if (null != customerMap && customerMap.size() > 0 && customerMap.containsKey(data.getClientCode())) {
                MdmCustomerMsgContactPageRespVo mdmCustomer = customerMap.get(data.getClientCode());
                if (StringUtils.isNotEmpty(mdmCustomer.getLongitude()) && StringUtils.isNotEmpty(mdmCustomer.getLatitude())) {
                    data.setLongitude(new BigDecimal(mdmCustomer.getLongitude()));
                    data.setLatitude(new BigDecimal(mdmCustomer.getLatitude()));
                    sfaVisitPlanInfoRespVos.add(data);
                }
            }
            if (null != terminalMap && terminalMap.size() > 0 && terminalMap.containsKey(data.getClientCode())) {
                MdmTerminalContactPageVo mdmTerminal = terminalMap.get(data.getClientCode());
                if (StringUtils.isNotEmpty(mdmTerminal.getLongitude()) && StringUtils.isNotEmpty(mdmTerminal.getLatitude())) {
                    data.setLongitude(new BigDecimal(mdmTerminal.getLongitude()));
                    data.setLatitude(new BigDecimal(mdmTerminal.getLatitude()));
                    sfaVisitPlanInfoRespVos.add(data);
                }
            }
        }
        return sfaVisitPlanInfoRespVos;
    }


    /**
     * 更新经纬度
     */
    private void updateCustomerAddress(SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity, SfaVisitPlanInfoExecuteRedisData entity) {
        if (null == sfaVisitPlanInfoEntity.getLatitude() || null == sfaVisitPlanInfoEntity.getLongitude()) {
            if (null == entity.getInStoreLongitude() || null == entity.getInStoreLatitude()) {
                return;
            }
            List<MdmCustomerMsgReqVo> mdmCustomerMsgReqVos = Lists.newArrayList(new MdmCustomerMsgReqVo() {{
                this.setCustomerCode(entity.getClientCode());
                this.setLongitude(entity.getInStoreLongitude().toString());
                this.setLatitude(entity.getInStoreLatitude().toString());
            }});
            Result<Object> result = mdmCustomerMsgFeign.updateCoordinate(mdmCustomerMsgReqVos);
            ApiResultUtil.checkResult(result);
        }

    }

    /**
     * 计算在计划中的下单数
     * @param orderList
     * @param sfaVisitPlanInfoEntities
     * @return
     */
    private BigDecimal getOrderNumber(List<SfaAchievementAccomplishRecordEntity> orderList,Iterable<SfaVisitPlanInfoEntity> sfaVisitPlanInfoEntities){
        Set<String> codeList = orderList.stream().map(SfaAchievementAccomplishRecordEntity::getCustomerCode).collect(Collectors.toSet());
        ArrayList<String> codeActualList = Lists.newArrayList();
        sfaVisitPlanInfoEntities.forEach(s -> {
            if (codeList.contains(s.getClientCode())){
                codeActualList.add(s.getClientCode());
            }
        });
        return BigDecimal.valueOf(codeActualList.size());
    }

    @Override
    public MdmCustomerCountRespVo findVisitNumber(MdmCustomerCountReqVo reqVo) {
        MdmCustomerCountRespVo mdmCustomerCountRespVo = new MdmCustomerCountRespVo();

        //查询计划拜访数
        VisitPlanInfoEsReq req = new VisitPlanInfoEsReq();
        req.setPosCode(reqVo.getPosCode());
        req.setVisitBigType(SfaVisitEnum.VisitBigType.VISIT.getVal());
        req.setStartDate(reqVo.getStartDate());
        req.setEndDate(reqVo.getEndDate());
        BigDecimal planVisitNumber = BigDecimal.ZERO;
        List<SfaVisitPlanInfoEntity> sfaVisitPlanInfoEntities = Lists.newArrayList(sfaVisitPlanInfoEntityRepositories.search(req.buildQuery()));
        if (CollectionUtil.listNotEmptyNotSizeZero(sfaVisitPlanInfoEntities)) {
            Set<String> setPlanVisit = sfaVisitPlanInfoEntities.stream().map(SfaVisitPlanInfoEntity::getClientCode).collect(Collectors.toSet());
            planVisitNumber = BigDecimal.valueOf(setPlanVisit.size());
        }
//        BigDecimal planVisitNumber = sfaVisitDealerDetailMapper.findPlanVisitNumber(SfaVisitEnum.visitType.PLAN_VISIT.getVal(),CrmEnableStatusEnum.ENABLE.getCode(),
//                reqVo.getPosCode(),reqVo.getStartDate(),reqVo.getEndDate());
        mdmCustomerCountRespVo.setPlanVisitNumber(planVisitNumber);
        //查询计划中实际拜访数
        BigDecimal actualVisitNumber = BigDecimal.ZERO;
        req.setVisitStatus(SfaVisitEnum.visitStatus.V3.getVal());
        List<SfaVisitPlanInfoEntity> sfaVisitPlanInfoAccomplishEntities = Lists.newArrayList(sfaVisitPlanInfoEntityRepositories.search(req.buildQuery()));
        if (CollectionUtil.listNotEmptyNotSizeZero(sfaVisitPlanInfoAccomplishEntities)) {
            Set<String> setActualVisit = sfaVisitPlanInfoAccomplishEntities.stream().map(SfaVisitPlanInfoEntity::getClientCode).collect(Collectors.toSet());
            actualVisitNumber = BigDecimal.valueOf(setActualVisit.size());
        }
//        BigDecimal actualVisitNumber = sfaVisitDealerDetailMapper.findActualVisitNumber(SfaVisitEnum.visitType.PLAN_VISIT.getVal(),CrmEnableStatusEnum.ENABLE.getCode(),SfaVisitEnum.visitStatus.V3.getVal(),
//                reqVo.getPosCode(),reqVo.getStartDate(),reqVo.getEndDate());

        mdmCustomerCountRespVo.setActualVisitNumber(actualVisitNumber);
        //计划完成率
        BigDecimal visitCompletionRate = (planVisitNumber.compareTo(BigDecimal.ZERO) > 0 ? actualVisitNumber.divide(planVisitNumber, 4, BigDecimal.ROUND_HALF_UP).multiply(new BigDecimal("100").setScale(2)) : BigDecimal.ZERO);
        mdmCustomerCountRespVo.setVisitCompletionRate(visitCompletionRate);
        //查询下单数(拜访计划中的客户数量，去重)
        List<SfaAchievementAccomplishRecordEntity> orderList = sfaAchievementAccomplishRecordService.lambdaQuery().eq(SfaAchievementAccomplishRecordEntity::getObjectPosCode, reqVo.getPosCode())
                .eq(SfaAchievementAccomplishRecordEntity::getIndexCode, SfaVisitEnum.indexType.XD.getCode())
                .between(SfaAchievementAccomplishRecordEntity::getCreateTime, reqVo.getStartDate(), reqVo.getEndDate())
                .list();
        BigDecimal placeOrderNumber = BigDecimal.ZERO;
        if (CollectionUtil.listNotEmptyNotSizeZero(orderList)){
            placeOrderNumber = this.getOrderNumber(orderList, sfaVisitPlanInfoEntities);
        }
//        BigDecimal placeOrderNumber = sfaVisitDealerDetailMapper.findPlaceOrderNumber(SfaVisitEnum.visitType.PLAN_VISIT.getVal(), CrmEnableStatusEnum.ENABLE.getCode(), SfaVisitEnum.visitStatus.V3.getVal(),
//                reqVo.getPosCode(), reqVo.getStartDate(), reqVo.getEndDate());
//        if (null == placeOrderNumber) {
//            placeOrderNumber = BigDecimal.ZERO;
//        }
        mdmCustomerCountRespVo.setPlaceOrderNumber(placeOrderNumber);
        //销售达成率
        BigDecimal salesReachRate = (planVisitNumber.compareTo(BigDecimal.ZERO) > 0 ? placeOrderNumber.divide(planVisitNumber, 4, BigDecimal.ROUND_HALF_UP).multiply(new BigDecimal("100").setScale(2)) : BigDecimal.ZERO);
        mdmCustomerCountRespVo.setSalesReachRate(salesReachRate);
        //查询当前时间段被拜访过的客户数(计划内，去重)
        List<String> collect = sfaVisitPlanInfoAccomplishEntities.stream()
                .map(SfaVisitPlanInfoEntity::getClientCode).distinct().collect(Collectors.toList());
        BigDecimal visitCustNumber = BigDecimal.ZERO;
        if (CollectionUtil.listNotEmpty(collect)) {
            visitCustNumber = BigDecimal.valueOf(collect.size());
        }
        mdmCustomerCountRespVo.setVisitCustNumber(visitCustNumber);
        //查询总拜访数量（计划和临时）
        List<SfaAchievementTimeTotalRespVo> accomplishNum = achievementAccomplishRecordMapper.findPosCodeListAccomplishNum(Collections.singletonList(reqVo.getPosCode()), SfaVisitEnum.indexType.WDBF.getCode(), reqVo.getStartDate(), reqVo.getEndDate());
        BigDecimal visitTotalNumber = BigDecimal.ZERO;
        if (CollectionUtil.listNotEmpty(accomplishNum)) {
            visitTotalNumber = new BigDecimal(accomplishNum.get(0).getAccomplishNum());
        }
        mdmCustomerCountRespVo.setVisitTotalNumber(visitTotalNumber);
        return mdmCustomerCountRespVo;
    }

}
