package com.biz.crm.visitinfo.component;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.biz.crm.eunm.sfa.SfaVisitEnum;
import com.biz.crm.moblie.controller.visit.req.GetVisitListReq;
import com.biz.crm.mq.AbstractRocketMQConsumer;
import com.biz.crm.mq.RocketMQConstant;
import com.biz.crm.mq.RocketMQMessageBody;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgRespVo;
import com.biz.crm.util.JsonPropertyUtil;
import com.biz.crm.util.OrgUtil;
import com.biz.crm.visitinfo.model.SfaVisitCompleteInfoEntity;
import com.biz.crm.visitinfo.model.SfaVisitPlanInfoEntity;
import com.biz.crm.visitinfo.service.ISfaVisitCompleteInfoService;
import com.biz.crm.visitinfo.service.ISfaVisitPlanInfoService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.spring.annotation.ConsumeMode;
import org.apache.rocketmq.spring.annotation.RocketMQMessageListener;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import javax.annotation.Resource;
import java.util.List;
import java.util.stream.Collectors;


/**
 * 拜访日进度报表结算
 *
 * @author: luoqi
 * @Date: 2021-4-13 16:57
 * @version: V1.0
 * @Description:
 */
@Slf4j
@Component
@RocketMQMessageListener(topic = "${rocketmq.topic}" + "${rocketmq.environment-variable}",
        /**
         * tag
         * 可用 || 监听多个tag： "tag1 || tag2 || tag3"
         * 请把tag定义在 RocketMQConstant.CRM_MQ_TAG 内统一维护
        */
        selectorExpression = RocketMQConstant.CRM_MQ_TAG.VISIT_DAY_RATE_SETTLEMENT,
        /**
         * 相同分组下 consumer 可自动负载均衡
         * 请把consumerGroup定义在 RocketMQConstant.CONSUMER_GROUP 内统一维护
        */
        consumerGroup = RocketMQConstant.CONSUMER_GROUP.VISIT_DAY_RATE_SETTLEMENT + "${rocketmq.environment-variable}",
        /**
         * 默认集群消费， 可以设置 ConsumeMode.ORDERLY 使用广播消费
         * 也可使用集群模式模拟广播模式：
         * 启动多个不同 consumerGroup 的consumer实例
        */
        consumeMode = ConsumeMode.CONCURRENTLY)
public class VisitDayRateSettlementConsumer extends AbstractRocketMQConsumer {

    @Resource
    protected ISfaVisitCompleteInfoService sfaVisitCompleteInfoService;
    @Resource
    protected ISfaVisitPlanInfoService sfaVisitPlanInfoService;


    //获取消息
    @Override
    protected Object handleMessage(RocketMQMessageBody message) {
        String msgBody = message.getMsgBody();
        List<SfaVisitCompleteInfoEntity> completeInfoEntityList = JsonPropertyUtil.toArray(msgBody, SfaVisitCompleteInfoEntity.class);
        completeInfoEntityList.forEach(x -> {
            this.planInfoSettlement(x);
        });
        return "结算完成";
    }

    protected void planInfoSettlement(SfaVisitCompleteInfoEntity completeInfoEntity) {

        GetVisitListReq req = new GetVisitListReq();
        req.setVisitDate(completeInfoEntity.getVisitDate());
        req.setVisitUserName(completeInfoEntity.getVisitUserName());
        if (org.apache.commons.lang3.StringUtils.isBlank(completeInfoEntity.getVisitPosCode())) {
            completeInfoEntity.setVisitPosCode(completeInfoEntity.getVisitUserName());
            completeInfoEntity.setVisitPosName(completeInfoEntity.getVisitRealName());
        }
        req.setVisitPositionCode(completeInfoEntity.getVisitPosCode());
        //拜访
        req.setVisitBigType(SfaVisitEnum.VisitBigType.VISIT.getVal());
        List<SfaVisitPlanInfoEntity> planInfoOfVisit = this.sfaVisitPlanInfoService.doGetVisitInfoList(req)
            .stream().filter(v -> SfaVisitEnum.visitType.PLAN_VISIT.getVal().equals(v.getVisitType())).collect(Collectors.toList());
        //协访
        req.setVisitBigType(SfaVisitEnum.VisitBigType.HELP_VISIT.getVal());
        List<SfaVisitPlanInfoEntity> planInfoOfHelpVisit = this.sfaVisitPlanInfoService.doGetVisitInfoList(req)
            .stream().filter(v -> SfaVisitEnum.visitType.PLAN_VISIT.getVal().equals(v.getVisitType())).collect(Collectors.toList());
        //陌拜
        req.setVisitBigType(SfaVisitEnum.VisitBigType.UNFAMILIAR_VISIT.getVal());
        List<SfaVisitPlanInfoEntity> planInfoOfMoVisit = this.sfaVisitPlanInfoService.doGetVisitInfoList(req)
            .stream().filter(v -> SfaVisitEnum.visitType.TEMP_VISIT.getVal().equals(v.getVisitType())).collect(Collectors.toList());
        //拜访、协访和拜访都没计划，不用生成进度报表
        if (CollectionUtils.isEmpty(planInfoOfVisit) && CollectionUtils.isEmpty(planInfoOfHelpVisit) && CollectionUtils.isEmpty(planInfoOfMoVisit)) {
            return;
        }
        SfaVisitCompleteInfoEntity updateEntity = sfaVisitCompleteInfoService.getOne(Wrappers.lambdaQuery(SfaVisitCompleteInfoEntity.class)
                .eq(SfaVisitCompleteInfoEntity::getVisitDate, req.getVisitDate())
                .eq(SfaVisitCompleteInfoEntity::getVisitPosCode, req.getVisitPositionCode()));
        if (null == updateEntity) {
            updateEntity = new SfaVisitCompleteInfoEntity();
        }
        SfaVisitCompleteInfoEntity.countingInfoForVisit(updateEntity, planInfoOfVisit);
        SfaVisitCompleteInfoEntity.countingInfoForHelpVisit(updateEntity, planInfoOfHelpVisit);
        SfaVisitCompleteInfoEntity.countingInfoForMoVisit(updateEntity, planInfoOfHelpVisit);
        this.buildCompleteInfoEntity(updateEntity, completeInfoEntity);
        sfaVisitCompleteInfoService.saveOrUpdate(updateEntity);
    }

    protected void buildCompleteInfoEntity(SfaVisitCompleteInfoEntity updateEntity, SfaVisitCompleteInfoEntity completeInfoEntity) {

        updateEntity.setVisitUserName(completeInfoEntity.getVisitUserName());
        updateEntity.setVisitRealName(completeInfoEntity.getVisitRealName());

        updateEntity.setVisitPosCode(completeInfoEntity.getVisitPosCode());
        updateEntity.setVisitPosName(completeInfoEntity.getVisitPosName());

        updateEntity.setVisitOrgCode(completeInfoEntity.getVisitOrgCode());
        updateEntity.setVisitOrgName(completeInfoEntity.getVisitOrgName());
        if (StringUtils.isNotBlank(completeInfoEntity.getVisitOrgCode())) {
            MdmOrgRespVo orgRespVo = OrgUtil.getOrgByCode(completeInfoEntity.getVisitOrgCode());
            if (null != orgRespVo) {
                updateEntity.setVisitParentOrgCode(orgRespVo.getParentCode());
                updateEntity.setVisitParentOrgName(orgRespVo.getParentName());
            }
        }

        updateEntity.setVisitDate(completeInfoEntity.getVisitDate());
        updateEntity.setVisitYearMonth(updateEntity.getVisitDate().substring(0, 7));
    }

}
