package com.biz.crm.visitinfo.controller;

import com.biz.crm.aop.CrmLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.util.Result;
import com.biz.crm.visitinfo.model.SfaVisitCompleteInfoEntity;
import com.biz.crm.visitinfo.req.RegionalVisitFrequencyReqVo;
import com.biz.crm.visitinfo.req.VisitCompleteInfoSearchReqVo;
import com.biz.crm.visitinfo.resp.report.RegionalVisitFrequencyRespVo;
import com.biz.crm.visitinfo.resp.report.SfaVisitCompleteInfoRespVo;
import com.biz.crm.visitinfo.resp.report.SfaVisitRouteRespVo;
import com.biz.crm.visitinfo.service.ISfaVisitCompleteInfoService;
import com.biz.crm.visitinfo.service.ISfaVisitInfoStepFormService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;

/**
 * @author YuanZiJian
 * @date 2021/3/29 13:49
 * @version: V1.0
 */
@Slf4j
@RestController
@RequestMapping("/sfaVisitComplete")
@Api(tags = "拜访完成进度报表 ")
public class SfaVisitCompleteController {
    @Resource
    private ISfaVisitCompleteInfoService sfaVisitCompleteInfoService;
    @Autowired
    private ISfaVisitInfoStepFormService sfaVisitInfoStepFormService;


    /**
     * 查询拜访完成报表——日进度列表
     */
    @ApiOperation(value = "查询拜访完成报表——日进度列表")
    @PostMapping("/getSfaVisitCompleteDailyList")
    @CrmLog
    public Result<PageResult<SfaVisitCompleteInfoRespVo>> getSfaVisitCompleteDailyList(@RequestBody VisitCompleteInfoSearchReqVo visitCompleteInfoSearchReqVo) {
        PageResult<SfaVisitCompleteInfoRespVo> visitCompleteInfoDailyList = sfaVisitCompleteInfoService.getVisitCompleteInfoDailyList(visitCompleteInfoSearchReqVo);
        return Result.ok(visitCompleteInfoDailyList);
    }


    /**
     * 查询拜访完成报表——月进度列表
     */
    @ApiOperation(value = "查询拜访完成报表——月进度列表")
    @PostMapping("/getSfaVisitCompleteMonthList")
    @CrmLog
    public Result<PageResult<SfaVisitCompleteInfoRespVo>> getSfaVisitCompleteMonthList(@RequestBody VisitCompleteInfoSearchReqVo visitCompleteInfoSearchReqVo) {
        PageResult<SfaVisitCompleteInfoRespVo> visitCompleteInfoDailyList = sfaVisitCompleteInfoService.getVisitCompleteInfoMonthList(visitCompleteInfoSearchReqVo);
        return Result.ok(visitCompleteInfoDailyList);
    }


    /**
     * 查询拜访完成报表——日进度路线图
     */
    @ApiOperation(value = "查询拜访完成报表——日进度路线图")
    @GetMapping("/getSfaVisitCompleteDaily")
    @CrmLog
    public Result<SfaVisitRouteRespVo> getSfaVisitCompleteDaily(@RequestParam(value = "date", required = false) String date, @RequestParam(value = "posCode", required = false) String posCode) {
        return sfaVisitCompleteInfoService.dailyCompleteInfo(date, posCode);
    }


    @ApiOperation(value = "刷新拜访日进度")
    @GetMapping("/planInfoSettlementForWeb")
    @CrmLog
    public Result planInfoSettlementForWeb(@RequestParam(required = false) String visitDateTemp) {
        sfaVisitCompleteInfoService.planInfoSettlementForWeb(visitDateTemp);
        return Result.ok();
    }


    @CrmLog
    @ApiOperation(value = "解析拜访明细数据步骤数据")
    @GetMapping("resolvingVisitPlanInfoStepForm")
    public Result resolvingVisitPlanInfoStepForm(@RequestParam String visitDate) {
        sfaVisitInfoStepFormService.resolvingVisitPlanInfoStepForm(visitDate);
        return Result.ok();
    }


    @GetMapping("brushVisitCompleteInfo")
    @ApiOperation(value = "刷新拜访结算任务")
    public Result brushVisitCompleteInfo(){
        sfaVisitCompleteInfoService.brushVisitCompleteInfo();
        return Result.ok();
    }

    @CrmLog
    @ApiOperation(value = "区域拜访频次报表")
    @PostMapping("regionalVisitFrequency")
    public Result<PageResult<RegionalVisitFrequencyRespVo>> regionalVisitFrequency(@RequestBody RegionalVisitFrequencyReqVo reqVo) {
        PageResult<RegionalVisitFrequencyRespVo> list = sfaVisitCompleteInfoService.regionalVisitFrequency(reqVo);
        return Result.ok(list);
    }


}
