package com.biz.crm.visitinfo.controller.report;

import com.biz.crm.aop.CrmLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.config.CrmDictMethod;
import com.biz.crm.eunm.sfa.SfaVisitEnum;
import com.biz.crm.nebular.sfa.visitdealer.req.SfaVisitDealerDetailReqVo;
import com.biz.crm.nebular.sfa.visitdealer.req.SfaVisitDealerMonthlyReportReqVo;
import com.biz.crm.nebular.sfa.visitdealer.resp.SfaVisitDealerDetailRespVo;
import com.biz.crm.nebular.sfa.visitdealer.resp.SfaVisitDealerMonthlyReportRespVo;
import com.biz.crm.nebular.sfa.visitinfo.resp.SfaVisitPlanInfoRespVo;
import com.biz.crm.util.Result;
import com.biz.crm.visitdealer.service.ISfaVisitDealerDetailService;
import com.biz.crm.visitdealer.service.ISfaVisitDealerMonthlyReportService;
import com.biz.crm.visitinfo.req.GetVisitReportsPageReq;
import com.biz.crm.visitinfo.req.PlanInfoSettlementReq;
import com.biz.crm.visitinfo.resp.report.VisitInfoReportResp;
import com.biz.crm.visitinfo.service.impl.SfaVisitPlanInfoRedisDataServiceEsImpl;
import com.biz.crm.visitinfo.service.impl.SfaVisitPlanInfoServiceEsImpl;
import com.biz.crm.visitinfo.service.impl.VisitPlanInfoHelper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;


/**
 *
 * 拜访报表
 *  @author: luoqi
 *  @Date: 2021-3-12 15:18
 *  @version: V1.0
 *  @Description:
 */
@Slf4j
@RestController
@RequestMapping("/sfaVisitReportController")
@Api(tags = "拜访报表")
public class SfaVisitReportController {
    @Resource
    private SfaVisitPlanInfoServiceEsImpl sfaVisitPlanInfoServiceEsImpl;

    @Resource
    private SfaVisitPlanInfoRedisDataServiceEsImpl sfaVisitPlanInfoRedisDataServiceEsImpl;

    @Resource
    private ISfaVisitDealerDetailService sfaVisitDealerDetailService;
    @Resource
    private ISfaVisitDealerMonthlyReportService sfaVisitDealerMonthlyReportService;

    @Resource
    private VisitPlanInfoHelper visitPlanInfoHelper;

    /**
     * 拜访计划结算任务 WEB端
     */
    @ApiOperation(value = "拜访计划结算 WEB端")
    @PostMapping("/planInfoSettlementJobForWeb")
    @CrmLog
    public Result planInfoSettlementJobForWeb(@RequestBody PlanInfoSettlementReq req) {
        visitPlanInfoHelper.planInfoSettlementForWeb(req);
        return Result.ok();
    }

    /**
     * 拜访计划明细报表
     */
    @ApiOperation(value = "拜访计划明细报表")
    @PostMapping("/visitPlanInfoReport")
    @CrmLog
    public Result<PageResult<SfaVisitPlanInfoRespVo>> visitPlanInfoReport(@RequestBody GetVisitReportsPageReq req) {
        PageResult<SfaVisitPlanInfoRespVo> result = sfaVisitPlanInfoServiceEsImpl.getVisitPlanInfoReportPage(req);
        return Result.ok(result);
    }




    /**
     * 拜访明细报表
     */
    @ApiOperation(value = "拜访明细报表")
    @PostMapping("/visitExecuteInfoReport")
    @CrmLog
    public Result<PageResult<VisitInfoReportResp>> visitExecuteInfoReport(@RequestBody GetVisitReportsPageReq reqVo) {
        return Result.ok(this.sfaVisitPlanInfoRedisDataServiceEsImpl.getVisitExecuteInfoReportPage(reqVo));
    }

//    /**
//     * 拜访明细报表
//     */
//    @ApiOperation(value = "拜访明细报表")
//    @GetMapping("/getStepInfoById")
//    @CrmLog
//    @CrmDictMethod
//    public Result<PageResult<VisitInfoReportResp>> getStepInfoById(String id, String pageCode) {
////        this.sfaVisitPlanInfoRedisDataServiceEsImpl.getVisitInfoReportPage(reqVo);
////        reqVo.setVisitStatus(SfaVisitEnum.visitStatus.V3.getVal());
////        PageResult<SfaVisitDealerDetailRespVo> result = sfaVisitDealerDetailService.findList(reqVo);
//        //todo   步骤执行详情查询 待实现
//        return Result.ok(this.sfaVisitPlanInfoRedisDataServiceEsImpl.getVisitInfoReportPage(reqVo));
//    }

    /**
     * 经销商拜访明细报表
     */
    @ApiOperation(value = "经销商拜访明细报表")
    @PostMapping("/findDealerDetailReportList")
    @CrmLog
    @Deprecated
    @CrmDictMethod
    public Result<PageResult<SfaVisitDealerDetailRespVo>> findDealerDetailReportList(@RequestBody SfaVisitDealerDetailReqVo reqVo) {
        //todo 经销商拜访明细报表
        reqVo.setVisitStatus(SfaVisitEnum.visitStatus.V3.getVal());
        PageResult<SfaVisitDealerDetailRespVo> result = sfaVisitDealerDetailService.findList(reqVo);
        return Result.ok(result);
    }

    /**
     * 经销商月度拜访明细报表
     */
    @ApiOperation(value = "经销商月度拜访明细报表")
    @PostMapping("/list")
    @CrmLog
    public Result<PageResult<SfaVisitDealerMonthlyReportRespVo>> list(@RequestBody SfaVisitDealerMonthlyReportReqVo sfaVisitDealerMonthlyReportReqVo) {
        //todo 经销商月度拜访明细报表
        PageResult<SfaVisitDealerMonthlyReportRespVo> result = sfaVisitDealerMonthlyReportService.findList(sfaVisitDealerMonthlyReportReqVo);
        return Result.ok(result);
    }
}
