package com.biz.crm.visitinfo.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.eunm.sfa.SfaVisitEnum;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import com.google.common.collect.Lists;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;

import javax.persistence.Index;
import java.math.BigDecimal;
import java.util.List;

/**
 * 拜访完成进度报表
 * @author YuanZiJian
 * @date 2021/3/26 16:16
 * @version: V1.0
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("sfa_visit_complete_info")
@CrmTable(name = "sfa_visit_complete_info", tableNote = "拜访进度完成表", indexes = {
        @Index(name = "sfa_visit_complete_info_index1", columnList = "visit_user_name, visit_pos_code, visit_org_code"),
        @Index(name = "sfa_visit_complete_info_index2", columnList = "visit_year_month"),
        @Index(name = "sfa_visit_complete_info_index3", columnList = "visit_date")
})
public class SfaVisitCompleteInfoEntity extends CrmExtTenEntity<SfaVisitCompleteInfoEntity> {

    /**
     * 人员账号;人员账号
     */
    @CrmColumn(name = "visit_user_name", length = 32 , note ="人员账号" )
    private String visitUserName;

    /**
     * 人员姓名;人员姓名
     */
    @CrmColumn(name = "visit_real_name", length = 32 , note ="人员姓名" )
    private String visitRealName;

    /**
     * 人员职位编码;人员职位编码
     */
    @CrmColumn(name = "visit_pos_code", length = 32 , note ="人员职位编码" )
    private String visitPosCode;

    /**
     * 人员职位名称;人员职位名称
     */
    @CrmColumn(name = "visit_pos_name", length = 32 , note ="人员职位名称" )
    private String visitPosName;

    /**
     * 人员所属组织编码;人员所属组织编码
     */
    @CrmColumn(name = "visit_org_code", length = 32 , note ="人员所属组织编码" )
    private String visitOrgCode;

    /**
     * 人员所属组织名称;人员所属组织名称
     */
    @CrmColumn(name = "visit_org_name", length = 32 , note ="人员所属组织名称" )
    private String visitOrgName;

    /**
     * 上级组织编码
     */
    @CrmColumn(name = "visit_parent_org_code", length = 32 , note ="上级组织编码" )
    private String visitParentOrgCode;

    /**
     * 上级组织名称
     */
    @CrmColumn(name = "visit_parent_org_name", length = 32 , note ="上级组织名称" )
    private String visitParentOrgName;

    /**
     * 拜访日期;拜访日期yyyy-MM-dd
     */
    @CrmColumn(name = "visit_date", length = 32 , note ="拜访日期" )
    private String visitDate;

    @CrmColumn(name = "visit_year_month", length = 20 , note ="拜访月份" )
    private String visitYearMonth;


    /**
     * 计划完成拜访客户数
     */
    @CrmColumn(name = "plan_complete_visit_num",mysqlType = "int(10)", oracleType = "NUMBER(10,0)" ,length = 10 , note ="计划完成拜访客户数" )
    private Integer planCompleteVisitNum = 0;
    /**
     * 实际完成拜访客户数
     */
    @CrmColumn(name = "real_complete_visit_num",mysqlType = "int(10)", oracleType = "NUMBER(10,0)" , length = 10 , note ="实际完成拜访客户数" )
    private Integer realCompleteVisitNum  = 0;
    /**
     * 未完成拜访客户数
     */
    @CrmColumn(name = "not_complete_visit_num",mysqlType = "int(10)", oracleType = "NUMBER(10,0)" ,length = 10 , note ="未完成拜访客户数" )
    private Integer notCompleteVisitNum  = 0;
    /**
     * 异常提报拜访客户数
     */
    @CrmColumn(name = "error_complete_visit_num",mysqlType = "int(10)", oracleType = "NUMBER(10,0)" , length = 10 , note ="异常提报拜访客户数" )
    private Integer errorCompleteVisitNum = 0;
    /**
     * 拜访完成百分比
     */
    @CrmColumn(name = "complete_visit_percent", length = 10 , note ="拜访完成百分比" )
    private String completeVisitPercent = BigDecimal.ZERO.toString();

    /**
     * 计划完成协访客户数
     */
    @CrmColumn(name = "plan_complete_help_visit_num",mysqlType = "int(10)", oracleType = "NUMBER(10,0)" , length = 10 , note ="计划完成协访客户数" )
    private Integer planCompleteHelpVisitNum = 0;
    /**
     * 实际完成协访客户数
     */
    @CrmColumn(name = "real_complete_help_visit_num",mysqlType = "int(10)", oracleType = "NUMBER(10,0)" , length = 10 , note ="实际完成协访客户数" )
    private Integer realCompleteHelpVisitNum = 0;
    /**
     * 未完成协访客户数
     */
    @CrmColumn(name = "not_complete_help_visit_num",mysqlType = "int(10)", oracleType = "NUMBER(10,0)" , length = 10 , note ="未完成协访客户数" )
    private Integer notCompleteHelpVisitNum = 0;
    /**
     * 异常提报协访客户数
     */
    @CrmColumn(name = "error_complete_help_visit_num",mysqlType = "int(10)", oracleType = "NUMBER(10,0)" , length = 10 , note ="异常提报协访客户数" )
    private Integer errorCompleteHelpVisitNum =0;
    /**
     * 协防完成百分比
     */
    @CrmColumn(name = "complete_help_visit_percent", length = 10 , note ="协防完成百分比" )
    private String completeHelpVisitPercent = BigDecimal.ZERO.toString();
    /**
     * 陌拜完成数量
     */
    @CrmColumn(name = "mo_visit_complete_num",mysqlType = "int(10)", oracleType = "NUMBER(10,0)" , length = 10 , note ="陌拜完成数量" )
    private Integer moVisitCompleteNum =0;

    /**
     * 拜访实际完成数 加一
     * @method addRealCompleteVisitNum
     * @date: 2021/3/28 14:34
     * @author: YuanZiJian
     * @return voidbrushVisitCompleteInfo
     */
    public void addRealCompleteVisitNum(){
        this.realCompleteVisitNum += 1;
    }

    /**
     * 拜访异常数完成数 加一
     * @method addRealCompleteVisitNum
     * @date: 2021/3/28 14:34
     * @author: YuanZiJian
     * @return void
     */
    public void addErrorCompleteVisitNum(){
        this.errorCompleteVisitNum += 1;
    }

    /**
     * 拜访未完成数 加一
     * @method addRealCompleteVisitNum
     * @date: 2021/3/28 14:34
     * @author: YuanZiJian
     * @return void
     */
    public void addNotCompleteVisitNum(){
        this.notCompleteVisitNum += 1;
    }

    /**
     * 协访实际完成数 加一
     * @method addRealCompleteVisitNum
     * @date: 2021/3/28 14:34
     * @author: YuanZiJian
     * @return void
     */
    public void addRealCompleteHelpVisitNum(){
        this.realCompleteHelpVisitNum += 1;
    }

    /**
     * 协访异常完成数 加一
     * @method addErrorCompleteHelpVisitNum
     * @date: 2021/3/28 14:34
     * @author: YuanZiJian
     * @return void
     */
    public void addErrorCompleteHelpVisitNum(){
        this.errorCompleteHelpVisitNum += 1;
    }

    /**
     * 协访未完成数 加一
     * @method addRealCompleteVisitNum
     * @date: 2021/3/28 14:34
     * @author: YuanZiJian
     * @return void
     */
    public void addNotCompleteHelpVisitNum(){
        this.notCompleteHelpVisitNum += 1;
    }

    /**
     * 陌拜完成数 加一
     * @method addMoVisitCompleteNum
     */
    public void addMoVisitCompleteNum(){
        this.moVisitCompleteNum += 1;
    }

    /**
     * 计算协访计划完成客户数及完成百分比
     * @param completeInfoEntity
     * @param planInfos
     */
    public static void countingInfoForHelpVisit(SfaVisitCompleteInfoEntity completeInfoEntity, List<SfaVisitPlanInfoEntity> planInfos){
        if(null == planInfos){
            planInfos = Lists.newArrayList();
        }
        for (SfaVisitPlanInfoEntity planInfo : planInfos) {
            if(SfaVisitEnum.HelpVisitStatus.ALREADY_SUCCESS.getVal().equals(planInfo.getVisitStatus())){
                completeInfoEntity.addRealCompleteHelpVisitNum();
            } else if (SfaVisitEnum.HelpVisitStatus.NO_COMMIT.getVal().equals(planInfo.getVisitStatus()) ||
                SfaVisitEnum.HelpVisitStatus.ALREADY_OVERDUE.getVal().equals(planInfo.getVisitStatus())) {
              completeInfoEntity.addNotCompleteHelpVisitNum();
            }else if(SfaVisitEnum.HelpVisitStatus.EX.getVal().equals(planInfo.getVisitStatus())){
                completeInfoEntity.addErrorCompleteHelpVisitNum();
            }
        }
        completeInfoEntity.setPlanCompleteHelpVisitNum(planInfos.size());
        String completeHelpVisitPercent = "0";
        if(!Integer.valueOf(0).equals(completeInfoEntity.getPlanCompleteHelpVisitNum())){
            //保留两位小数，四舍五入
            completeHelpVisitPercent = BigDecimal.valueOf(completeInfoEntity.getRealCompleteHelpVisitNum())
                    .divide(BigDecimal.valueOf(completeInfoEntity.getPlanCompleteHelpVisitNum()),2,BigDecimal.ROUND_HALF_UP)
                    .multiply(BigDecimal.valueOf(100))
                    .toString();
        }

        completeInfoEntity.setCompleteHelpVisitPercent(completeHelpVisitPercent);
    }

    /**
     * 计算拜访计划完成客户数及完成百分比
     * @param completeInfoEntity
     * @param planInfos
     */
    public static void countingInfoForVisit(SfaVisitCompleteInfoEntity completeInfoEntity, List<SfaVisitPlanInfoEntity> planInfos){
        if(null == planInfos){
            planInfos = Lists.newArrayList();
        }
        for (SfaVisitPlanInfoEntity planInfo : planInfos) {
            if(SfaVisitEnum.visitStatus.V3.getVal().equals(planInfo.getVisitStatus())){
                completeInfoEntity.addRealCompleteVisitNum();
            } else if (SfaVisitEnum.visitStatus.V5.getVal().equals(planInfo.getVisitStatus()) ||
                SfaVisitEnum.visitStatus.V6.getVal().equals(planInfo.getVisitStatus())) {
                completeInfoEntity.addNotCompleteVisitNum();
            }else if(SfaVisitEnum.visitStatus.V4.getVal().equals(planInfo.getVisitStatus())){
                completeInfoEntity.addErrorCompleteVisitNum();
            }
        }
        completeInfoEntity.setPlanCompleteVisitNum(planInfos.size());
        String completeVisitPercent = "0";
        if(!Integer.valueOf(0).equals(completeInfoEntity.getPlanCompleteVisitNum())){
            //保留两位小数，四舍五入
            completeVisitPercent = BigDecimal.valueOf(completeInfoEntity.getRealCompleteVisitNum())
                    .divide(BigDecimal.valueOf(completeInfoEntity.getPlanCompleteVisitNum()),2,BigDecimal.ROUND_HALF_UP)
                    .multiply(BigDecimal.valueOf(100))
                    .toString();
        }

        completeInfoEntity.setCompleteVisitPercent(completeVisitPercent);
    }

    /**
     * 计算陌拜计划完成客户数
     * @param completeInfoEntity
     * @param planInfos
     */
    public static void countingInfoForMoVisit(SfaVisitCompleteInfoEntity completeInfoEntity, List<SfaVisitPlanInfoEntity> planInfos){
        if(null == planInfos){
            return;
        }
        for (SfaVisitPlanInfoEntity planInfo : planInfos) {
            if(SfaVisitEnum.MoVisitStatus.ALREADY_SUCCESS.getVal().equals(planInfo.getVisitStatus())){
                completeInfoEntity.addMoVisitCompleteNum();
            }
        }
    }
}
