package com.biz.crm.visitinfo.model;

import com.biz.crm.collection.controller.resp.VisitStepResp;
import com.biz.crm.eunm.sfa.SfaVisitEnum;
import com.biz.crm.nebular.sfa.collection.resp.SfaVisitRoleDirectoryRespVo;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.data.elasticsearch.annotations.Document;
import org.springframework.data.elasticsearch.annotations.Field;
import org.springframework.data.elasticsearch.annotations.FieldType;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;


/**
 * 拜访计划明细执行数据
 *  @author: luoqi
 *  @Date: 2021-3-5 22:04
 *  @version: V1.0
 *  @Description:
 */
@Data
@Document(indexName = SfaVisitPlanInfoRedisData.TABLE_NAME, type = SfaVisitPlanInfoRedisData.TABLE_NAME)
public class SfaVisitPlanInfoRedisData extends SfaVisitPlanInfoEntity {
    public static SfaVisitPlanInfoRedisData getInstance(){
        return SfaVisitPlanInfoRedisData.Instance.instance;
    }
    private static  class Instance{
        private static final SfaVisitPlanInfoRedisData instance = new SfaVisitPlanInfoRedisData();
    }
    public static final String TABLE_NAME = "sfa_visit_plan_info_redis_data";
    public static final String EXECUTE = "EXECUTE";

    private SfaVisitEnum.VISIT_OFF_LINE lineType;

    //拜访计划明细执行
//    @Field(type = FieldType.Object)
    private SfaVisitPlanInfoExecuteRedisData sfaVisitPlanInfoExecuteRedisData;
    //执行步骤
    private List<VisitStepResp> step;

    @ApiModelProperty("是否离线数据")
    private String isOffLine;

    /**
     *获取用户指定拜访日期的 redisHash
     * @param visitDate
     * @param visitUserName
     * @param visitPosCode
     * @return
     */
    @Override
    public StringJoiner redisHash(String visitDate, String visitUserName, String visitPosCode, String visitBigType){
        return super.redisHash(visitDate, visitUserName, visitPosCode, visitBigType).add(EXECUTE);
    }


    /**
     * 汇总步骤状态
     * @return
     */
    public Map<String,String> summaryStepStatus(){
        List<VisitStepResp> step = this.getStep();
        Map<String,String> stepMap = new HashMap<>();
        if(null == step){
            return stepMap;
        }
        step.forEach(data->{
            stepMap.put(data.getStepName(), data.getIsSuccessDesc());
        });
        return stepMap;
    }


}
