package com.biz.crm.visitinfo.req;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.elasticsearch.core.query.NativeSearchQuery;
import org.springframework.data.elasticsearch.core.query.NativeSearchQueryBuilder;

/**
 * 查询时间段拜访计划（报表，统计时间段内的计划拜访数）
 * @author yangshan
 * @date 2021/4/3 16:43
 */
@Data
@ApiModel("查询时间段内拜访计划")
public class VisitPlanInfoEsReq {

    @ApiModelProperty("职位编码")
    private String posCode;

    @ApiModelProperty("开始时间")
    private String startDate;

    @ApiModelProperty("结束时间")
    private String endDate;

    @ApiModelProperty("拜访大类")
    private String visitBigType;

    @ApiModelProperty("拜访状态")
    private String visitStatus;

    @ApiModelProperty("username")
    private String username;

    public BoolQueryBuilder buildQuery(){
        BoolQueryBuilder builder = QueryBuilders.boolQuery();
        //builder下有must、should以及mustNot 相当于sql中的and、or以及not
        //设置模糊搜索
        if(StringUtils.isNotBlank(this.getPosCode())){
            builder.must(QueryBuilders.termQuery("visitPosCode.keyword", this.getPosCode()));
        }
        if(StringUtils.isNotBlank(this.getUsername())){
            builder.must(QueryBuilders.termQuery("visitUserName.keyword", this.getUsername()));
        }
        if(StringUtils.isNotBlank(this.getVisitBigType())){
            builder.must(QueryBuilders.termQuery("visitBigType", this.getVisitBigType()));
        }
        if(StringUtils.isNotBlank(this.getVisitStatus())){
            builder.must(QueryBuilders.termQuery("visitStatus.keyword", this.getVisitStatus()));
        }
        if(StringUtils.isNotBlank(this.getStartDate())){
            builder.must(QueryBuilders.rangeQuery("visitDate").gte(this.getStartDate()));
        }
        if(StringUtils.isNotBlank(this.getEndDate())){
            builder.must(QueryBuilders.rangeQuery("visitDate").lte(this.getEndDate()));
        }
//        builder.withSort(SortBuilders.fieldSort("visitDate").order(SortOrder.DESC));
        return builder;
    }
}
