package com.biz.crm.visitinfo.resp.report;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * @author hx
 * @ClassName RegionalVisitFrequencyRespVo
 * @Description 区域拜访频次报表返回vo
 * @date 2022/03/25
 */
@Data
@ApiModel("区域拜访频次报表返回vo")
public class RegionalVisitFrequencyRespVo {

    @ApiModelProperty("日期")
    private String visitDate;

    @ApiModelProperty("周")
    private String week;

    @ApiModelProperty("区域")
    private String regional;

    @ApiModelProperty("终端拜访总数")
    private Integer terminalVisitTotalNum;

    @ApiModelProperty("经销商拜访总数")
    private Integer customerVisitTotalNum;

    @ApiModelProperty("人员总数")
    private Integer memberTotalNum;

    /**
     * 因为只保留整数
     */
    @ApiModelProperty("终端拜访频次/人均")
    private BigDecimal terminalVisitFrequency;

    @ApiModelProperty("经销商拜访频次/人均")
    private BigDecimal customerVisitFrequency;

}
