package com.biz.crm.visitinfo.resp.report;


import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 拜访完成进度报表
 * @author YuanZiJian
 * @date 2021/3/26 17:10
 * @version: V1.0
 */
@Data
@ApiModel("查询拜访完成进度报表分页返回Vo")
public class SfaVisitCompleteInfoRespVo {

    /**
     * 人员账号;人员账号
     */
    @ApiModelProperty("人员账号" )
    private String visitUserName;

    /**
     * 人员姓名;人员姓名
     */
    @ApiModelProperty("人员姓名" )
    private String visitRealName;

    /**
     * 人员职位编码;人员职位编码
     */
    @ApiModelProperty("人员职位编码" )
    private String visitPosCode;

    /**
     * 人员职位名称;人员职位名称
     */
    @ApiModelProperty("人员职位名称" )
    private String visitPosName;

    /**
     * 人员所属组织编码;人员所属组织编码
     */
    @ApiModelProperty("人员所属组织编码" )
    private String visitOrgCode;

    /**
     * 人员所属组织名称;人员所属组织名称
     */
    @ApiModelProperty("人员所属组织名称" )
    private String visitOrgName;

    /**
     * 上级组织编码
     */
    @ApiModelProperty("上级组织编码" )
    private String visitParentOrgCode;

    /**
     * 上级组织名称
     */
    @ApiModelProperty("上级组织名称" )
    private String visitParentOrgName;

    /**
     * 拜访日期;拜访日期yyyy-MM-dd
     */
    @ApiModelProperty("拜访日期" )
    private String visitDate;

    @ApiModelProperty("年月")
    private String visitYearMonth;







    /**
     * 计划完成拜访客户数
     */
    @ApiModelProperty("计划完成拜访客户数")
    private Integer planCompleteVisitNum;
    /**
     * 实际完成拜访客户数
     */
    @ApiModelProperty("实际完成拜访客户数")
    private Integer realCompleteVisitNum;
    /**
     * 未完成拜访客户数
     */
    @ApiModelProperty("未完成拜访客户数")
    private Integer notCompleteVisitNum;
    /**
     * 异常提报拜访客户数
     */
    @ApiModelProperty("异常提报拜访客户数")
    private Integer errorCompleteVisitNum;
    /**
     * 拜访完成百分比
     */
    @ApiModelProperty("拜访完成百分比")
    private String completeVisitPercent;

    /**
     * 计划完成协访客户数
     */
    @ApiModelProperty("计划完成协访客户数")
    private Integer planCompleteHelpVisitNum;
    /**
     * 实际完成协访客户数
     */
    @ApiModelProperty("实际完成协访客户数")
    private Integer realCompleteHelpVisitNum;
    /**
     * 未完成协访客户数
     */
    @ApiModelProperty("未完成协访客户数")
    private Integer notCompleteHelpVisitNum;
    /**
     * 异常提报协访客户数
     */
    @ApiModelProperty("异常提报协访客户数")
    private Integer errorCompleteHelpVisitNum;
    /**
     * 协防完成百分比
     */
    @ApiModelProperty("协防完成百分比")
    private String completeHelpVisitPercent;
    /**
     * 陌拜完成数量
     */
    @ApiModelProperty("陌拜完成数量")
    private Integer moVisitCompleteNum;
}
