package com.biz.crm.visitinfo.resp.report;

import com.biz.crm.collection.controller.resp.BaseVisitStepResp;
import com.biz.crm.collection.controller.resp.VisitStepResp;
import com.biz.crm.config.CrmDict;
import com.biz.crm.nebular.mdm.CrmExtTenVo;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.visitstep.resp.SfaVisitStepFromRespVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.data.elasticsearch.annotations.Field;
import org.springframework.data.elasticsearch.annotations.FieldType;
import org.springframework.data.elasticsearch.annotations.Mapping;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

@Data
@ApiModel(value = "拜访明细报表Resp")
public class VisitInfoReportResp extends CrmExtTenVo {

    private String id;

    private String needInStoreStep;

    private String needOutStoreStep;

    private BigDecimal inStoreLongitude;

    private BigDecimal inStoreLatitude;

    private BigDecimal outStoreLongitude;

    private BigDecimal outStoreLatitude;

    private String visitDetailStepJson;

    @ApiModelProperty("人员账号;")
    private String visitUserName;

    @ApiModelProperty("人员姓名;")
    private String visitRealName;

    @ApiModelProperty("人员职位编码;")
    private String visitPosCode;

    @ApiModelProperty("人员职位名称;")
    private String visitPosName;

    @ApiModelProperty("人员所属组织编码;")
    private String visitOrgCode;

    @ApiModelProperty("人员所属组织名称;")
    private String visitOrgName;

    @ApiModelProperty("人员上级所属组织编码;")
    private String visitParentOrgCode;

    @ApiModelProperty("人员上级所属组织名称;")
    private String visitParentOrgName;

    @ApiModelProperty("拜访日期;拜访日期yyyy-MM-dd")
    private String visitDate;

    @ApiModelProperty("拜访类型;拜访类型(临时拜访/计划拜访)")
    private String visitType;

    @ApiModelProperty("拜访类型;拜访类型(临时拜访/计划拜访)")
    private String visitTypeName;

    /**
     * 拜访大类
     */
    @ApiModelProperty("拜访大类（VISIT:拜访，HELP_VISIT:协访，UNFAMILIAR_VISIT:陌拜）")
    private String visitBigType;

    /**
     * 拜访大类
     */
    @ApiModelProperty("拜访大类（VISIT:拜访，HELP_VISIT:协访）")
    private String visitBigTypeName;

    @ApiModelProperty("客户编码;")
    private String clientCode;

    @ApiModelProperty("客户名称;")
    private String clientName;

    @ApiModelProperty("客户类型;")
    private String clientType;

    @ApiModelProperty("客户类型;")
    private String clientTypeName;

    @ApiModelProperty("客户细类")
    private String clientSubclass;

    @ApiModelProperty("客户细类")
    private String clientSubclassName;

    @ApiModelProperty("客户电话")
    private String clientPhone;

    @ApiModelProperty("客户头像")
    private String clientPhoto;

    @ApiModelProperty("客户地址")
    private String clientAddress;

    @ApiModelProperty("状态;拜访状态")
    private String visitStatus;

    @ApiModelProperty("状态;拜访状态")
    private String visitStatusName;

    @ApiModelProperty("异常提交时间")
    private String exceptionTime;

    @ApiModelProperty("异常描述")
    private String exceptionDetail;

    @ApiModelProperty("拜访小结")
    private String visitSummary;

    /**
     * 进店时间
     */
    @ApiModelProperty("进店时间")
    private String inStore;

    /**
     * 进店地址
     */
    @ApiModelProperty("进店地址")
    private String inStoreAddress;

    /**
     * 离店时间
     */
    @ApiModelProperty("离店时间")
    private String outStore;

    /**
     * 离店地址
     */
    @ApiModelProperty("离店地址")
    private String outStoreAddress;


    @ApiModelProperty("拜访汇总")
    private Map<String,String> visitDetailStep;
    @ApiModelProperty("拜访汇总表单配置")
    private SfaVisitStepFromRespVo sfaVisitStepFromAsSummary;




    @ApiModelProperty("拜访步骤列表")
    private List<? extends BaseVisitStepResp> step;

    /**
     * 协访主键id
     */
    @ApiModelProperty("协访主键id")
    private String helpDefenseId;

    /**
     * 被协访人员账号
     */
    @ApiModelProperty("被协访人员账号")
    private String coverHelpUserName;

    /**
     * 被协访人员姓名
     */
    @ApiModelProperty("被协访人员姓名")
    private String coverHelpRealName;

    /**
     * 被协访组织编码
     */
    @ApiModelProperty("被协访组织编码")
    private String coverHelpOrgCode;

    /**
     * 被协访组织名称
     */
    @ApiModelProperty("被协访组织名称")
    private String coverHelpOrgName;

    /**
     * 被协访职位编码
     */
    @ApiModelProperty("被协访职位编码")
    private String coverHelpPosCode;

    /**
     * 被协访职位名称
     */
    @ApiModelProperty("被协访职位名称")
    private String coverHelpPosName;


    /**
     * 计划拜访顺序
     */
    @ApiModelProperty("计划拜访顺序")
    private Integer visitSort;
//    @ApiModelProperty("拜访步骤列表")
//    private List<SfaVisitRoleDirectoryRespVo> roleDirectoryRespVos;


}
