package com.biz.crm.visitinfo.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.base.BusinessException;
import com.biz.crm.base.CrmAttachment;
import com.biz.crm.base.attachment.SfaAttachmentEntity;
import com.biz.crm.base.utils.SfaAttachmentUtil;
import com.biz.crm.collection.controller.resp.VisitStepResp;
import com.biz.crm.collection.service.ISfaVisitRoleDirectoryService;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.eunm.sfa.AttachmentBizTypeEnum;
import com.biz.crm.eunm.sfa.SfaCodeEnum;
import com.biz.crm.eunm.sfa.SfaVisitEnum;
import com.biz.crm.moblie.controller.visit.resp.SfaVisitExecuteResp;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.PageUtil;
import com.biz.crm.util.es.permission.EsDataPermission;
import com.biz.crm.visitinfo.mapper.SfaVisitInfoStepFormMapper;
import com.biz.crm.visitinfo.mapper.SfaVisitPlanInfoExecuteMapper;
import com.biz.crm.visitinfo.mapper.SfaVisitPlanInfoMapper;
import com.biz.crm.visitinfo.model.SfaVisitPlanInfoEntity;
import com.biz.crm.visitinfo.model.SfaVisitPlanInfoExecuteEntity;
import com.biz.crm.visitinfo.model.SfaVisitPlanInfoExecuteRedisData;
import com.biz.crm.visitinfo.model.SfaVisitPlanInfoRedisData;
import com.biz.crm.visitinfo.repositories.SfaVisitPlanInfoRedisDataRepositories;
import com.biz.crm.visitinfo.req.GetVisitReportsPageReq;
import com.biz.crm.visitinfo.resp.report.VisitInfoReportResp;
import com.biz.crm.visitinfo.service.ISfaVisitInfoStepFormService;
import com.biz.crm.visitinfo.service.ISfaVisitPlanInfoExecuteService;
import com.biz.crm.visitstep.req.GetVisitStepAbnormalReq;
import com.biz.crm.visitstep.resp.SfaVisitStepAbnormalTableRespVo;
import com.biz.crm.visitstep.resp.SfaVisitStepFromRespVo;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.index.query.QueryBuilder;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

import javax.annotation.Resource;
import java.util.*;
import java.util.stream.Collectors;


/**
 * 拜访计划;ES实现
 *
 * @author: luoqi
 * @Date: 2021-3-11 14:26
 * @version: V1.0
 * @Description:
 */
@Slf4j
@Service
@ConditionalOnMissingBean(name = "sfaVisitPlanInfoRedisDataServiceEsImplExtend")
public class SfaVisitPlanInfoRedisDataServiceEsImpl {

    @Resource
    private SfaVisitPlanInfoRedisDataRepositories sfaVisitPlanInfoRedisDataRepositories;
    @Resource
    private SfaVisitPlanInfoMapper sfaVisitPlanInfoMapper;
    @Resource
    private ISfaVisitPlanInfoExecuteService sfaVisitPlanInfoExecuteService;
    @Resource
    private SfaVisitPlanInfoExecuteMapper sfaVisitPlanInfoExecuteMapper;
    @Resource
    private ISfaVisitRoleDirectoryService sfaVisitRoleDirectoryService;
    @Resource
    private SfaVisitPlanInfoReportHelper sfaVisitPlanInfoReportHelper;
    @Resource
    private SfaVisitInfoStepFormMapper sfaVisitInfoStepFormMapper;


    public void save(SfaVisitPlanInfoRedisData data) {


        if (null == data || StringUtils.isBlank(data.getId())) {
            throw new BusinessException("拜访执行数据为空");
        }
        this.sfaVisitPlanInfoRedisDataRepositories.save(data);
    }

    /**
     * 拜访-查询拜访客户信息、步骤列表-拜访完成后
     *
     * @return
     */
    public SfaVisitExecuteResp getVisitStepsOfComplete(String visitInfoId) {

        //执行,返回包装结果的分页
        Optional<SfaVisitPlanInfoRedisData> pptional = this.sfaVisitPlanInfoRedisDataRepositories.findById(visitInfoId);
        if (pptional.isPresent()) {
            SfaVisitPlanInfoRedisData planInfoRedisData = pptional.get();
            SfaVisitExecuteResp reportVo = CrmBeanUtil.copy(planInfoRedisData.getSfaVisitPlanInfoExecuteRedisData(), SfaVisitExecuteResp.class);
            reportVo.setSteps(this.buildSteps(planInfoRedisData, true));

            return reportVo;
        }

        throw new BusinessException("未查询到该拜访计划执行数据");
    }

    /**
     * 拜访-查询拜访客户信息、步骤列表-拜访完成后
     *
     * @return
     */
    public SfaVisitPlanInfoExecuteRedisData getVisitExcuteInfo(String visitInfoId) {

        //执行,返回包装结果的分页
        Optional<SfaVisitPlanInfoRedisData> pptional = this.sfaVisitPlanInfoRedisDataRepositories.findById(visitInfoId);
        if (pptional.isPresent()) {
            SfaVisitPlanInfoRedisData planInfoRedisData = pptional.get();
            return planInfoRedisData.getSfaVisitPlanInfoExecuteRedisData();
        }

        throw new BusinessException("未查询到该拜访计划执行数据");
    }

    /**
     * 组装拜访详情
     *
     * @author: luoqi
     * @Date: 2021-3-21 14:31
     * @version: V1.0
     * @Description:
     */
    private VisitInfoReportResp buildVisitInfoReportResp(SfaVisitPlanInfoRedisData planInfoRedisData) {

        SfaVisitPlanInfoExecuteRedisData sfaVisitPlanInfoExecuteRedisData = planInfoRedisData.getSfaVisitPlanInfoExecuteRedisData();

        VisitInfoReportResp reportVo = CrmBeanUtil.copy(sfaVisitPlanInfoExecuteRedisData, VisitInfoReportResp.class);
        reportVo.setVisitStatus(planInfoRedisData.getVisitStatus());
        reportVo.setVisitStatusName(planInfoRedisData.getVisitStatusName());
        CrmBeanUtil.copyPropertiesIgnoreEmpty(planInfoRedisData, reportVo);
        reportVo.setVisitDetailStep(sfaVisitPlanInfoExecuteRedisData.getVisitDetailStep());
        reportVo.setStep(this.buildSteps(planInfoRedisData, false));
        return reportVo;
    }


    private List<VisitStepResp> buildSteps(SfaVisitPlanInfoRedisData planInfoRedisData, boolean summary) {
        List<VisitStepResp> stepTemp = planInfoRedisData.getStep();
        SfaVisitPlanInfoExecuteRedisData sfaVisitPlanInfoExecuteRedisData = planInfoRedisData.getSfaVisitPlanInfoExecuteRedisData();
        List<VisitStepResp> steps = Lists.newArrayList();
        VisitStepResp inStep = this.buildInStore(sfaVisitPlanInfoExecuteRedisData);
        VisitStepResp outStep = this.buildOutStore(sfaVisitPlanInfoExecuteRedisData);
        if (null != inStep) {
            //进店
            steps.add(inStep);
        }
        //业务步骤
        if (null != stepTemp) {
            for (VisitStepResp stepResp : stepTemp) {
                if (!summary && SfaCodeEnum.VisitStepCode.SFA_STEP_CODE_SUMMARY.getVal().equals(stepResp.getStepCode())) {
                    continue;
                }
                VisitStepResp temp = VisitStepResp.build(stepResp);
                if (SfaCodeEnum.VisitStepCode.SFA_STEP_CODE_SUMMARY.getVal().equals(stepResp.getStepCode())) {
                    VisitStepResp.SummaryData summaryData = new VisitStepResp.SummaryData();
                    summaryData.setSfaVisitStepFrom(sfaVisitPlanInfoExecuteRedisData.getSfaVisitStepFromAsSummary());
                    summaryData.setVisitDetailStep(sfaVisitPlanInfoExecuteRedisData.getVisitDetailStep());
                    summaryData.setVisitSummary(sfaVisitPlanInfoExecuteRedisData.getVisitSummary());
                    temp.setData(summaryData);
                }

                steps.add(temp);
            }
        }

        if (null != outStep) {
            //离店
            steps.add(outStep);
        }
        return steps;
    }

    /**
     * 进店
     *
     * @param sfaVisitPlanInfoExecuteRedisData
     * @return
     */
    private VisitStepResp buildInStore(SfaVisitPlanInfoExecuteRedisData sfaVisitPlanInfoExecuteRedisData) {
        if (YesNoEnum.yesNoEnum.YES.getValue().equals(sfaVisitPlanInfoExecuteRedisData.getNeedInStoreStep())) {
            //执行步骤
            VisitStepResp.InOutData inData = new VisitStepResp.InOutData();
            CrmBeanUtil.copyExt10(sfaVisitPlanInfoExecuteRedisData, inData);
            SfaVisitStepFromRespVo sfaVisitStepFromAsInStore = sfaVisitPlanInfoExecuteRedisData.getSfaVisitStepFromAsInStore();
            inData.setSfaVisitStepFrom(sfaVisitStepFromAsInStore);
            inData.setStoreAddress(sfaVisitPlanInfoExecuteRedisData.getInStoreAddress());
            inData.setStoreDateTime(sfaVisitPlanInfoExecuteRedisData.getInStore());
            inData.setStoreLatitude(sfaVisitPlanInfoExecuteRedisData.getInStoreLatitude());
            inData.setStoreLongitude(sfaVisitPlanInfoExecuteRedisData.getInStoreLongitude());
            inData.setStorePics(sfaVisitPlanInfoExecuteRedisData.getVisitInPics());
            VisitStepResp inStep = VisitStepResp.build(SfaVisitEnum.visitStep.VISIT_STEP_IN_STORE.getDesc(), SfaVisitEnum.visitStep.VISIT_STEP_IN_STORE.getVal(), null, inData);
            inStep.setIsSuccess(SfaVisitEnum.isSuccess.ALREADY_SUCCESS.getVal());
            inStep.setIsSuccessDesc(SfaVisitEnum.isSuccess.ALREADY_SUCCESS.getDesc());
            if (null != sfaVisitStepFromAsInStore) {
                inStep.setIcon(sfaVisitStepFromAsInStore.getIcon());
            }
            return inStep;
        }
        return null;
    }

    /**
     * 离店
     *
     * @param sfaVisitPlanInfoExecuteRedisData
     * @return
     */
    private VisitStepResp buildOutStore(SfaVisitPlanInfoExecuteRedisData sfaVisitPlanInfoExecuteRedisData) {
        if (YesNoEnum.yesNoEnum.YES.getValue().equals(sfaVisitPlanInfoExecuteRedisData.getNeedOutStoreStep())) {
            //执行步骤
            VisitStepResp.InOutData outData = new VisitStepResp.InOutData();
            CrmBeanUtil.copyExt10(sfaVisitPlanInfoExecuteRedisData, outData);
            SfaVisitStepFromRespVo sfaVisitStepFromAsOutStore = sfaVisitPlanInfoExecuteRedisData.getSfaVisitStepFromAsOutStore();
            outData.setSfaVisitStepFrom(sfaVisitStepFromAsOutStore);
            outData.setStoreAddress(sfaVisitPlanInfoExecuteRedisData.getOutStoreAddress());
            outData.setStoreDateTime(sfaVisitPlanInfoExecuteRedisData.getOutStore());
            outData.setStoreLatitude(sfaVisitPlanInfoExecuteRedisData.getOutStoreLatitude());
            outData.setStoreLongitude(sfaVisitPlanInfoExecuteRedisData.getOutStoreLongitude());
            outData.setStorePics(sfaVisitPlanInfoExecuteRedisData.getVisitOutPics());
            VisitStepResp outStep = VisitStepResp.build(SfaVisitEnum.visitStep.VISIT_STEP_OUT_STORE.getDesc(), SfaVisitEnum.visitStep.VISIT_STEP_OUT_STORE.getVal(), null, outData);
            outStep.setIsSuccess(SfaVisitEnum.isSuccess.ALREADY_SUCCESS.getVal());
            outStep.setIsSuccessDesc(SfaVisitEnum.isSuccess.ALREADY_SUCCESS.getDesc());
            if (null != sfaVisitStepFromAsOutStore) {
                outStep.setIcon(sfaVisitStepFromAsOutStore.getIcon());
            }
            return outStep;
        }
        return null;
    }

    /**
     * 拜访明细报表
     *
     * @param req
     * @return
     */
    public PageResult<VisitInfoReportResp> getVisitExecuteInfoReportPage(GetVisitReportsPageReq req) {
        Page<VisitInfoReportResp> page = PageUtil.buildPage(req.getPageNum(), req.getPageSize());
        //判断参数是否为协访
        if (req.getVisitBigType().equals(SfaVisitEnum.VisitBigType.HELP_VISIT.getVal())){
            req.setVisitStatus(SfaVisitEnum.HelpVisitStatus.ALREADY_SUCCESS.getVal());
        }else {
            req.setVisitStatus(SfaVisitEnum.visitStatus.V3.getVal());
        }
        List<VisitInfoReportResp> list = this.sfaVisitPlanInfoExecuteMapper.findList(page, req);
        if (CollectionUtil.listNotEmptyNotSizeZero(list)) {
            list.forEach(o -> {
                SfaVisitPlanInfoRedisData data = CrmBeanUtil.copy(o, SfaVisitPlanInfoRedisData.class);

                //进离店照片
                SfaVisitPlanInfoExecuteRedisData sfaVisitPlanInfoExecuteRedisData = CrmBeanUtil.copy(o, SfaVisitPlanInfoExecuteRedisData.class);
                sfaVisitPlanInfoExecuteRedisData.setVisitInPics(CrmBeanUtil.copyList(SfaAttachmentUtil.getList(AttachmentBizTypeEnum.VISIT_STEP_IN_STORE.getVal(),
                        o.getId()), CrmAttachment.class));
                sfaVisitPlanInfoExecuteRedisData.setVisitOutPics(CrmBeanUtil.copyList(SfaAttachmentUtil.getList(AttachmentBizTypeEnum.VISIT_STEP_OUT_STORE.getVal(),
                        o.getId()), CrmAttachment.class));

                data.setSfaVisitPlanInfoExecuteRedisData(sfaVisitPlanInfoExecuteRedisData);
                List<VisitStepResp> visitStepRespList = sfaVisitInfoStepFormMapper.findVisitPlanInfoStepForm(o.getId());
                o.setStep(visitStepRespList);
                data.setStep(visitStepRespList);
                sfaVisitPlanInfoReportHelper.buildVisitInfoReport(data, o);
            });
        }
        return PageResult.<VisitInfoReportResp>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    /**
     * 查询扩展
     *
     * @param req
     * @return
     */
    protected List<QueryBuilder> getVisitExecuteInfoReportPageQueryBuilderExtend(GetVisitReportsPageReq req) {
        return null;
    }


//    /**
//     * 批量修改拜访状态
//     * @param ids
//     * @param status
//     */
//    public void updateVisitStatusByIds(List<String> ids, SfaVisitEnum.visitStatus status){
//
//        if(CollectionUtils.isEmpty(ids) || null == status){
//            return ;
//        }
//
//        List<SfaVisitPlanInfoRedisData> dbData = this.findByIds(ids);
//        if(CollectionUtils.isEmpty(dbData)){
//            throw new BusinessException("未查询到拜访计划明细");
//        }
//        dbData.forEach(v -> v.setVisitStatus(status.getVal()));
//        this.sfaVisitPlanInfoRedisDataRepositories.saveAll(dbData);
//    }
//
//    /**
//     * 查询id列表
//     * @param ids
//     * @return
//     */
//    public List<SfaVisitPlanInfoRedisData> findByIds(List<String> ids){
//        if(CollectionUtils.isEmpty(ids)){
//            return Lists.newArrayList();
//        }
//        NativeSearchQueryBuilder nativeSearchQueryBuilder = new NativeSearchQueryBuilder();
//        //将搜索条件设置到构建中
//        nativeSearchQueryBuilder.withQuery(QueryBuilders.termsQuery("id", ids.toArray(new String[ids.size()])));
//        //执行,返回包装结果的分页
//        Iterable<SfaVisitPlanInfoRedisData> list = this.sfaVisitPlanInfoRedisDataRepositories.search(nativeSearchQueryBuilder.build());
//        return Lists.newArrayList(list);
//    }

//
//    /**
//     * 删除指定 redisHash 下的所有数据
//     * @return
//     */
//    public void deleteByVisitUserNameAndVisitPosCodeAndAndVisitDate(String visitUserName, String visitPosCode, String visitDate){
//        if(StringUtils.isBlank(visitUserName) || StringUtils.isBlank(visitPosCode) || StringUtils.isBlank(visitDate)){
//            return;
//        }
//        this.sfaVisitPlanInfoEntityRepositories.deleteByVisitUserNameAndVisitPosCodeAndAndVisitDate(visitUserName, visitPosCode, visitDate);
//    }
//
//    public List<SfaVisitPlanInfoEntity>  findByVisitUserNameAndVisitPosCodeAndAndVisitDate(String visitUserName, String visitPosCode, String visitDate){
//        if(StringUtils.isBlank(visitUserName) || StringUtils.isBlank(visitPosCode) || StringUtils.isBlank(visitDate)){
//            return Lists.newArrayList();
//        }
//        return this.sfaVisitPlanInfoEntityRepositories.findByVisitUserNameAndVisitPosCodeAndAndVisitDate(visitUserName, visitPosCode, visitDate);
//    }

    /**
     * 异常提报报表
     *
     * @param req
     * @return
     */
//    @EsDataPermission(userName = "visitUserName.keyword", position = "visitPosCode.keyword", org = "visitOrgCode.keyword", customer = "clientCode.keyword")
    public PageResult<SfaVisitStepAbnormalTableRespVo> getVisitExecuteInfoReportPage(GetVisitStepAbnormalReq req) {

//        //执行,返回包装结果的分页
//        org.springframework.data.domain.Page<SfaVisitPlanInfoRedisData> list = this.sfaVisitPlanInfoRedisDataRepositories.search(req.buildQuery(this.getExtQueryBuilders(req)));
//
//        List<SfaVisitStepAbnormalTableRespVo> sfaVisitStepAbnormalTableRespVos = Lists.newArrayList();
//        for (SfaVisitPlanInfoRedisData planInfoRedisData : list) {
//            SfaVisitStepAbnormalTableRespVo copy = CrmBeanUtil.copy(planInfoRedisData, SfaVisitStepAbnormalTableRespVo.class);
//            if (!ObjectUtils.isEmpty(copy)){
//                copy.setExceptionTime(planInfoRedisData.getSfaVisitPlanInfoExecuteRedisData().getExceptionTime());
//                copy.setExceptionDetail(planInfoRedisData.getSfaVisitPlanInfoExecuteRedisData().getExceptionDetail());
//                copy.setVisitExceptionPics(planInfoRedisData.getSfaVisitPlanInfoExecuteRedisData().getVisitExceptionPics());
//            }
//            CrmBeanUtil.copyExt10(planInfoRedisData.getSfaVisitPlanInfoExecuteRedisData(), copy);
//            sfaVisitStepAbnormalTableRespVos.add(copy);
//        }

        Page<SfaVisitStepAbnormalTableRespVo> page = PageUtil.buildPage(req.getPageNum(), req.getPageSize());
        List<SfaVisitStepAbnormalTableRespVo> list = this.sfaVisitPlanInfoMapper.findAbnormalList(page, req);
        if (CollectionUtil.listNotEmptyNotSizeZero(list)) {
            List<String> idList = list.stream().map(SfaVisitStepAbnormalTableRespVo::getBizId).collect(Collectors.toList());
            list.forEach(v -> {
                Map<String, List<SfaAttachmentEntity>> pics = SfaAttachmentUtil.getList(AttachmentBizTypeEnum.VISIT_PLAN_EX, idList)
                        .stream().collect(Collectors.groupingBy(SfaAttachmentEntity::getBizId));
                if (!ObjectUtils.isEmpty(pics)) {
                    List<SfaAttachmentEntity> attachmentEntities = pics.get(v.getBizId());
                    v.setVisitExceptionPics(CrmBeanUtil.copyList(attachmentEntities, CrmAttachment.class));
                }
            });
        }

        return PageResult.<SfaVisitStepAbnormalTableRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }


    /**
     * 查询扩展
     *
     * @param req
     * @return
     */
    protected List<QueryBuilder> getExtQueryBuilders(GetVisitStepAbnormalReq req) {
        return null;
    }
}
