package com.biz.crm.visitinfo.service.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.base.BusinessException;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.sfa.SfaVisitEnum;
import com.biz.crm.nebular.sfa.visitinfo.resp.SfaVisitPlanInfoRespVo;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.es.permission.EsDataPermission;
import com.biz.crm.visitinfo.mapper.SfaVisitPlanInfoMapper;
import com.biz.crm.visitinfo.model.SfaVisitPlanInfoEntity;
import com.biz.crm.visitinfo.repositories.SfaVisitPlanInfoEntityRepositories;
import com.biz.crm.visitinfo.req.GetVisitReportsPageReq;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import javax.annotation.Resource;
import java.util.Collection;
import java.util.List;
import java.util.Optional;


/**
 * 拜访计划;ES实现
 *  @author: luoqi
 *  @Date: 2021-3-11 14:26
 *  @version: V1.0
 *  @Description:
 */
@Slf4j
@Service
public class SfaVisitPlanInfoServiceEsImpl {

    @Resource
    private SfaVisitPlanInfoEntityRepositories sfaVisitPlanInfoEntityRepositories;
    @Resource
    private SfaVisitPlanInfoMapper sfaVisitPlanInfoMapper;


    /**
     * 拜访计划明细
     * @param visitPosCode
     * @return
     */
    public List<SfaVisitPlanInfoEntity> findByVisitPosCodeAndVisitDateAndVisitBigType(String visitPosCode, String visitDate, String visitBigType, Sort sort){
        if(StringUtils.isBlank(visitBigType)){
            throw new BusinessException("请指定拜访大类");
        }
        if(StringUtils.isBlank(visitPosCode)){
            throw new BusinessException("请指定用户职位编码");
        }
        if(StringUtils.isBlank(visitDate)){
            throw new BusinessException("请指定日期");
        }
        if(null == sort){
            sort = Sort.by("visitSort").ascending();
        }
        Iterable<SfaVisitPlanInfoEntity> list = this.sfaVisitPlanInfoEntityRepositories
                .findByVisitPosCodeAndVisitDateAndVisitBigType(visitPosCode, visitDate, visitBigType, sort);
        return Lists.newArrayList(list);
    }
    /**
     * 拜访计划明细报表
     * @param req
     * @return
     */
//    @EsDataPermission(userName = "visitUserName.keyword", position = "visitPosCode.keyword", org = "visitOrgCode.keyword", customer = "clientCode.keyword")
    public PageResult<SfaVisitPlanInfoRespVo> getVisitPlanInfoReportPage(GetVisitReportsPageReq req){
        Page<SfaVisitPlanInfoRespVo> page = new Page<>(req.getPageNum(),req.getPageSize());
        //2021-12-16 修改（只查询拜访计划数据）
        req.setVisitType(SfaVisitEnum.visitType.PLAN_VISIT.getVal());
        //执行,返回包装结果的分页
//        org.springframework.data.domain.Page<SfaVisitPlanInfoEntity> list = this.sfaVisitPlanInfoEntityRepositories.search(req.buildQuery(this.getVisitPlanInfoReportPageQueryBuilderExtend(req)));
        List<SfaVisitPlanInfoRespVo> list = sfaVisitPlanInfoMapper.findVisitPlanInfoReport(page,req);
        return PageResult.<SfaVisitPlanInfoRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }
    /**
     * 查询扩展
     * @param req
     * @return
     */
    protected List<QueryBuilder> getVisitPlanInfoReportPageQueryBuilderExtend(GetVisitReportsPageReq req){
        return null;
    }

    public void saveAll(Collection<SfaVisitPlanInfoEntity> entities){
        if(CollectionUtils.isEmpty(entities)){
            return;
        }
        this.sfaVisitPlanInfoEntityRepositories.saveAll(entities);
        this.sfaVisitPlanInfoEntityRepositories.refresh();
    }
    public void save(SfaVisitPlanInfoEntity entity){
        if(null == entity){
            return;
        }
        this.sfaVisitPlanInfoEntityRepositories.save(entity);
    }


    /**
     * 查询id列表
     * @param ids
     * @return
     */
    public List<SfaVisitPlanInfoEntity> findByIds(List<String> ids){
        if(CollectionUtils.isEmpty(ids)){
            return Lists.newArrayList();
        }
        BoolQueryBuilder builder = QueryBuilders.boolQuery();
        builder.must(QueryBuilders.termsQuery("id", ids.toArray(new String[ids.size()])));
        //执行,返回包装结果的分页
        Iterable<SfaVisitPlanInfoEntity> list = this.sfaVisitPlanInfoEntityRepositories.search(builder);
        return Lists.newArrayList(list);
    }
    /**
     * 查询id列表
     * @param id
     * @return
     */
    public SfaVisitPlanInfoEntity findById(String id){
        if(StringUtils.isBlank(id)){
            throw new BusinessException("请指定拜访计划ID");
        }
        //执行,返回包装结果的分页
        Optional<SfaVisitPlanInfoEntity> optional = this.sfaVisitPlanInfoEntityRepositories.findById(id);
        if(optional.isPresent()){
            return optional.get();
        }
        return null;
    }
    /**
     * 删除id列表
     * @param ids
     * @return
     */
    public void deleteByIds(List<String> ids){
        if(CollectionUtils.isEmpty(ids)){
            return;
        }
        this.sfaVisitPlanInfoEntityRepositories.deleteByIdIn(ids);
        this.sfaVisitPlanInfoEntityRepositories.refresh();
    }



    public List<SfaVisitPlanInfoEntity>  findByVisitPlanCode(String visitPlanCode){
        if(StringUtils.isBlank(visitPlanCode) ){
            return Lists.newArrayList();
        }
        return this.sfaVisitPlanInfoEntityRepositories.findByVisitPlanCode( visitPlanCode);
    }



    public List<SfaVisitPlanInfoEntity> findByVisitPosCodeAndVisitDateAndVisitBigType(String visitPosCode, String visitDate, String visitBigType){
        if(StringUtils.isBlank(visitPosCode) || StringUtils.isBlank(visitDate) || StringUtils.isBlank(visitBigType)){
            return Lists.newArrayList();
        }
        return this.sfaVisitPlanInfoEntityRepositories.findByVisitPosCodeAndVisitDateAndVisitBigType(visitPosCode, visitDate, visitBigType);
    }

    public void delete(List<SfaVisitPlanInfoEntity> planInfos){
        if(org.springframework.util.CollectionUtils.isEmpty(planInfos)){
            return;
        }
        this.sfaVisitPlanInfoEntityRepositories.deleteAll(planInfos);
        this.sfaVisitPlanInfoEntityRepositories.refresh();
//        this.sfaVisitPlanInfoEntityRepositories.deleteByRedisHashKeyIn(Lists.newArrayList(redisHashKeys));
    }
}
