package com.biz.crm.visitinfo.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.achievement.mapper.SfaAchievementAccomplishRecordMapper;
import com.biz.crm.base.ApiResultUtil;
import com.biz.crm.base.BusinessException;
import com.biz.crm.base.attachment.SfaAttachmentEntity;
import com.biz.crm.base.utils.SfaAttachmentUtil;
import com.biz.crm.collection.controller.resp.VisitStepResp;
import com.biz.crm.collection.service.ISfaVisitRoleDirectoryService;
import com.biz.crm.common.param.ParameterParam;
import com.biz.crm.common.param.RedisParam;
import com.biz.crm.config.CrmDictMethod;
import com.biz.crm.config.SpringApplicationContextUtil;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.mdm.LoginFromTypeEnum;
import com.biz.crm.eunm.sfa.AttachmentBizTypeEnum;
import com.biz.crm.eunm.sfa.SfaCodeEnum;
import com.biz.crm.eunm.sfa.SfaVisitEnum;
import com.biz.crm.mdm.position.MdmPositionFeign;
import com.biz.crm.moblie.controller.visit.component.AbstractVisitInfoPlanListener;
import com.biz.crm.moblie.controller.visit.component.AbstractVisitStepRedisExecutor;
import com.biz.crm.moblie.controller.visit.req.GetVisitListReq;
import com.biz.crm.moblie.controller.visit.req.step.ExecutorLoadReq;
import com.biz.crm.moblie.controller.visit.resp.SfaVisitResp;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgRespVo;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionRespVo;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionUserOrgRespVo;
import com.biz.crm.nebular.sfa.achievement.resp.SfaAchievementTimeTotalRespVo;
import com.biz.crm.nebular.sfa.visitinfo.req.SfaVisitPlanInfoReqVo;
import com.biz.crm.nebular.sfa.visitinfo.resp.*;
import com.biz.crm.service.RedisService;
import com.biz.crm.util.*;
import com.biz.crm.visitinfo.mapper.SfaVisitPlanInfoMapper;
import com.biz.crm.visitinfo.model.SfaVisitPlanInfoEntity;
import com.biz.crm.visitinfo.model.SfaVisitPlanInfoExecuteEntity;
import com.biz.crm.visitinfo.model.SfaVisitPlanInfoExecuteRedisData;
import com.biz.crm.visitinfo.model.SfaVisitPlanInfoRedisData;
import com.biz.crm.visitinfo.req.VisitAndSalesReq;
import com.biz.crm.visitinfo.service.ISfaVisitInfoStepFormService;
import com.biz.crm.visitinfo.service.ISfaVisitPlanInfoExecuteService;
import com.biz.crm.visitinfo.service.ISfaVisitPlanInfoService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 拜访计划;接口实现
 *
 * @author Xiao
 * @date 2020-09-30 10:26:35
 */
@Slf4j
@Service
@ConditionalOnMissingBean(name = "SfaVisitPlanInfoServiceExpandImpl")
@Transactional
public class SfaVisitPlanInfoServiceImpl<M extends BaseMapper<T>, T> extends ServiceImpl<SfaVisitPlanInfoMapper, SfaVisitPlanInfoEntity> implements ISfaVisitPlanInfoService {

    @Resource
    private SfaVisitPlanInfoMapper sfaVisitPlanInfoMapper;
    @Resource
    private MdmPositionFeign mdmPositionFeign;

    @Resource
    private RedisService redisService;

    @Resource
    private SfaVisitPlanInfoServiceEsImpl sfaVisitPlanInfoServiceEsImpl;
    @Resource
    private ISfaVisitRoleDirectoryService sfaVisitRoleDirectoryService;
    @Resource
    private SfaAchievementAccomplishRecordMapper achievementAccomplishRecordMapper;

    @Resource
    private ISfaVisitPlanInfoExecuteService sfaVisitPlanInfoExecuteService;

    @Resource
    private SfaVisitPlanInfoRedisDataServiceEsImpl sfaVisitPlanInfoRedisDataServiceEsImpl;

    @Resource
    private ISfaVisitInfoStepFormService sfaVisitInfoStepFormService;

    /**
     * 修改步骤状态
     *
     * @param visitPlanInfoId
     * @param visitStepCode
     */
    @Override
    public void updateStepStatus(String visitPlanInfoId, SfaCodeEnum.VisitStepCode visitStepCode) {
        UserRedis userRedis = UserUtils.getUser();
        GetVisitListReq req = new GetVisitListReq();
        req.setVisitUserName(userRedis.getUsername());
        req.setVisitPositionCode(userRedis.getPoscode());
        req.setVisitDate(LocalDate.now().format(CrmDateUtils.yyyyMMdd));
        req.setVisitBigType(SfaVisitEnum.VisitBigType.VISIT.getVal());

        Map<String, SfaVisitPlanInfoEntity> planInfoEntities = this.doGetVisitInfoList(req).stream().collect(Collectors.toMap(SfaVisitPlanInfoEntity::getId, v -> v, (t, t2) -> t2));
        SfaVisitPlanInfoEntity planInfoEntity = planInfoEntities.get(visitPlanInfoId);
        if (null == planInfoEntity) {
            req.setVisitBigType(SfaVisitEnum.VisitBigType.HELP_VISIT.getVal());
            planInfoEntities = this.doGetVisitInfoList(req).stream().collect(Collectors.toMap(SfaVisitPlanInfoEntity::getId, v -> v, (t, t2) -> t2));
            planInfoEntity = planInfoEntities.get(visitPlanInfoId);
        }
        if (null == planInfoEntity) {
            req.setVisitBigType(SfaVisitEnum.VisitBigType.UNFAMILIAR_VISIT.getVal());
            planInfoEntities = this.doGetVisitInfoList(req).stream().collect(Collectors.toMap(SfaVisitPlanInfoEntity::getId, v -> v, (t, t2) -> t2));
            planInfoEntity = planInfoEntities.get(visitPlanInfoId);
        }
        if (null == planInfoEntity) {
            return;
        }

        this.updateStepStatus(planInfoEntity.getRedisHashKey(), visitStepCode.getVal(), planInfoEntity.getVisitBigType());

    }

    /**
     * 更新步骤状态
     *
     * @author: luoqi
     * @Date: 2021-3-5 22:29
     * @version: V1.0
     * @Description:
     */
    @Override
    public void updateStepStatus(String redisHashKey, String stepCode, String visitBigType) {
        String nowDate = LocalDate.now().format(CrmDateUtils.yyyyMMdd);
        SfaVisitPlanInfoRedisData sfaVisitPlanInfoRedisData = (SfaVisitPlanInfoRedisData) this.redisService
                .hmget(SfaVisitPlanInfoRedisData.getInstance().redisHashCurrent(nowDate, visitBigType).toString(), redisHashKey);
        //步骤状态
        this.changeStepStatus(sfaVisitPlanInfoRedisData, stepCode);

        //保存到redis
        this.redisService.hmset(sfaVisitPlanInfoRedisData.redisHashCurrent(nowDate, visitBigType).toString()
                , sfaVisitPlanInfoRedisData.buildRedisDataForWrite(), SfaVisitPlanInfoEntity.CACHE_TIME);
    }

    /**
     * 修改步骤执行状态
     *
     * @param sfaVisitPlanInfoRedisData 拜访计划明细执行数据
     * @param stepCode                  步骤编码
     */
    @Override
    public void changeStepStatus(SfaVisitPlanInfoRedisData sfaVisitPlanInfoRedisData, String stepCode) {
        if (org.apache.commons.lang3.StringUtils.isBlank(stepCode)) {
            throw new BusinessException("步骤状态更新失败，请指定步骤类型");
        }
        List<VisitStepResp> steps = sfaVisitPlanInfoRedisData.getStep();
        if (null == steps) {
            return;
        }
        for (VisitStepResp step : steps) {
            if (stepCode.equals(step.getStepCode())) {
                step.setIsSuccess(SfaVisitEnum.isSuccess.ALREADY_SUCCESS.getVal());
                step.setIsSuccessDesc(SfaVisitEnum.isSuccess.ALREADY_SUCCESS.getDesc());
                break;
            }
        }
        sfaVisitInfoStepFormService.updateVisitStepStatus(stepCode, sfaVisitPlanInfoRedisData.getId());
    }

    /**
     * 查询用户指定日期的拜访列表
     *
     * @return
     */
    @Override
    @Transactional(readOnly = true)
    public SfaVisitResp getVisitInfoList(GetVisitListReq req) {

        List<SfaVisitPlanInfoEntity> planInfoEntities = this.visitInfoListOrderBy(this.doGetVisitInfoList(req));
        List<SfaVisitResp.SfaVisitPlanInfoResp> planInfoResp = this.convertPlanInfoData(planInfoEntities, req);
        SfaVisitResp sfaVisitResp = new SfaVisitResp();
        sfaVisitResp.setPlanInfoEntities(planInfoResp);
        //进行分页处理
        sfaVisitResp.setTotal(planInfoEntities.size());
        sfaVisitResp.setComplete(SfaVisitPlanInfoEntity.countingCompletedNum(planInfoEntities));
        return sfaVisitResp;

    }

    /**
     * 排序权重-制定计划时线路组的排序
     *
     * @return
     */
    protected int orderWeightOfVisitSort() {
        return 1;
    }

    /**
     * 排序权重-拜访中
     *
     * @return
     */
    protected int orderWeightOfVisitRunning() {
        return 20000;
    }

    /**
     * 排序权重-未拜访
     *
     * @return
     */
    protected int orderWeightOfVisitWait() {
        return 15000;
    }

    /**
     * 排序权重-已拜访
     *
     * @return
     */
    protected int orderWeightOfVisitComplete() {
        return 10000;
    }

    /**
     * 排序权重-异常
     *
     * @return
     */
    protected int orderWeightOfVisitEX() {
        return 5000;
    }

    /**
     * 拜访计划列表排序
     * 拜访中 > 未拜访 > 已拜访 > 异常
     *
     * @param planInfoEntities
     * @return
     */
    protected List<SfaVisitPlanInfoEntity> visitInfoListOrderBy(List<SfaVisitPlanInfoEntity> planInfoEntities) {
        //缓存每个计划所对应的权重分数
        Map<String, Integer> scoreMap = Maps.newHashMap();
        //缓存全部分数，避免出现相等的分数
        Set<Integer> scoreSet = Sets.newHashSet();
        List<SfaVisitPlanInfoEntity> temp = planInfoEntities.stream().sorted((o1, o2) -> {
            //标记是否使用的新计算分数，以保证该计划的分数不会被修改
            boolean newScore1 = false, newScore2 = false;
            //优先取缓存
            Integer score1 = scoreMap.get(o1.getId());
            Integer score2 = scoreMap.get(o2.getId());
            //只要有一个计划没有计算过分数，则重新计算
            if (null == score1 || null == score1) {
                //重新计算
                Integer[] tempScore = doScore(o1, o2);
                /**
                 * 没有计算过的才使用新分数，计算过的沿用之前的分数
                 */
                if (null == score1) {
                    score1 = tempScore[0];
                    newScore1 = true;
                }
                if (null == score2) {
                    score2 = tempScore[1];
                    newScore2 = true;
                }
            }
            //新计算分数才递增避重
            if (newScore1) {
                //保证无重复分数
                while (true) {
                    if (scoreSet.contains(score1)) {
                        score1 += 1;
                        continue;
                    }
                    scoreSet.add(score1);
                    break;
                }
            }

            //新计算分数才递增避重
            if (newScore2) {
                //保证无重复分数
                while (true) {
                    if (scoreSet.contains(score2)) {
                        score2 += 1;
                        continue;
                    }
                    scoreSet.add(score2);
                    break;
                }
            }

            scoreMap.put(o1.getId(), score1);
            scoreMap.put(o2.getId(), score2);
//            log.error(o1.getId() + ": " + score1 + " @@@ " + o2.getId() + ": " + score2);
            return score2.compareTo(score1);
        }).collect(Collectors.toList());
        return temp;
    }

    public static void main(String[] args) {
        StringBuilder sb = new StringBuilder();
        String str1 = "";

        sb.append(str1);
//        sb.append(str2);
//        sb.append(str3);
//        sb.append(str4);
//        sb.append(str5);
//        sb.append(str6);
//        sb.append(str7);
//        sb.append(str8);
//        sb.append(str9);
//        sb.append(str10);
//        sb.append(str11);
//        sb.append(str12);
//        sb.append(str13);
//        sb.append(str14);
//        sb.append(str15);
//        sb.append(str16);
//        sb.append(str17);
//        sb.append(str18);
//        sb.append(str19);
//        sb.append(str20);
//        sb.append(str21);
//        sb.append(str22);
//        sb.append(str23);
//        sb.append(str24);
//        sb.append(str25);

//        List<HashMap> list = JsonPropertyUtil.toArray(sb.toString(), HashMap.class);
//        List<Object> listObj = Lists.newArrayList();
//        for (HashMap hashMap : list) {
//            listObj.add(hashMap.get("_source"));
//        }

        List<SfaVisitPlanInfoEntity> temp = JsonPropertyUtil.toArray(sb.toString(), SfaVisitPlanInfoEntity.class);
        SfaVisitPlanInfoServiceImpl impl = new SfaVisitPlanInfoServiceImpl();
        temp = impl.visitInfoListOrderBy(temp);
        temp.size();
    }

    /**
     * 计算权重分数
     *
     * @param o1
     * @param o2
     * @return
     */
    protected Integer[] doScore(SfaVisitPlanInfoEntity o1, SfaVisitPlanInfoEntity o2) {
        //排序权重  制定计划时线路组的排序
        final Integer orderWeightOfVisitSort = this.orderWeightOfVisitSort();
        //排序权重-拜访中
        final Integer orderWeightOfVisitRunning = this.orderWeightOfVisitRunning();
        //排序权重-未拜访
        final Integer orderWeightOfVisitWait = this.orderWeightOfVisitWait();
        //排序权重-已拜访
        final Integer orderWeightOfVisitComplete = this.orderWeightOfVisitComplete();
        //排序权重-异常
        final Integer orderWeightOfVisitEX = this.orderWeightOfVisitEX();
        //权重得分
        Integer score1 = 0, score2 = 0;
        Integer visitSort1 = null == o1.getVisitSort() ? 0 : o1.getVisitSort();
        Integer visitSort2 = null == o2.getVisitSort() ? 0 : o2.getVisitSort();
        if (visitSort1 >= visitSort2) {
            score2 += orderWeightOfVisitSort;
        } else {
            score1 += orderWeightOfVisitSort;
        }
        //拜访类型
        if (SfaVisitEnum.VisitBigType.VISIT.getVal().equals(o1.getVisitBigType())) {
            if (SfaVisitEnum.visitStatus.V2.getVal().equals(o1.getVisitStatus())) {
                score1 += orderWeightOfVisitRunning;
            }
            if (SfaVisitEnum.visitStatus.V2.getVal().equals(o2.getVisitStatus())) {
                score2 += orderWeightOfVisitRunning;
            }

            if (SfaVisitEnum.visitStatus.V1.getVal().equals(o1.getVisitStatus())) {
                score1 += orderWeightOfVisitWait;
            }
            if (SfaVisitEnum.visitStatus.V1.getVal().equals(o2.getVisitStatus())) {
                score2 += orderWeightOfVisitWait;
            }

            if (SfaVisitEnum.visitStatus.V3.getVal().equals(o1.getVisitStatus())) {
                score1 += orderWeightOfVisitComplete;
            }
            if (SfaVisitEnum.visitStatus.V3.getVal().equals(o2.getVisitStatus())) {
                score2 += orderWeightOfVisitComplete;
            }

            if (SfaVisitEnum.visitStatus.V4.getVal().equals(o1.getVisitStatus())) {
                score1 += orderWeightOfVisitEX;
            }
            if (SfaVisitEnum.visitStatus.V4.getVal().equals(o2.getVisitStatus())) {
                score2 += orderWeightOfVisitEX;
            }
        } else {//协访类型
            if (SfaVisitEnum.HelpVisitStatus.IN_HELP_DEFENSE.getVal().equals(o1.getVisitStatus())) {
                score1 += orderWeightOfVisitRunning;
            }
            if (SfaVisitEnum.HelpVisitStatus.IN_HELP_DEFENSE.getVal().equals(o2.getVisitStatus())) {
                score2 += orderWeightOfVisitRunning;
            }

            if (SfaVisitEnum.HelpVisitStatus.NO_COMMIT.getVal().equals(o1.getVisitStatus())) {
                score1 += orderWeightOfVisitWait;
            }
            if (SfaVisitEnum.HelpVisitStatus.NO_COMMIT.getVal().equals(o2.getVisitStatus())) {
                score2 += orderWeightOfVisitWait;
            }

            if (SfaVisitEnum.HelpVisitStatus.ALREADY_SUCCESS.getVal().equals(o1.getVisitStatus())) {
                score1 += orderWeightOfVisitComplete;
            }
            if (SfaVisitEnum.HelpVisitStatus.ALREADY_SUCCESS.getVal().equals(o2.getVisitStatus())) {
                score2 += orderWeightOfVisitComplete;
            }

            if (SfaVisitEnum.HelpVisitStatus.EX.getVal().equals(o1.getVisitStatus())) {
                score1 += orderWeightOfVisitEX;
            }
            if (SfaVisitEnum.HelpVisitStatus.EX.getVal().equals(o2.getVisitStatus())) {
                score2 += orderWeightOfVisitEX;
            }
        }
        return new Integer[]{score1, score2};
    }


    @Override
    @Transactional(readOnly = true)
    public List<SfaVisitPlanInfoEntity> doGetVisitInfoList(GetVisitListReq req) {
        if (org.apache.commons.lang3.StringUtils.isBlank(req.getVisitBigType())) {
            throw new BusinessException("请指定拜访大类");
        }
        if (org.apache.commons.lang3.StringUtils.isBlank(req.getVisitDate())) {
            throw new BusinessException("请选择拜访日期");
        }
        if (org.apache.commons.lang3.StringUtils.isBlank(req.getVisitUserName())) {
            throw new BusinessException("请选择拜访用户");
        }
        List<SfaVisitPlanInfoEntity> planInfoEntities;
        LocalDate date = LocalDate.parse(req.getVisitDate(), CrmDateUtils.yyyyMMdd);
        if (date.compareTo(LocalDate.now()) < 0) {
            planInfoEntities = this.loadVisitInfoListFromES(req);
        } else {
            planInfoEntities = this.loadVisitInfoListFromRedis(req);
        }
        if (null == planInfoEntities) {
            return Lists.newArrayList();
        }
        return planInfoEntities;

    }


    protected List<SfaVisitPlanInfoEntity> loadVisitInfoListFromRedis(GetVisitListReq req) {
        StringJoiner redisHash = SfaVisitPlanInfoEntity.getInstance().redisHash(req.getVisitDate(), req.getVisitUserName(), req.getVisitPositionCode(), req.getVisitBigType());
        List<SfaVisitPlanInfoEntity> planInfoEntities = (List<SfaVisitPlanInfoEntity>) this.redisService.hmValues(redisHash.toString());
        //如果redis获取失败了，则进行数据库补偿
        if(CollectionUtil.listEmpty(planInfoEntities)){
            planInfoEntities = this.lambdaQuery()
                    .eq(SfaVisitPlanInfoEntity::getVisitDate,req.getVisitDate())
                    .eq(SfaVisitPlanInfoEntity::getVisitUserName,req.getVisitUserName())
                    .eq(SfaVisitPlanInfoEntity::getVisitPosCode,req.getVisitPositionCode())
                    .eq(SfaVisitPlanInfoEntity::getVisitBigType,req.getVisitBigType())
                    .list();
        }
        return planInfoEntities;
    }

    protected List<SfaVisitPlanInfoEntity> loadVisitInfoListFromES(GetVisitListReq req) {
        List<SfaVisitPlanInfoEntity> planInfoEntities = this.sfaVisitPlanInfoServiceEsImpl.findByVisitPosCodeAndVisitDateAndVisitBigType(req.getVisitPositionCode(), req.getVisitDate(), req.getVisitBigType(), null);
        return planInfoEntities;
    }

    @Override
    @Transactional(readOnly = true)
    public List<SfaVisitPlanInfoEntity> getVisitInfoListByClientType(GetVisitListReq.MoreReq req) {
        List<SfaVisitPlanInfoEntity> planInfoEntities = this.doGetVisitInfoList(req);
        String clientType = req.getClientType();
        if (org.apache.commons.lang3.StringUtils.isBlank(clientType)) {
            return planInfoEntities;
        }
        String keyWord = req.getKeyWord();
        //按客户类型筛选
        return planInfoEntities.stream().filter(v -> {
            if (!clientType.equals(v.getClientType())) {
                return false;
            }
            //模糊筛选
            if (org.apache.commons.lang3.StringUtils.isNotBlank(keyWord)) {
                if (v.getClientCode().contains(keyWord)) {
                    return true;
                }
                if (v.getClientName().contains(keyWord)) {
                    return true;
                }
            }
            return true;
        }).collect(Collectors.toList());
    }

    /**
     * 转换数据
     *
     * @param planInfoEntities
     * @param req
     * @return
     */
    private List<SfaVisitResp.SfaVisitPlanInfoResp> convertPlanInfoData(List<SfaVisitPlanInfoEntity> planInfoEntities, GetVisitListReq req) {

        List<SfaVisitResp.SfaVisitPlanInfoResp> planInfoResp = CrmBeanUtil.copyList(planInfoEntities, SfaVisitResp.SfaVisitPlanInfoResp.class);

        Map<String, String> cusType = DictUtil.getDictValueMapsByCodes(SfaVisitEnum.ClientType.DICT_CODE);
        Map<String, Map<String, VisitStepResp>> stepRespMap = null;
        List<String> clientTypes = Lists.newArrayList(planInfoEntities.stream().map(SfaVisitPlanInfoEntity::getClientType).collect(Collectors.toSet()));
        List<String> clientSubclassList = Lists.newArrayList(planInfoEntities.stream().map(SfaVisitPlanInfoEntity::getClientSubclass).collect(Collectors.toSet()));
        if (planInfoResp.size() > 0) {
            SfaVisitPlanInfoEntity temp = planInfoEntities.get(0);
            stepRespMap = sfaVisitRoleDirectoryService.findRoleVisitStepMapForClientTypes(temp.getVisitUserName(), temp.getVisitPosCode()
                    , clientTypes, req.getVisitBigType(), clientSubclassList);
        }

        for (SfaVisitResp.SfaVisitPlanInfoResp data : planInfoResp) {
            data.setClientTypeName(cusType.get(data.getClientType()));
            if (null != data.getDistance()) {
                data.setDistance(data.getDistance().divide(new BigDecimal(1000)).setScale(2, BigDecimal.ROUND_DOWN));
            }
            Map<String, String> buttons;
            String visitUserName = data.getVisitUserName(), visitDate = data.getVisitDate();
            if (SfaVisitEnum.VisitBigType.VISIT.getVal().equals(data.getVisitBigType())) {
                buttons = SfaVisitEnum.visitButton.buildVisitButton(visitUserName, visitDate, data.getVisitStatus());
            } else if (SfaVisitEnum.VisitBigType.HELP_VISIT.getVal().equals(data.getVisitBigType())) {
                buttons = SfaVisitEnum.visitButton.buildHelpVisitButton(visitUserName, visitDate, data.getVisitStatus());
            } else {
                buttons = SfaVisitEnum.visitButton.buildVisitUnfamiliarButton(visitUserName, visitDate, data.getVisitStatus());
            }

            data.setButtons(buttons);
            data.buildFormId(stepRespMap);
        }
        return planInfoResp;
    }


    /**
     * 查询
     *
     * @param reqVo
     * @return sfaVisitPlanInfoRespVo
     */
    @Override
    public SfaVisitPlanInfoRespVo query(SfaVisitPlanInfoReqVo reqVo) {
        SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity = this.getById(reqVo.getId());
        return CrmBeanUtil.copy(sfaVisitPlanInfoEntity, SfaVisitPlanInfoRespVo.class);
    }


    /**
     * 新增临时拜访计划
     *
     * @param infoEntities
     * @return
     */
    @Override
    public String checkAddForTempPlan(List<SfaVisitPlanInfoEntity> infoEntities) {
        String redisHash = this.doCheckAddForTempPlan(infoEntities);

        List<SfaVisitPlanInfoEntity> dbData = (List<SfaVisitPlanInfoEntity>) this.redisService.hmValues(redisHash);
        if (null == dbData) {
            dbData = Lists.newArrayList();
        }
        Map<String, SfaVisitPlanInfoEntity> objectObjectMap = dbData.stream().collect(Collectors.toMap(SfaVisitPlanInfoEntity::getRedisHashKey, v -> v, (t, t2) -> t2));

//        Map<String, SfaVisitPlanInfoEntity> objectObjectMap =
        StringJoiner msg = new StringJoiner(",");
        for (SfaVisitPlanInfoEntity infoEntity : infoEntities) {
            if (objectObjectMap.containsKey(infoEntity.getRedisHashKey())) {
                msg.add(infoEntity.getClientName());
            }
            objectObjectMap.put(infoEntity.getRedisHashKey(), infoEntity);
        }
        if (msg.length() > 0) {
            throw new BusinessException("已存在[" + msg.toString() + "]的拜访计划");
        }
        return redisHash;
    }

    @Override
    public String checkForTempPlan(List<SfaVisitPlanInfoEntity> infoEntities) {
        String redisHash = this.doCheckAddForTempPlan(infoEntities);
        return redisHash;
    }

    /**
     * 拜访数据持久化
     *
     * @param sfaVisitPlanInfoEntity
     * @param sfaVisitPlanInfoRedisData
     */
    @Override
    public void dataDurability(SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity, SfaVisitPlanInfoRedisData sfaVisitPlanInfoRedisData) {
        this.saveOrUpdate(sfaVisitPlanInfoEntity, sfaVisitPlanInfoRedisData);
        //进离店、异常图片
        SfaAttachmentUtil.insert(this.buildAttachmentList(sfaVisitPlanInfoEntity, sfaVisitPlanInfoRedisData));
        //没有执行数据
        if (null == sfaVisitPlanInfoRedisData) {
            //推送es
            this.sfaVisitPlanInfoServiceEsImpl.save(sfaVisitPlanInfoEntity);
            return;
        }
        List<VisitStepResp> step = sfaVisitPlanInfoRedisData.getStep();
        //步骤数据持久化
        this.stepDurability(sfaVisitPlanInfoEntity, step);
        //推送es
        this.sfaVisitPlanInfoServiceEsImpl.save(sfaVisitPlanInfoEntity);
        this.sfaVisitPlanInfoRedisDataServiceEsImpl.save(sfaVisitPlanInfoRedisData);
        this.doListener(sfaVisitPlanInfoEntity, sfaVisitPlanInfoRedisData);
    }

    private List<SfaAttachmentEntity> buildAttachmentList(SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity, SfaVisitPlanInfoRedisData sfaVisitPlanInfoRedisData) {
        if (null == sfaVisitPlanInfoRedisData) {
            return null;
        }
        SfaVisitPlanInfoExecuteRedisData sfaVisitPlanInfoExecuteRedisData = sfaVisitPlanInfoRedisData.getSfaVisitPlanInfoExecuteRedisData();
        if (null == sfaVisitPlanInfoExecuteRedisData) {
            return null;
        }

        List<SfaAttachmentEntity> attachmentEntities = SfaAttachmentUtil.build(sfaVisitPlanInfoExecuteRedisData.getVisitExceptionPics()
                , AttachmentBizTypeEnum.VISIT_PLAN_EX, sfaVisitPlanInfoEntity.getId());
        attachmentEntities.addAll(SfaAttachmentUtil.build(sfaVisitPlanInfoExecuteRedisData.getVisitInPics()
                , AttachmentBizTypeEnum.VISIT_STEP_IN_STORE, sfaVisitPlanInfoEntity.getId()));
        attachmentEntities.addAll(SfaAttachmentUtil.build(sfaVisitPlanInfoExecuteRedisData.getVisitOutPics()
                , AttachmentBizTypeEnum.VISIT_STEP_OUT_STORE, sfaVisitPlanInfoEntity.getId()));
        return attachmentEntities;
    }

    /**
     * 调用监听器
     *
     * @param sfaVisitPlanInfoEntity
     */
    private void doListener(SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity, SfaVisitPlanInfoRedisData sfaVisitPlanInfoRedisData) {
        List<AbstractVisitInfoPlanListener> listeners = AbstractVisitInfoPlanListener.getListeners(sfaVisitPlanInfoEntity.getVisitBigType());

        for (AbstractVisitInfoPlanListener listener : listeners) {
            if (null == listener) {
                continue;
            }
            listener.doListenerEvent(sfaVisitPlanInfoEntity, sfaVisitPlanInfoRedisData);
        }
    }


    /**
     * 步骤数据持久化
     *
     * @param sfaVisitPlanInfoEntity
     * @param step
     */
    private void stepDurability(SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity, List<VisitStepResp> step) {
        if (null == step) {
            return;
        }
        ExecutorLoadReq loadReq = new ExecutorLoadReq();
        loadReq.setVisitInfoId(sfaVisitPlanInfoEntity.getId());
        loadReq.setRedisHashKey(sfaVisitPlanInfoEntity.getRedisHashKey());
        for (VisitStepResp stepResp : step) {
            if (SfaVisitEnum.visitStep.VISIT_STEP_IN_STORE.getVal().equals(stepResp.getPageCode())
                    || SfaVisitEnum.visitStep.VISIT_STEP_OUT_STORE.getVal().equals(stepResp.getPageCode())) {
                if (log.isInfoEnabled()) {
                    log.info("离店打卡数据传输至ES:忽略进/离店执行器");
                }
                continue;
            }
            //TODO tpm活动除外，不再这个限制里
            if (!stepResp.getPageCode().equals(SfaVisitEnum.visitStep.VISIT_STEP_TPM.getVal())) {
                Class<? extends AbstractVisitStepRedisExecutor> clazz = AbstractVisitStepRedisExecutor.VISIT_STEP_EXECUTOR_CLASS_MAPPING.get(stepResp.getPageCode());
                if (null == clazz) {
                    throw new BusinessException("未获取到拜访步骤[" + stepResp.getPageCode() + "]的执行器类信息！");
                }
                AbstractVisitStepRedisExecutor visitStepExecutor = SpringApplicationContextUtil.getApplicationContext().getBean(clazz);
                if (null == visitStepExecutor) {
                    throw new BusinessException("未获取到拜访步骤[" + stepResp.getPageCode() + "]的执行器实例！");
                }
                loadReq.setFormId(stepResp.getFormId());
                loadReq.setStepCode(stepResp.getStepCode());
                visitStepExecutor.dataDurability(loadReq, sfaVisitPlanInfoEntity);
            }
        }
    }

    /**
     * 更新
     *
     * @param sfaVisitPlanInfoEntity
     * @param sfaVisitPlanInfoRedisData
     * @return
     */
    @Override
    public void saveOrUpdate(SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity, SfaVisitPlanInfoRedisData sfaVisitPlanInfoRedisData) {
        this.saveOrUpdate(sfaVisitPlanInfoEntity);
        if (null == sfaVisitPlanInfoRedisData) {
            return;
        }
        SfaVisitPlanInfoExecuteRedisData redisData = sfaVisitPlanInfoRedisData.getSfaVisitPlanInfoExecuteRedisData();
        //拜访明细执行数据保存 重新关联数据信息
        redisData.setVisitPlanInfoId(sfaVisitPlanInfoEntity.getId());
        redisData.setVisitPlanCode(sfaVisitPlanInfoEntity.getVisitPlanCode());
        this.sfaVisitPlanInfoExecuteService.saveOrUpdate(redisData);
    }


    /**
     * 更新
     *
     * @param reqVo
     * @return
     */
    @CrmDictMethod
    @Deprecated
    @Override
    public void update(SfaVisitPlanInfoReqVo reqVo) {
        SfaVisitPlanInfoEntity entity = this.getById(reqVo.getId());
        this.updateById(entity);
    }

    /**
     * 删除拜访计划明细
     *
     * @param ids
     * @return
     */
    @Override
    public void deleteBatch(List<String> ids) {
        List<SfaVisitPlanInfoEntity> sfaVisitPlanInfoEntities = this.deleteBatchCheck(ids);
        Map<String, List<SfaVisitPlanInfoEntity>> temp = Maps.newHashMap();
        for (SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity : sfaVisitPlanInfoEntities) {
            String redisHash = sfaVisitPlanInfoEntity.redisHash().toString();
            List<SfaVisitPlanInfoEntity> list = temp.get(redisHash);
            if (null == list) {
                list = Lists.newArrayList();
            }
            list.add(sfaVisitPlanInfoEntity);
            temp.put(redisHash, list);
        }

        temp.forEach((redisHash, infoEntities) -> {
            List<String> redisHashKeys = infoEntities.stream().map(SfaVisitPlanInfoEntity::getRedisHashKey).collect(Collectors.toList());
            String[] redisHashKey = redisHashKeys.toArray(new String[redisHashKeys.size()]);
            this.redisService.hdel(redisHash, redisHashKey);
        });
        this.removeByIds(ids);
        sfaVisitPlanInfoServiceEsImpl.deleteByIds(sfaVisitPlanInfoEntities.stream().map(SfaVisitPlanInfoEntity::getId).collect(Collectors.toList()));
    }

    private List<SfaVisitPlanInfoEntity> deleteBatchCheck(List<String> ids) {
        boolean forWebTemp = false;
        if (LoginFromTypeEnum.CONSOLE.getValue().equals(UserUtils.getUser().getFromtype())) {
            forWebTemp = true;
        }
        boolean forWeb = forWebTemp;
        if (!CollectionUtil.listNotEmptyNotSizeZero(ids)) {
            throw new BusinessException("数据主键不存在！");
        }
        List<SfaVisitPlanInfoEntity> sfaVisitPlanInfoEntities = sfaVisitPlanInfoServiceEsImpl.findByIds(ids);
        if (org.springframework.util.CollectionUtils.isEmpty(sfaVisitPlanInfoEntities)) {
            throw new BusinessException("未查询到拜访计划数据");
        }
        LocalDate nowDate = LocalDate.now();
        sfaVisitPlanInfoEntities.forEach(plan -> {
            LocalDate visitDate = LocalDate.parse(plan.getVisitDate(), CrmDateUtils.yyyyMMdd);
            if (nowDate.compareTo(visitDate) > 0) {
                throw new BusinessException("不可删除历史拜访计划");
            }
            if (!SfaVisitEnum.visitStatus.V1.getVal().equals(plan.getVisitStatus())) {
                throw new BusinessException("只能删除未拜访的计划");
            }
            //再次确认redis缓存里的数据状态
            SfaVisitPlanInfoEntity redisData = (SfaVisitPlanInfoEntity) this.redisService.hmget(plan.redisHash().toString(), plan.getRedisHashKey());
            if (null != redisData && !SfaVisitEnum.visitStatus.V1.getVal().equals(plan.getVisitStatus())) {
                throw new BusinessException("只能删除未拜访的计划");
            }
            if (!forWeb) {
                if (!SfaVisitEnum.visitType.TEMP_VISIT.getVal().equals(plan.getVisitType()) && nowDate.compareTo(visitDate) == 0) {
                    throw new BusinessException("不能在移动端删除当天的非临时拜访计划");
                }
            }


        });
        return sfaVisitPlanInfoEntities;
    }

    /**
     * 启用
     *
     * @param ids
     * @return
     */
    @CrmDictMethod
    @Deprecated
    @Override
    public void enableBatch(List<String> ids) {
        if (!CollectionUtil.listNotEmptyNotSizeZero(ids)) {
            throw new BusinessException("数据主键不存在！");
        }
        //设置状态为启用
        List<SfaVisitPlanInfoEntity> sfaVisitPlanInfoEntities = sfaVisitPlanInfoMapper.selectBatchIds(ids);
        if (CollectionUtils.isNotEmpty(sfaVisitPlanInfoEntities)) {
            sfaVisitPlanInfoEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
            });
        }
        this.updateBatchById(sfaVisitPlanInfoEntities);
    }

    /**
     * 禁用
     *
     * @param ids
     * @return
     */
    @CrmDictMethod
    @Deprecated
    @Override
    public void disableBatch(List<String> ids) {
        if (!CollectionUtil.listNotEmptyNotSizeZero(ids)) {
            throw new BusinessException("数据主键不存在！");
        }
        //设置状态为禁用
        List<SfaVisitPlanInfoEntity> sfaVisitPlanInfoEntities = sfaVisitPlanInfoMapper.selectBatchIds(ids);
        if (CollectionUtils.isNotEmpty(sfaVisitPlanInfoEntities)) {
            sfaVisitPlanInfoEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode());
            });
        }
        this.updateBatchById(sfaVisitPlanInfoEntities);
    }


    /**
     * 校验参数信息
     *
     * @param infoEntities
     */
    private String doCheckAddForTempPlan(List<SfaVisitPlanInfoEntity> infoEntities) {
//        AssertUtils.isNotEmpty(reqVo.getClientId(), "请选择客户信息");
//        AssertUtils.isNotEmpty(reqVo.getClientCode(), "请选择客户信息");
//        AssertUtils.isNotEmpty(reqVo.getClientName(), "请选择客户信息");
//        AssertUtils.isNotEmpty(reqVo.getClientType(), "请选择客户信息");
//        AssertUtils.isNotEmpty(reqVo.getClientAddress(), "选择客户信息不存在地址");
//        try {
//            SfaVisitPlanResolver.futureDaysCheck(LocalDate.parse(reqVo.getVisitDate(), CrmDateUtils.yyyyMMdd));
//        } catch (BusinessException e) {
//            throw e;
//        } catch (Exception e) {
//            throw new BusinessException("拜访日期格式错误", e);
//        }
        if (org.springframework.util.CollectionUtils.isEmpty(infoEntities)) {
            throw new BusinessException("没有可添加的临时计划");
        }
        StringJoiner joiner = new StringJoiner(RedisParam.DELIMITER);
        joiner.add(RedisParam.SFA_VISIT).add(SfaVisitPlanInfoEntity.TABLE_NAME).add(infoEntities.get(0).getVisitUserName())
                .add(infoEntities.get(0).getVisitPosCode()).add(infoEntities.get(0).getVisitDate());
        MdmOrgRespVo mdmOrgRespVo = OrgUtil.getOrgByCode(infoEntities.get(0).getVisitOrgCode());
        for (SfaVisitPlanInfoEntity infoEntity : infoEntities) {
            if (null != mdmOrgRespVo) {
                infoEntity.setParentOrgCode(mdmOrgRespVo.getParentCode());
                infoEntity.setParentOrgName(mdmOrgRespVo.getParentName());
            }


        }
        return infoEntities.get(0).redisHash().toString();
    }


    /**
     * 拜访与销售走势图
     *
     * @return
     */
    @Override
    public List<SfaVisitAndSalesTrendChartRespVo> findVisiAndSalesTrendChart(VisitAndSalesReq req) {
        String posCode = UserUtils.getUser().getPoscode();
        if (StringUtils.isNotEmpty(req.getUserName())) {
            MdmPositionRespVo mdmPositionRespVo = ApiResultUtil.objResult(mdmPositionFeign.getPrimaryPositionByUserName(req.getUserName()), true);
            if (ObjectUtils.isEmpty(mdmPositionRespVo)) {
                throw new BusinessException("未获取到相关人员职位信息");
            }
            posCode = mdmPositionRespVo.getPositionCode();
        }
        String monthsStr = ParamUtil.getParameterValue(ParameterParam.VISI_SALES_MONTHS);
        Integer months = ParameterParam.VISI_SALES_MONTHS_DEFAULT_VALUE;
        if (StringUtils.isNotEmpty(monthsStr)) {
            months = Integer.valueOf(monthsStr);
        }
        List<String> monthsList = new ArrayList<>();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        monthsList.add(DateUtil.yyyy_MM.format(calendar.getTime()));
        for (int i = 1; i < months; i++) {
            calendar.add(Calendar.MONTH, -1);
            monthsList.add(DateUtil.yyyy_MM.format(calendar.getTime()));
        }
        //查询对应的拜访次数
        List<SfaAchievementTimeTotalRespVo> accomplishVisitNum = achievementAccomplishRecordMapper.findAccomplishNumByYm(posCode,
                SfaVisitEnum.indexType.WDBF.getCode(), monthsList);
        List<SfaVisitAndSalesTrendChartRespVo> visitList = accomplishVisitNum.stream()
                .map(a -> new SfaVisitAndSalesTrendChartRespVo(a.getTimeOfPeriod(), new BigDecimal(a.getAccomplishNum()), new BigDecimal(0)))
                .collect(Collectors.toList());
        Map<String, BigDecimal> visitMap = visitList.stream().collect(Collectors.toMap(SfaVisitAndSalesTrendChartRespVo::getYearMonth, SfaVisitAndSalesTrendChartRespVo::getVisitNumber));
        //查询对应的销售下单次数
        List<SfaAchievementTimeTotalRespVo> accomplishOrderNum = achievementAccomplishRecordMapper.findAccomplishNumByYm(posCode,
                SfaVisitEnum.indexType.XD.getCode(), monthsList);
        List<SfaVisitAndSalesTrendChartRespVo> salesList = accomplishOrderNum.stream()
                .map(a -> new SfaVisitAndSalesTrendChartRespVo(a.getTimeOfPeriod(), new BigDecimal(0), new BigDecimal(a.getAccomplishNum())))
                .collect(Collectors.toList());
        Map<String, BigDecimal> salesMap = salesList.stream().collect(Collectors.toMap(SfaVisitAndSalesTrendChartRespVo::getYearMonth, SfaVisitAndSalesTrendChartRespVo::getSalesNumber));

        List<SfaVisitAndSalesTrendChartRespVo> voList = new ArrayList<>();
        Collections.sort(monthsList, new Comparator<String>() {
            @Override
            public int compare(String o1, String o2) {
                Integer m1 = Integer.valueOf(o1.split("-")[0]) * 100 + Integer.valueOf(o1.split("-")[1]);
                Integer m2 = Integer.valueOf(o2.split("-")[0]) * 100 + Integer.valueOf(o2.split("-")[1]);
                return Integer.compare(m1, m2);
            }
        });
        String[] CN_CHARS = new String[]{"", "一", "二", "三", "四", "五", "六", "七", "八", "九", "十", "十一", "十二"};
        for (String monthsx : monthsList) {
            SfaVisitAndSalesTrendChartRespVo vo = new SfaVisitAndSalesTrendChartRespVo();
            vo.setYearMonth(monthsx);
            Integer month = Integer.valueOf(monthsx.split("-")[1]);
            vo.setMonthDes(CN_CHARS[month] + "月");
            if (visitMap.containsKey(monthsx)) {
                vo.setVisitNumber(visitMap.get(monthsx));
            }
            if (salesMap.containsKey(monthsx)) {
                vo.setSalesNumber(salesMap.get(monthsx));
            }
            voList.add(vo);
        }
        return voList;
    }

    /**
     * 近段时间拜访排行
     *
     * @return
     */
    @Override
    public SfaVisitRankingRespVo findVisitRankingList() {
        UserRedis userRedis = UserUtils.getUser();
        String daysStr = ParamUtil.getParameterValue(ParameterParam.VISIT_RANKING_CYCLE);
        Integer days = ParameterParam.VISIT_RANKING_CYCLE_DEFAULT_VALUE;
        if (StringUtils.isNotEmpty(daysStr)) {
            days = Integer.valueOf(daysStr);
        }
        SfaVisitRankingRespVo respVo = new SfaVisitRankingRespVo();
        respVo.setDays(days);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        //结算日期
        String endDate = DateUtil.date_sdf.format(calendar.getTime());
        calendar.add(Calendar.DATE, -1 * (days - 1));
        String startDate = DateUtil.date_sdf.format(calendar.getTime());
        //获取当前职位对应的下级职位
        List<MdmPositionRespVo> positionRespVoList = PositionUtil.getChildrenPositionListExcludeSelf(userRedis.getPoscode());
        List<String> posCodeList = new ArrayList<>();
        for (MdmPositionRespVo positionResp : positionRespVoList) {
            posCodeList.add(positionResp.getPositionCode());
        }
        if (!CollectionUtil.listNotEmptyNotSizeZero(posCodeList)) {
            return respVo;
        }
        List<MdmPositionUserOrgRespVo> positionUserList = mdmPositionFeign.detailBatchByPositionCodeList(posCodeList).getResult();
        List<String> positionCodeList = new ArrayList<>();
        Map<String, MdmPositionUserOrgRespVo> positionUserMap = new HashMap<>();
        for (MdmPositionUserOrgRespVo positionUser : positionUserList) {
            positionCodeList.add(positionUser.getPositionCode());
            positionUserMap.put(positionUser.getPositionCode(), positionUser);
        }
        if (!CollectionUtil.listNotEmptyNotSizeZero(positionCodeList)) {
            return respVo;
        }
        //查询时间段内拜访数
        List<SfaAchievementTimeTotalRespVo> accomplishNum = achievementAccomplishRecordMapper.findPosCodeListAccomplishNum(positionCodeList, SfaVisitEnum.indexType.WDBF.getCode(), startDate, endDate);
        List<SfaVisitRankingDetailedRespVo> respVoList = accomplishNum.stream().map(a -> new SfaVisitRankingDetailedRespVo(a.getPosCode(), new BigDecimal(a.getAccomplishNum()))).collect(Collectors.toList());
        List<SfaVisitRankingDetailedRespVo> detailedList = new ArrayList<>();
        String topfewStr = ParamUtil.getParameterValue(ParameterParam.VISIT_RANKING_TOPFEW);
        Integer topfew = ParameterParam.VISIT_RANKING_TOPFEW_DEFAULT_VALUE;
        if (StringUtils.isNotEmpty(topfewStr)) {
            topfew = Integer.valueOf(topfewStr);
        }
        for (int i = 0; i < topfew && i < respVoList.size(); i++) {
            SfaVisitRankingDetailedRespVo detailedRespVo = respVoList.get(i);
            MdmPositionUserOrgRespVo positionUser = positionUserMap.get(detailedRespVo.getPoscode());
            detailedRespVo.setPosname(positionUser.getPositionName());
            detailedRespVo.setUsername(positionUser.getUserName());
            detailedRespVo.setRealname(positionUser.getFullName());
            detailedList.add(detailedRespVo);
        }
        respVo.setDetailedList(detailedList);
        return respVo;
    }

    /**
     * 解析拜访明细数据执行数据关联
     */
    @Override
    public void updateVisitPlanInfo() {
        List<SfaVisitPlanInfoStepFormRespVo> respVos = sfaVisitPlanInfoMapper.findVisitPlanInfoRelExecution();
        respVos.forEach(data -> {
            sfaVisitPlanInfoExecuteService.lambdaUpdate()
                    .eq(SfaVisitPlanInfoExecuteEntity::getId, data.getId())
                    .set(SfaVisitPlanInfoExecuteEntity::getVisitPlanInfoId, data.getVisitPlanInfoId())
                    .update();
        });
    }
}
