package com.biz.crm.visitinfo.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.biz.crm.base.BusinessException;
import com.biz.crm.nebular.sfa.visitinfo.req.SfaVisitStepProcessReqVo;
import com.biz.crm.nebular.sfa.visitinfo.resp.SfaVisitStepProgressRespVo;
import com.biz.crm.visitinfo.model.SfaVisitPlanInfoEntity;
import com.biz.crm.visitinfo.service.ISfaVisitPlanInfoService;
import com.biz.crm.visitinfo.service.ISfaVisitStepProcessService;
import com.biz.crm.visitstep.model.SfaVisitStepInoutEntity;
import com.biz.crm.visitstep.service.ISfaVisitStepInoutService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;

@Slf4j
@Service
@ConditionalOnMissingBean(name = "sfaVisitStepProcessServiceExpandImpl")
public class SfaVisitStepProcessServiceImpl implements ISfaVisitStepProcessService {

    @Resource
    private ISfaVisitPlanInfoService iSfaVisitPlanInfoService;

    @Resource
    private ISfaVisitStepInoutService iSfaVisitStepInoutService;

    @Override
    public SfaVisitStepProgressRespVo visitStepProgress(SfaVisitStepProcessReqVo vo) {
        SfaVisitStepProgressRespVo stepProcess = new SfaVisitStepProgressRespVo();

        //查询拜访计划
        QueryWrapper<SfaVisitPlanInfoEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("id", vo.getVisitId());
        SfaVisitPlanInfoEntity visitPlan = iSfaVisitPlanInfoService.getOne(queryWrapper);
        if (visitPlan == null) {
            throw new BusinessException("无效的拜访计划id");
        }

        //查询进店信息
        QueryWrapper<SfaVisitStepInoutEntity> stepInoutQuery = new QueryWrapper<>();
        stepInoutQuery.eq("visit_id", visitPlan.getId());
        SfaVisitStepInoutEntity inOut = iSfaVisitStepInoutService.getOne(stepInoutQuery);
        if (inOut == null) {
            throw new BusinessException("请先进店打卡");
        }
        stepProcess.setInTime(inOut.getInTime());
        stepProcess.setInAddress(inOut.getInAddress());

        //TODO 按照后台配置的菜单来查询
        //查询陈列执行完成状态
        //查询库存盘点完成状态
        //查询订单采集完成状态
        //查询活动执行完成状态
        //查询竞品采集完成状态
        //查询拜访总结完成状态

        return stepProcess;
    }
}
