package com.biz.crm.visitinfo.stepformcomponent;

import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.eunm.sfa.SfaVisitEnum;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.StringUtils;
import com.biz.crm.visitinfo.model.SfaVisitInfoStepFormEntity;
import com.biz.crm.visitinfo.service.ISfaVisitInfoStepFormService;
import com.biz.crm.visitstep.model.SfaVisitStepFromEntity;
import com.biz.crm.visitstep.service.ISfaVisitStepFromService;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.List;

/**
 * @author lf
 * @describe
 * @project crm
 * @package com.biz.crm.visitinfo.stepformcomponent
 * @date 2021/7/20 18:54
 */
@Component
public class SfaStepFormBaseComponent {

    @Resource
    private ISfaVisitStepFromService sfaVisitStepFromService;
    @Resource
    private ISfaVisitInfoStepFormService sfaVisitInfoStepFormService;


    /**
     * 通过id或者名称查询表单
     *
     * @param id
     * @param formName
     * @return
     */
    public String getVisitStepForm(String id, String formName) {
        List<SfaVisitStepFromEntity> formEntityList = this.sfaVisitStepFromService.lambdaQuery()
                .eq(StringUtils.isNotEmpty(id), SfaVisitStepFromEntity::getId, id)
                .eq(StringUtils.isNotEmpty(formName), SfaVisitStepFromEntity::getFromName, formName)
                .select(SfaVisitStepFromEntity::getId)
                .list();
        if (CollectionUtil.listNotEmptyNotSizeZero(formEntityList)) {
            return formEntityList.get(0).getId();
        }
        return null;
    }

    /**
     * 保存解析的拜访步骤 是否必做默认为否
     *
     * @param formId
     * @param stepCode
     * @param success
     * @param visitPlanInfoId
     * @param visitPlanInfoCode
     */
    public void saveSfaVisitStepForm(String formId, String stepCode, String success, String visitPlanInfoId, String visitPlanInfoCode,Integer sort) {
        SfaVisitInfoStepFormEntity stepFormEntity = new SfaVisitInfoStepFormEntity();
        stepFormEntity.setFormId(formId);
        stepFormEntity.setVisitPlanInfoId(visitPlanInfoId);
        stepFormEntity.setVisitPlanCode(visitPlanInfoCode);
        stepFormEntity.setStepCode(stepCode);
        stepFormEntity.setIsSuccess(success);
        stepFormEntity.setIsSuccessDesc(SfaVisitEnum.isSuccess.GETMAP.get(success));
        stepFormEntity.setDoNot(YesNoEnum.yesNoEnum.no.getValue());
        stepFormEntity.setDoNotDesc(YesNoEnum.yesNoEnum.no.getDes());
        if (sort!=null){
            stepFormEntity.setSortNum(sort);
        }
        sfaVisitInfoStepFormService.save(stepFormEntity);
    }
}
