package com.biz.crm.visitinfo.stepformcomponent.stepcomponent;

import com.biz.crm.eunm.sfa.SfaVisitEnum;
import com.biz.crm.moblie.visitoffline.SfaVisitStepConstant;
import com.biz.crm.nebular.sfa.visitinfo.resp.SfaVisitPlanInfoStepFormRespVo;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.StringUtils;
import com.biz.crm.visitinfo.stepformcomponent.SfaStepFormBaseComponent;
import com.biz.crm.visitinfo.stepformcomponent.VisitPlanInfoStepFormStrategy;
import com.biz.crm.visitstep.model.SfaVisitStepColletEntity;
import com.biz.crm.visitstep.service.ISfaVisitStepColletService;
import com.biz.crm.visitstepdetail.model.SfaVisitStepStockInventoryEntity;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.List;

/**
 * @author lf
 * @describe
 * @project crm
 * @package com.biz.crm.visitinfo.stepformcomponent.stepcomponent
 * @date 2021/7/20 21:52
 */
@Component(SfaVisitStepConstant.SFA_STEP_CODE_COMPETITOR + SfaVisitStepConstant.STEP_FORM_BEAN)
@Slf4j
public class CompetitorStepFormComponent implements VisitPlanInfoStepFormStrategy {

    private static String STEP_CODE;

    private static String STEP_SUCCESS;

    private static String STEP_NAME;

    private static String FORM_ID;

    private static Integer SORT;

    @Resource
    private SfaStepFormBaseComponent sfaStepFormBaseComponent;
    @Resource
    private ISfaVisitStepColletService sfaVisitStepColletService;

    @Override
    public void resolvingVisitPlanInfoStepForm(SfaVisitPlanInfoStepFormRespVo respVo) {
        String formId = FORM_ID;
        if (StringUtils.isEmpty(formId)) {
            //判断是执行了的步骤数据
            if (SfaVisitEnum.isSuccess.ALREADY_SUCCESS.getVal().equals(STEP_SUCCESS)) {
                List<SfaVisitStepColletEntity> collectEntityList = sfaVisitStepColletService.lambdaQuery()
                        .eq(SfaVisitStepColletEntity::getVisitPlanInfoId, respVo.getVisitPlanInfoId())
                        .eq(SfaVisitStepColletEntity::getStepCode, STEP_CODE)
                        .select(SfaVisitStepColletEntity::getId, SfaVisitStepColletEntity::getFormId)
                        .list();
                if (CollectionUtil.listNotEmptyNotSizeZero(collectEntityList)) {
                    formId = sfaStepFormBaseComponent.getVisitStepForm(collectEntityList.get(0).getFormId(), STEP_NAME);
                } else {
                    formId = sfaStepFormBaseComponent.getVisitStepForm(null, STEP_NAME);
                }
            } else {
                formId = sfaStepFormBaseComponent.getVisitStepForm(null, STEP_NAME);
            }
        }
        if (StringUtils.isNotEmpty(formId)) {
            sfaStepFormBaseComponent.saveSfaVisitStepForm(formId, STEP_CODE, STEP_SUCCESS, respVo.getVisitPlanInfoId(), respVo.getVisitPlanCode(),SORT);
        }
    }

    @Override
    public void setStepCode(String stepCode) {
        STEP_CODE = stepCode;
    }

    @Override
    public void setStepSuccess(String stepSuccess) {
        STEP_SUCCESS = stepSuccess;
    }

    @Override
    public void setStepName(String stepName) {
        STEP_NAME = stepName;
    }

    @Override
    public void setFormId(String formId) {
        FORM_ID = formId;
    }

    @Override
    public void setSort(Integer sort) {
        SORT = sort;
    }
}
