package com.biz.crm.visitinfo.stepformcomponent.stepcomponent;

import com.biz.crm.eunm.sfa.SfaVisitEnum;
import com.biz.crm.moblie.visitoffline.SfaVisitStepConstant;
import com.biz.crm.nebular.sfa.visitinfo.resp.SfaVisitPlanInfoStepFormRespVo;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.StringUtils;
import com.biz.crm.visitinfo.stepformcomponent.SfaStepFormBaseComponent;
import com.biz.crm.visitinfo.stepformcomponent.VisitPlanInfoStepFormStrategy;
import com.biz.crm.visitstep.model.SfaVisitStepStoreCheckEntity;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.List;

/**
 * @author lf
 * @describe
 * @project crm
 * @package com.biz.crm.visitinfo.stepformcomponent.stepcomponent
 * @date 2021/7/27 23:50
 */
@Component(SfaVisitStepConstant.SFA_STEP_CODE_SUMMARY + SfaVisitStepConstant.STEP_FORM_BEAN)
@Slf4j
public class SummaryStepFormComponent implements VisitPlanInfoStepFormStrategy {

    private static String STEP_CODE;

    private static String STEP_SUCCESS;

    private static String STEP_NAME;

    private static String FORM_ID;

    private static Integer SORT;

    @Resource
    private SfaStepFormBaseComponent sfaStepFormBaseComponent;

    @Override
    public void resolvingVisitPlanInfoStepForm(SfaVisitPlanInfoStepFormRespVo respVo) {
        String formId = FORM_ID;
        if (StringUtils.isEmpty(formId)) {
            formId = sfaStepFormBaseComponent.getVisitStepForm(null, STEP_NAME);
        }
        if (StringUtils.isNotEmpty(formId)) {
            sfaStepFormBaseComponent.saveSfaVisitStepForm(formId, STEP_CODE, STEP_SUCCESS, respVo.getVisitPlanInfoId(), respVo.getVisitPlanCode(), SORT);
        }
    }

    @Override
    public void setStepCode(String stepCode) {
        STEP_CODE = stepCode;
    }

    @Override
    public void setStepSuccess(String stepSuccess) {
        STEP_SUCCESS = stepSuccess;
    }

    @Override
    public void setStepName(String stepName) {
        STEP_NAME = stepName;
    }

    @Override
    public void setFormId(String formId) {
        FORM_ID = formId;
    }

    @Override
    public void setSort(Integer sort) {
        SORT = sort;
    }
}
