package com.biz.crm.visitnote.controller;

import com.biz.crm.aop.CrmAPIDiscard;
import com.biz.crm.aop.CrmLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.sfa.SfaVisitEnum;
import com.biz.crm.nebular.sfa.visitnote.req.SfaVisitAssitPlanReqVo;
import com.biz.crm.nebular.sfa.visitnote.resp.SfaVisitAssitPlanRespVo;
import com.biz.crm.util.Result;
import com.biz.crm.visitnote.service.ISfaVisitAssitPlanService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 协防计划制定
 *
 * @author liuhongming
 * @date 2020-09-21 14:35:05
 */
@Slf4j
@RestController
@RequestMapping("/sfavisitassitplan")
@Api(tags = "协防计划制定 ")
public class SfaVisitAssitPlanController {
    @Autowired
    private ISfaVisitAssitPlanService sfaVisitPlanService;

    /**
     * 列表
     */
    @ApiOperation(value = "查询列表")
    @PostMapping("/list")
    @CrmLog
    @CrmAPIDiscard
    public Result<PageResult<SfaVisitAssitPlanRespVo>> list(@RequestBody SfaVisitAssitPlanReqVo sfaVisitPlanReqVo) {
        PageResult<SfaVisitAssitPlanRespVo> result=sfaVisitPlanService.findList(sfaVisitPlanReqVo);
        return Result.ok(result);
    }

    /**
     * 查询
     */
    @ApiOperation(value = "查询")
    @PostMapping("/query")
    @CrmLog
    @CrmAPIDiscard
    public Result<SfaVisitAssitPlanRespVo> query(@RequestBody SfaVisitAssitPlanReqVo sfaVisitPlanReqVo) {
        SfaVisitAssitPlanRespVo respVo=sfaVisitPlanService.query(sfaVisitPlanReqVo);
        return Result.ok(respVo);
    }

    /**
     * 新增
     */
    @ApiOperation(value = "新增")
    @PostMapping("/save")
    @CrmLog
    @CrmAPIDiscard
    public Result save(@RequestBody SfaVisitAssitPlanReqVo sfaVisitPlanReqVo) {
        sfaVisitPlanService.save(sfaVisitPlanReqVo);
        return Result.ok();
    }

    /**
     * 更新
     */
    @ApiOperation(value = "更新")
    @PostMapping("/update")
    @CrmLog
    @CrmAPIDiscard
    public Result update(@RequestBody SfaVisitAssitPlanReqVo sfaVisitPlanReqVo) {
        sfaVisitPlanService.update(sfaVisitPlanReqVo);
        return Result.ok("修改成功");
    }

    /**
     * 删除
     */
    @ApiOperation(value = "删除")
    @PostMapping("/delete")
    @CrmLog
    @CrmAPIDiscard
    public Result delete(@RequestBody SfaVisitAssitPlanReqVo sfaVisitPlanReqVo) {
        sfaVisitPlanService.deleteBatch(sfaVisitPlanReqVo);
        return Result.ok("删除成功");
    }

    /**
     * 启用
     */
    @ApiOperation(value = "启用")
    @PostMapping("/enable")
    @CrmLog
    @CrmAPIDiscard
    public Result enable(@RequestBody SfaVisitAssitPlanReqVo sfaVisitPlanReqVo) {
        sfaVisitPlanService.enableBatch(sfaVisitPlanReqVo);
        return Result.ok("启用成功");
    }

    /**
     * 禁用
     */
    @ApiOperation(value = "禁用")
    @PostMapping("/disable")
    @CrmLog
    @CrmAPIDiscard
    public Result disable(@RequestBody  SfaVisitAssitPlanReqVo sfaVisitPlanReqVo) {
        sfaVisitPlanService.disableBatch(sfaVisitPlanReqVo);
        return Result.ok("禁用成功");
    }
}
