package com.biz.crm.visitnote.controller;

import com.biz.crm.aop.CrmLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.config.CrmDictMethod;
import com.biz.crm.nebular.sfa.visitnote.req.SfaVisitGroupReqVo;
import com.biz.crm.nebular.sfa.visitnote.resp.SfaVisitGroupRespVo;
import com.biz.crm.util.Result;
import com.biz.crm.visitnote.service.ISfaVisitGroupService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 线路组管理 
 *
 * @author liuhongming
 * @date 2020-09-18 16:53:00
 */
@Slf4j
@RestController
@RequestMapping("/sfaVisitGroupController")
@Api(tags = "线路组管理 ")
public class SfaVisitGroupController {
    @Autowired
    private ISfaVisitGroupService sfaVisitGroupService;

    /**
     * 列表
     */
    @ApiOperation(value = "查询列表")
    @PostMapping("/list")
    @CrmLog
    public Result<PageResult<SfaVisitGroupRespVo>> list(@RequestBody SfaVisitGroupReqVo sfaVisitGroupReqVo) {
        PageResult<SfaVisitGroupRespVo> result=sfaVisitGroupService.findList(sfaVisitGroupReqVo);
        return Result.ok(result);
    }

    /**
     * 通过id查询详情
     */
    @ApiOperation(value = "通过id查询详情")
    @GetMapping("/queryDetailById")
    @CrmLog
    @CrmDictMethod
    public Result<SfaVisitGroupRespVo> queryDetailById(@RequestParam String id) {
        SfaVisitGroupRespVo respVo=sfaVisitGroupService.queryDetailById(id);
        return Result.ok(respVo);
    }

    /**
     * 查询
     */
    @ApiOperation(value = "查询")
    @PostMapping("/query")
    @CrmLog
    public Result<SfaVisitGroupRespVo> query(@RequestBody SfaVisitGroupReqVo sfaVisitGroupReqVo) {
        SfaVisitGroupRespVo respVo=sfaVisitGroupService.query(sfaVisitGroupReqVo);
        return Result.ok(respVo);
    }

    /**
     * 新增
     */
    @ApiOperation(value = "新增")
    @PostMapping("/save")
    @CrmLog
    public Result save(@RequestBody SfaVisitGroupReqVo sfaVisitGroupReqVo) {
        sfaVisitGroupService.save(sfaVisitGroupReqVo);
        return Result.ok();
    }

    /**
     * 更新
     */
    @ApiOperation(value = "更新")
    @PostMapping("/update")
    @CrmLog
    public Result update(@RequestBody SfaVisitGroupReqVo sfaVisitGroupReqVo) {
        sfaVisitGroupService.update(sfaVisitGroupReqVo);
        return Result.ok("修改成功");
    }

    /**
     * 删除
     */
    @ApiOperation(value = "删除")
    @PostMapping("/delete")
    @CrmLog
    public Result delete(@RequestBody List<String> ids) {
        sfaVisitGroupService.deleteBatch(ids);
        return Result.ok("删除成功");
    }

    /**
     * 启用
     */
    @ApiOperation(value = "启用")
    @PostMapping("/enable")
    @CrmLog
    public Result enable(@RequestBody List<String> ids) {
        sfaVisitGroupService.enableBatch(ids);
        return Result.ok("启用成功");
    }

    /**
     * 禁用
     */
    @ApiOperation(value = "禁用")
    @PostMapping("/disable")
    @CrmLog
    public Result disable(@RequestBody List<String> ids) {
        sfaVisitGroupService.disableBatch(ids);
        return Result.ok("禁用成功");
    }
}
