package com.biz.crm.visitnote.controller;

import com.biz.crm.common.CrmIdsReqVo;
import com.biz.crm.config.CrmDictMethod;
import com.biz.crm.eunm.sfa.SfaVisitEnum;
import com.biz.crm.nebular.sfa.visitinfo.req.SfaVisitPlanInfoReqVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import com.biz.crm.visitnote.service.ISfaVisitPlanService;
import com.biz.crm.nebular.sfa.visitnote.resp.SfaVisitPlanRespVo;
import com.biz.crm.nebular.sfa.visitnote.req.SfaVisitPlanReqVo;
import com.biz.crm.common.PageResult;
import com.biz.crm.util.Result;
import com.biz.crm.aop.CrmLog;

import java.util.List;

/**
 * 拜访计划制定 
 *
 * @author liuhongming
 * @date 2020-09-21 14:35:05
 */
@Slf4j
@RestController
@RequestMapping("/sfaVisitPlanController")
@Api(tags = "拜访计划制定 ")
public class SfaVisitPlanController {
    @Autowired
    private ISfaVisitPlanService sfaVisitPlanService;

    /**
     * 列表
     */
    @ApiOperation(value = "查询列表")
    @PostMapping("/list")
    @CrmLog
    @CrmDictMethod
    public Result<PageResult<SfaVisitPlanRespVo>> list(@RequestBody SfaVisitPlanReqVo sfaVisitPlanReqVo) {
        sfaVisitPlanReqVo.setPlanType(SfaVisitEnum.visitType.PLAN_VISIT.getVal());
        PageResult<SfaVisitPlanRespVo> result=sfaVisitPlanService.findList(sfaVisitPlanReqVo);
        return Result.ok(result);
    }

    /**
     * 查询拜访计划详情
     */
    @ApiOperation(value = "查询拜访计划详情")
    @GetMapping("/queryDetailById")
    @CrmLog
    @CrmDictMethod
    public Result<SfaVisitPlanRespVo> queryDetailById(@RequestParam String id) {
        SfaVisitPlanRespVo respVo=sfaVisitPlanService.queryDetailById(id);
        return Result.ok(respVo);
    }

    /**
     * 查询
     */
    @ApiOperation(value = "查询")
    @PostMapping("/query")
    @CrmLog
    public Result<SfaVisitPlanRespVo> query(@RequestBody SfaVisitPlanReqVo sfaVisitPlanReqVo) {
        sfaVisitPlanReqVo.setPlanType(SfaVisitEnum.visitType.PLAN_VISIT.getVal());
        SfaVisitPlanRespVo respVo=sfaVisitPlanService.query(sfaVisitPlanReqVo);
        return Result.ok(respVo);
    }

    /**
     * 新增
     */
    @ApiOperation(value = "新增")
    @PostMapping("/save")
    @CrmLog
    public Result save(@RequestBody SfaVisitPlanReqVo sfaVisitPlanReqVo) {
        sfaVisitPlanReqVo.setPlanType(SfaVisitEnum.visitType.PLAN_VISIT.getVal());
        sfaVisitPlanService.save(sfaVisitPlanReqVo);
        return Result.ok();
    }

    /**
     * 更新
     */
    @ApiOperation(value = "更新")
    @PostMapping("/update")
    @CrmLog
    public Result update(@RequestBody SfaVisitPlanReqVo sfaVisitPlanReqVo) {
        sfaVisitPlanReqVo.setPlanType(SfaVisitEnum.visitType.PLAN_VISIT.getVal());
        sfaVisitPlanService.update(sfaVisitPlanReqVo);
        return Result.ok("修改成功");
    }

    /**
     * 删除
     */
    @ApiOperation(value = "删除")
    @PostMapping("/delete")
    @CrmLog
    public Result delete(@RequestBody List<String> ids) {
        sfaVisitPlanService.deleteBatch(ids);
        return Result.ok("删除成功");
    }

    /**
     * 启用
     */
    @ApiOperation(value = "启用")
    @PostMapping("/enable")
    @CrmLog
    public Result enable(@RequestBody List<String> ids) {
        sfaVisitPlanService.enableBatch(ids);
        return Result.ok("启用成功");
    }

    /**
     * 禁用
     */
    @ApiOperation(value = "禁用")
    @PostMapping("/disable")
    @CrmLog
    public Result disable(@RequestBody List<String> ids) {
        sfaVisitPlanService.disableBatch(ids);
        return Result.ok("禁用成功");
    }

    /**
     * WEB后台人工触发解析拜访计划
     */
    @ApiOperation(value = "WEB后台人工触发解析拜访计划")
    @PostMapping("/resolveVisitPlanForWeb")
    @CrmLog
    public Result resolveVisitPlanForWeb(@RequestBody List<String> ids) {
//        sfaVisitPlanInfoReqVo.setVisitType(SfaVisitEnum.visitType.PLAN_VISIT.getVal());
        sfaVisitPlanService.resolveVisitPlanForWeb(ids);
        return Result.ok("生成拜访计划成功");
    }

    /**
     * 定时任务——触发解析拜访计划
     */
    @ApiOperation(value = "定时任务——触发解析拜访计划")
    @PostMapping("/resolveVisitPlanForJob")
    @CrmLog
    public Result resolveVisitPlanForJob() {
        sfaVisitPlanService.resolveVisitPlanForJob();
        return Result.ok("生成拜访计划成功");
    }


}
