package com.biz.crm.visitnote.controller;

import com.biz.crm.aop.CrmLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.config.CrmDictMethod;
import com.biz.crm.nebular.sfa.visitnote.req.SfaVisitPlanRangeReqVo;
import com.biz.crm.nebular.sfa.visitnote.resp.SfaVisitPlanRangeRespVo;
import com.biz.crm.util.Result;
import com.biz.crm.visitnote.service.ISfaVisitPlanRangeService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 拜访计划制定范围表 
 *
 * @author liuhongming
 * @date 2020-09-21 14:35:05
 */
@Slf4j
@RestController
@RequestMapping("/sfaVisitPlanRangeController")
@Api(tags = "拜访计划制定范围表 ")
public class SfaVisitPlanRangeController {
    @Autowired
    private ISfaVisitPlanRangeService sfaVisitPlanRangeService;

    /**
     * 列表
     */
    @ApiOperation(value = "查询列表")
    @PostMapping("/list")
    @CrmLog
    @CrmDictMethod
    public Result<PageResult<SfaVisitPlanRangeRespVo>> list(@RequestBody SfaVisitPlanRangeReqVo sfaVisitPlanRangeReqVo) {
        PageResult<SfaVisitPlanRangeRespVo> result=sfaVisitPlanRangeService.findList(sfaVisitPlanRangeReqVo);
        return Result.ok(result);
    }

    /**
     * 查询
     */
    @ApiOperation(value = "查询")
    @PostMapping("/query")
    @CrmLog
    public Result<SfaVisitPlanRangeRespVo> query(@RequestBody SfaVisitPlanRangeReqVo sfaVisitPlanRangeReqVo) {
        SfaVisitPlanRangeRespVo respVo=sfaVisitPlanRangeService.query(sfaVisitPlanRangeReqVo);
        return Result.ok(respVo);
    }

    /**
     * 新增
     */
    @ApiOperation(value = "新增")
    @PostMapping("/save")
    @CrmLog
    public Result save(@RequestBody SfaVisitPlanRangeReqVo sfaVisitPlanRangeReqVo) {
        sfaVisitPlanRangeService.save(sfaVisitPlanRangeReqVo);
        return Result.ok();
    }

    /**
     * 更新
     */
    @ApiOperation(value = "更新")
    @PostMapping("/update")
    @CrmLog
    public Result update(@RequestBody SfaVisitPlanRangeReqVo sfaVisitPlanRangeReqVo) {
        sfaVisitPlanRangeService.update(sfaVisitPlanRangeReqVo);
        return Result.ok("修改成功");
    }

    /**
     * 删除
     */
    @ApiOperation(value = "删除")
    @PostMapping("/delete")
    @CrmLog
    public Result delete(@RequestBody List<String> ids) {
        sfaVisitPlanRangeService.deleteBatch(ids);
        return Result.ok("删除成功");
    }

    /**
     * 启用
     */
    @ApiOperation(value = "启用")
    @PostMapping("/enable")
    @CrmLog
    public Result enable(@RequestBody List<String> ids) {
        sfaVisitPlanRangeService.enableBatch(ids);
        return Result.ok("启用成功");
    }

    /**
     * 禁用
     */
    @ApiOperation(value = "禁用")
    @PostMapping("/disable")
    @CrmLog
    public Result disable(@RequestBody List<String> ids) {
        sfaVisitPlanRangeService.disableBatch(ids);
        return Result.ok("禁用成功");
    }
}
