package com.biz.crm.visitnote.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.interceptor.SqlPrivilege;
import com.biz.crm.nebular.sfa.visitnote.req.SfaVisitGroupReqVo;
import com.biz.crm.nebular.sfa.visitnote.resp.SfaVisitGroupRespVo;
import com.biz.crm.visitnote.model.SfaVisitGroupEntity;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 线路组管理 
 * 
 * @author liuhongming
 * @date 2020-09-18 16:53:00
 */
public interface SfaVisitGroupMapper extends BaseMapper<SfaVisitGroupEntity> {
    /**
     * 列表
     * @param page
     * @param sfaVisitGroupReqVo
     * @return
     */
    @SqlPrivilege(orgCode = "sfa_visit_group.org_code",posCode = "sfa_visit_group.pos_code")
    List<SfaVisitGroupRespVo> findList(Page<SfaVisitGroupRespVo> page, @Param("vo") SfaVisitGroupReqVo sfaVisitGroupReqVo);

    /**
     * 删除
     * @param sfaVisitGroupReqVo
     */
    void deleteProductsByParams(@Param("vo") SfaVisitGroupReqVo sfaVisitGroupReqVo);

    /**
     * 查询数量
     * @param visitGroupId
     * @return
     */
    Integer getCountByVisitGroupId(@Param("visitGroupId")String visitGroupId);
}
