package com.biz.crm.visitnote.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

/**
 * 拜访计划制定 实体类
 *
 * @author liuhongming
 * @date 2020-09-21 14:35:05
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("sfa_visit_plan")
@CrmTable(name = "sfa_visit_plan", tableNote = "拜访计划制定")
public class SfaVisitPlanEntity extends CrmExtTenEntity<SfaVisitPlanEntity> {


    /**
     * 拜访计划编码
     */
    @CrmColumn(name = "visit_plan_code", length = 32, note = "拜访计划编码")
    private String visitPlanCode;

    /**
     * 人员账号 人员账号
     */
    @CrmColumn(name = "visit_user_name", length = 32, note = "人员账号 人员账号")
    private String visitUserName;

    /**
     * 人员姓名 人员姓名
     */
    @CrmColumn(name = "visit_real_name", length = 100, note = "人员姓名 人员姓名")
    private String visitRealName;

    /**
     * 人员职位编码 人员职位编码
     */
    @CrmColumn(name = "visit_pos_code", length = 32, note = "人员职位编码 人员职位编码")
    private String visitPosCode;

    /**
     * 人员职位名称 人员职位名称
     */
    @CrmColumn(name = "visit_pos_name", length = 100, note = "人员职位名称 人员职位名称")
    private String visitPosName;

    /**
     * 人员所属组织编码 人员所属组织编码
     */
    @CrmColumn(name = "visit_org_code", length = 32, note = "人员所属组织编码 人员所属组织编码")
    private String visitOrgCode;

    /**
     * 人员所属组织名称 人员所属组织名称
     */
    @CrmColumn(name = "visit_org_name", length = 100, note = "人员所属组织名称 人员所属组织名称")
    private String visitOrgName;

    /**
     * 循环开始日期 循环开始日期yyyy-MM-dd
     */
    @CrmColumn(name = "visit_start_date", length = 32, note = "循环开始日期 循环开始日期yyyy-MM-dd")
    private String visitStartDate;

    /**
     * 循环结算日期 循环结算日期yyyy-MM-dd
     */
    @CrmColumn(name = "visit_end_date", length = 32, note = "循环结算日期 循环结算日期yyyy-MM-dd")
    private String visitEndDate;

    /**
     * 排除 排除（星期一、星期二、星期三、星期四、星期五、星期六、星期日）
     */
    @CrmColumn(name = "not_week_set", length = 60, note = "排除 排除（星期一、星期二、星期三、星期四、星期五、星期六、星期日）")
    private String notWeekSet;

    /**
     * 排除描述 排除描述（星期一、星期二、星期三、星期四、星期五、星期六、星期日）
     */
    @CrmColumn(name = "not_week_set_desc", length = 100, note = "排除描述 排除描述（星期一、星期二、星期三、星期四、星期五、星期六、星期日）")
    private String notWeekSetDesc;

    /**
     * 拜访类型 拜访类型 临时拜访-计划外，计划拜访-计划内，协访
     */
    @CrmColumn(name = "plan_type", length = 32, note = "拜访类型 拜访类型 临时拜访-计划外，计划拜访-计划内")
    private String planType;

    /**
     * 维度类型 维度类型（线路组、网点、频率）
     */
    @CrmColumn(name = "route_type", length = 32, note = "维度类型 维度类型（线路组、网点、频率）")
    private String routeType;

    /**
     * 被协访的人员ID 被协访的人员ID
     */
    @CrmColumn(name = "cv_user_id", length = 32, note = "被协访的人员ID 被协访的人员ID")
    private String cvUserId;

    /**
     * 被协访的人员账号 被协访的人员账号
     */
    @CrmColumn(name = "cv_user_name", length = 32, note = "被协访的人员账号 被协访的人员账号")
    private String cvUserName;

    /**
     * 被协访的人员姓名 被协访的人员姓名
     */
    @CrmColumn(name = "cv_real_name", length = 100, note = "被协访的人员姓名 被协访的人员姓名")
    private String cvRealName;

    /**
     * 被协访的人员职位ID 被协访的人员职位ID
     */
    @CrmColumn(name = "cv_pos_id", length = 32, note = "被协访的人员职位ID 被协访的人员职位ID")
    private String cvPosId;

    /**
     * 被协访的人员职位编码 被协访的人员职位编码
     */
    @CrmColumn(name = "cv_pos_code", length = 32, note = "被协访的人员职位编码 被协访的人员职位编码")
    private String cvPosCode;

    /**
     * 被协访的人员职位名称 被协访的人员职位名称
     */
    @CrmColumn(name = "cv_pos_name", length = 100, note = "被协访的人员职位名称 被协访的人员职位名称")
    private String cvPosName;

    /**
     * 被协访的人员所属组织ID 被协访的人员所属组织ID
     */
    @CrmColumn(name = "cv_org_id", length = 32, note = "被协访的人员所属组织ID 被协访的人员所属组织ID")
    private String cvOrgId;

    /**
     * 被协访的人员所属组织编码 被协访的人员所属组织编码
     */
    @CrmColumn(name = "cv_org_code", length = 32, note = "被协访的人员所属组织编码 被协访的人员所属组织编码")
    private String cvOrgCode;

    /**
     * 被协访的人员所属组织名称 被协访的人员所属组织名称
     */
    @CrmColumn(name = "cv_org_name", length = 100, note = "被协访的人员所属组织名称 被协访的人员所属组织名称")
    private String cvOrgName;

    /**
     * 协访日期 协访日期
     */
    @CrmColumn(name = "cv_visit_date", length = 32, note = "协访日期 协访日期")
    private String cvVisitDate;

}
