package com.biz.crm.visitnote.service.component.resolver;


import com.biz.crm.base.BusinessException;
import com.biz.crm.util.CrmDateUtils;
import com.biz.crm.visitnote.service.component.SfaVisitPlanExecuteContext;

import java.time.LocalDate;

/**
 * 拜访计划解析器，目前标品分别实现了 线路、网点、频率 三种计划
 *  @author: luoqi
 *  @Date: 2021-2-23 21:09
 *  @version: V1.0
 *  @Description:
 */
public interface SfaVisitPlanResolver {
    /**
     * 能够解析未来的天数(包含当天)
     */
    int futureDays = 7;
    /**
     * bean name 后缀
     */
    String beanNameSuffix = "Resolver";

    /**
     * 拜访计划解析
     * @param context
     */
    void resolve(SfaVisitPlanExecuteContext context);


    /**
     * 校验日期是否在当天 [futureDays] 天内
     * @param date
     */
    static void futureDaysCheck(LocalDate date){

        if(null == date){
            throw new BusinessException("请选择日期");
        }
        int temp = date.compareTo(LocalDate.now());
        if(temp < 0 || temp > SfaVisitPlanResolver.futureDays){
            throw new BusinessException("只能选择当天及以后[" + SfaVisitPlanResolver.futureDays + "]天内的日期（含当天）");
        }
    }
}
