package com.biz.crm.visitnote.service.component.resolver.impl;


import com.biz.crm.util.*;
import com.biz.crm.visitinfo.model.SfaVisitPlanInfoEntity;
import com.biz.crm.visitnote.model.SfaVisitPlanEntity;
import com.biz.crm.visitnote.service.component.SfaVisitPlanExecuteContext;
import com.biz.crm.visitnote.service.component.resolver.SfaVisitPlanResolver;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;

import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * 拜访计划解析器抽象
 *  @author: luoqi
 *  @Date: 2021-2-23 21:09
 *  @version: V1.0
 *  @Description:
 */
@Slf4j
public abstract class AbstractSfaVisitPlanResolver implements SfaVisitPlanResolver {



    /**
     * 拜访计划解析
     * @param context
     */
    @Override
    public void resolve(SfaVisitPlanExecuteContext context) {
//        //计算拜访日期
//        LocalDate visitDate = this.visitDateNext(context);
//        if(null == visitDate){
//            return Lists.newArrayList();
//        }
        this.doResolve(context);
    }

    /**
     * 拜访计划解析
     * @param context
     */
    protected abstract void doResolve(SfaVisitPlanExecuteContext context);

    /**
     * 计算拜访日期
     * @param context
     * @return
     */
    protected LocalDate visitDateNext(SfaVisitPlanExecuteContext context, SfaVisitPlanExecuteContext.FuturePlanInfo futurePlanInfo){
        LocalDate now = LocalDate.now();
        LocalDate visitDate = context.getVisitDate();
        if(null == context.getVisitDate()){
            //首次是空的，直接使用当前日期
            visitDate = LocalDate.now();
        }else{
            //加一天
            visitDate = visitDate.plusDays(1);
        }
        SfaVisitPlanEntity sfaVisitPlanEntity = context.getCurrentPlanEntity();

        LocalDate visitEndDate = (null == context.getVisitEndDate())
                ? LocalDate.parse(sfaVisitPlanEntity.getVisitEndDate(), CrmDateUtils.yyyyMMdd) : context.getVisitEndDate();
        LocalDate visitStartDate = (null == context.getVisitStartDate())
                ? LocalDate.parse(sfaVisitPlanEntity.getVisitStartDate(), CrmDateUtils.yyyyMMdd) : context.getVisitStartDate();
        if(visitStartDate.compareTo(visitDate) > 0){
            visitDate = visitStartDate;
        }
        if(StringUtils.isBlank(sfaVisitPlanEntity.getNotWeekSet())){
            if(this.checkVisitData(now, visitDate, visitEndDate, sfaVisitPlanEntity)){
                //没有配置排除规则
                context.setVisitDate(visitDate);
                context.setVisitStartDate(visitStartDate);
                context.setVisitEndDate(visitEndDate);
                return visitDate;
            }
            return null;
        }

        while (true){
            if(this.checkVisitData(now, visitDate, visitEndDate, sfaVisitPlanEntity)){
                //判断当天是否在排除日期内
                if (sfaVisitPlanEntity.getNotWeekSet().contains(String.valueOf(visitDate.getDayOfWeek().getValue()))) {
                    //如果被排除, 则该拜访日期无计划
                    futurePlanInfo.putPlan(visitDate, Lists.newArrayList());
                    //如果被排除，则往后加一天继续校验
                    visitDate = visitDate.plusDays(1);
                    continue;
                }
                context.setVisitDate(visitDate);
                context.setVisitStartDate(visitStartDate);
                context.setVisitEndDate(visitEndDate);
                return visitDate;
            }
            return null;
        }





    }
    private boolean checkVisitData(LocalDate now, LocalDate visitDate, LocalDate visitEndDate, SfaVisitPlanEntity sfaVisitPlanEntity){
        if(visitDate.compareTo(visitEndDate) > 0){
            log.warn("[拜访计划解析器]->" + this.getClass().getName() + "：当天日期已经大于计划结束日期, visitDate={}, visitEndDate={}, sfaVisitPlanEntity={}", visitDate, visitEndDate, JsonPropertyUtil.toJsonString(sfaVisitPlanEntity));
            //当天日期已经大于计划结束日期
            return false;
        }
        if((visitDate.toEpochDay() - now.toEpochDay()) > this.futureDays){
            log.warn("[拜访计划解析器]->" + this.getClass().getName() + "：已经超出能够解析未来的天数, visitDate={}, futureDays={}, sfaVisitPlanEntity={}", visitDate, this.futureDays, JsonPropertyUtil.toJsonString(sfaVisitPlanEntity));
            //已经超出能够解析未来的天数
            return false;
        }
        return true;
    }

}
