package com.biz.crm.visitnote.service.component.resolver.impl;

import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.base.SfaClientData;
import com.biz.crm.base.SfaClientHelper;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.sfa.SfaVisitEnum;
import com.biz.crm.mdm.customer.MdmCustomerMsgFeign;
import com.biz.crm.mdm.terminal.MdmTerminalFeign;
import com.biz.crm.nebular.mdm.customer.MdmCustomerContactPageReqVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgContactPageRespVo;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalContactPageReqVo;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalContactPageVo;
import com.biz.crm.nebular.sfa.visitnote.req.SfaVisitGroupReqVo;
import com.biz.crm.nebular.sfa.visitnote.resp.SfaVisitGroupRespVo;
import com.biz.crm.nebular.sfa.visitnote.resp.SfaVisitclientRelRespVo;
import com.biz.crm.util.*;
import com.biz.crm.visitinfo.model.SfaVisitPlanInfoEntity;
import com.biz.crm.visitinfo.service.impl.VisitPlanInfoHelper;
import com.biz.crm.visitnote.model.SfaVisitPlanEntity;
import com.biz.crm.visitnote.model.SfaVisitPlanRangeEntity;
import com.biz.crm.visitnote.service.ISfaVisitGroupService;
import com.biz.crm.visitnote.service.component.SfaVisitPlanExecuteContext;
import com.biz.crm.visitnote.service.component.resolver.SfaVisitPlanResolver;
import com.google.common.collect.Lists;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.Period;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;


/**
 * 拜访计划解析器 - 线路
 *  @author: luoqi
 *  @Date: 2021-2-23 21:27
 *  @version: V1.0
 *  @Description:
 */
@Component(SfaVisitEnum.routeTypeEnum.line + SfaVisitPlanResolver.beanNameSuffix)
public class SfaVisitPlanLineResolver extends AbstractSfaVisitPlanResolver {
    @Resource
    private ISfaVisitGroupService iSfaVisitGroupService;

    @Resource
    private VisitPlanInfoHelper visitPlanInfoHelper;


    @Override
    public void doResolve(SfaVisitPlanExecuteContext context) {
        //本次解析拜访计划未来 SfaVisitPlanResolver.futureDays 天的计划明细
        SfaVisitPlanExecuteContext.FuturePlanInfo futurePlanInfo = new SfaVisitPlanExecuteContext.FuturePlanInfo();
        SfaVisitPlanEntity currentPlanEntity = context.getCurrentPlanEntity();
        while (true){
            //计算下一拜访日期
            LocalDate visitDate = this.visitDateNext(context, futurePlanInfo);
            if(null == visitDate){
                break;
            }
            SfaVisitGroupRespVo sfaVisitGroupRespVo = this.loadSfaVisitGroupRespVo(context);
            if (null == sfaVisitGroupRespVo) {
                //如果该计划 [currentPlanEntity] 没有线路组配置，则该拜访日期 [visitDate] 无计划
                futurePlanInfo.putPlan(visitDate, Lists.newArrayList());
                return;
            }
            List<SfaVisitclientRelRespVo> sfaVisitclientRelRespVos = sfaVisitGroupRespVo.getSfaVisitclientRelRespVos();
            if (CollectionUtils.isEmpty(sfaVisitclientRelRespVos)) {
                //如果该线路组 [sfaVisitGroupRespVo] 没有终端、经销商配置，则该拜访日期 [visitDate] 无计划
                futurePlanInfo.putPlan(visitDate, Lists.newArrayList());
                return ;
            }

            /**
             * 加载终端、经销商信息
             */
            List<SfaVisitPlanInfoEntity> planInfoEntities = this.resolveSfaVisitPlanInfoEntityList(context, sfaVisitclientRelRespVos);
            futurePlanInfo.putPlan(visitDate, planInfoEntities);
        }
        //该拜访计划的未来计划明细

        context.getPlanCodeMapFuturePlanInfo().put(currentPlanEntity.getVisitPlanCode(), futurePlanInfo);

    }

    /**
     * 将拜访计划解析成计划明细
     * @param context
     * @param sfaVisitclientRelRespVos
     * @return
     */
    protected List<SfaVisitPlanInfoEntity> resolveSfaVisitPlanInfoEntityList(SfaVisitPlanExecuteContext context
            , List<SfaVisitclientRelRespVo> sfaVisitclientRelRespVos){
        List<SfaVisitPlanInfoEntity> visitPlanInfoEntities = Lists.newArrayList();
        int i = 0;
        for (SfaVisitclientRelRespVo data : sfaVisitclientRelRespVos) {
            SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity = this.buildSfaVisitPlanInfoEntity(context, data);
            sfaVisitPlanInfoEntity.setVisitSort(i);
            visitPlanInfoEntities.add(sfaVisitPlanInfoEntity);
            i ++;
//            iSfaVisitPlanInfoService.savePeriodicityPlanInfo(planInfoReqVo);
        }
        return visitPlanInfoEntities;
    }
    /**
     * 组装拜访明细数据
     * @param context
     * @param data
     * @return
     */
    protected SfaVisitPlanInfoEntity buildSfaVisitPlanInfoEntity(SfaVisitPlanExecuteContext context, SfaVisitclientRelRespVo data){
        SfaVisitPlanEntity sfaVisitPlanEntity = context.getCurrentPlanEntity();
        SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity = CrmBeanUtil.copy(sfaVisitPlanEntity, SfaVisitPlanInfoEntity.class);
//        sfaVisitPlanInfoEntity.setId(null);
        sfaVisitPlanInfoEntity.setVisitType(sfaVisitPlanEntity.getPlanType());
        sfaVisitPlanInfoEntity.setVisitTypeName(SfaVisitEnum.visitType.GETMAP.get(sfaVisitPlanEntity.getPlanType()));
        sfaVisitPlanInfoEntity.setClientType(data.getClientType());
        sfaVisitPlanInfoEntity.setClientTypeName(SfaVisitEnum.ClientType.GETMAP.get(sfaVisitPlanInfoEntity.getClientType()));
        sfaVisitPlanInfoEntity.setClientCode(data.getClientCode());
        sfaVisitPlanInfoEntity.setVisitStatus(SfaVisitEnum.visitStatus.V1.getVal());
        sfaVisitPlanInfoEntity.setVisitStatusName(SfaVisitEnum.visitStatus.V1.getDesc());
        sfaVisitPlanInfoEntity.setVisitDate(context.getVisitDate().format(CrmDateUtils.yyyyMMdd));
        sfaVisitPlanInfoEntity.setVisitDateOfYearMonth(context.getVisitDate().format(CrmDateUtils.yyyyMM));
        sfaVisitPlanInfoEntity.setVisitDateOfYear(context.getVisitDate().format(CrmDateUtils.yyyy));
        sfaVisitPlanInfoEntity.setVisitBigType(SfaVisitEnum.VisitBigType.VISIT.getVal());
        sfaVisitPlanInfoEntity.setVisitBigTypeName(SfaVisitEnum.VisitBigType.VISIT.getDesc());
        sfaVisitPlanInfoEntity.setId(UUIDGenerator.generate());
        CrmBaseEntity.buildDefEntityData(sfaVisitPlanInfoEntity);
        return sfaVisitPlanInfoEntity;
    }


    /**
     * 加载线路组配置
     * @param context
     * @return
     */
    protected SfaVisitGroupRespVo loadSfaVisitGroupRespVo(SfaVisitPlanExecuteContext context){

        //获取线路组信息
        SfaVisitPlanRangeEntity sfaVisitPlanRangeEntity = this.getLine(context);
        if(null == sfaVisitPlanRangeEntity){
            return null;
        }
        SfaVisitGroupReqVo groupReqVo = new SfaVisitGroupReqVo() {{
            this.setId(sfaVisitPlanRangeEntity.getVisitGroupId());
        }};
        SfaVisitGroupRespVo sfaVisitGroupRespVo = iSfaVisitGroupService.query(groupReqVo);
        this.visitPlanInfoHelper.loadUserDataForVisitGroup(sfaVisitGroupRespVo);
        return sfaVisitGroupRespVo;

    }
    /**
     * 获取线路组下标
     * @param context
     * @return
     */
    protected SfaVisitPlanRangeEntity getLine(SfaVisitPlanExecuteContext context){
        LocalDate visitDate = context.getVisitDate();
        SfaVisitPlanEntity sfaVisitPlanEntity = context.getCurrentPlanEntity();
        Map<String, List<SfaVisitPlanRangeEntity>> planCodeMapPlanRange = context.getPlanCodeMapPlanRange();
        List<SfaVisitPlanRangeEntity> planRangeEntities = planCodeMapPlanRange.get(sfaVisitPlanEntity.getVisitPlanCode());
        if(CollectionUtils.isEmpty(planRangeEntities)){
            return null;
        }
        Integer num = this.notWeekNum(LocalDate.parse(sfaVisitPlanEntity.getVisitStartDate()), visitDate, sfaVisitPlanEntity.getNotWeekSet());
        LocalDate startDate = context.getVisitStartDate();

        long days = visitDate.toEpochDay() - startDate.toEpochDay() - num;
        long lineNum = 0;
        int size = planRangeEntities.size();
        if (size > 1) {
            lineNum = days % size;
        }
        return planRangeEntities.get((int)lineNum);
//        return lineNum;
    }
    /**
     * 获取排除的天数
     * @param startDate
     * @param visitEndDate
     * @param week
     * @return
     */
    private Integer notWeekNum(LocalDate startDate,LocalDate visitEndDate,String week){
        long days = (visitEndDate.toEpochDay() - startDate.toEpochDay()) + 1;
        Integer num = 0;
        for (int i = 0; i < days; i++) {
            //得到拜访时间
            LocalDate visitDate = startDate.plusDays(i);
            //判断当前时间是否在排除日期内
            if (StringUtils.isNotEmpty(week) && week.contains(String.valueOf(visitDate.getDayOfWeek().getValue()))) {
                num ++;
                continue;
            }
        }
        return num;
    }
}
