package com.biz.crm.visitnote.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BusinessException;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.sfa.SfaVisitEnum;
import com.biz.crm.nebular.sfa.visitnote.req.SfaVisitAssitPlanReqVo;
import com.biz.crm.nebular.sfa.visitnote.req.SfaVisitPlanRangeReqVo;
import com.biz.crm.nebular.sfa.visitnote.resp.SfaVisitAssitPlanRespVo;
import com.biz.crm.nebular.sfa.visitnote.resp.SfaVisitPlanRangeRespVo;
import com.biz.crm.util.*;
import com.biz.crm.visitnote.mapper.SfaVisitPlanMapper;
import com.biz.crm.visitnote.mapper.SfaVisitPlanRangeMapper;
import com.biz.crm.visitnote.model.SfaVisitPlanEntity;
import com.biz.crm.visitnote.model.SfaVisitPlanRangeEntity;
import com.biz.crm.visitnote.service.ISfaVisitAssitPlanService;
import com.biz.crm.visitnote.service.ISfaVisitPlanRangeService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 协防计划制定 接口实现
 *
 * @author liuhongming
 * @date 2020-09-21 14:35:05
 */
@Slf4j
@Service
@ConditionalOnMissingBean(name="SfaVisitAssitPlanServiceExpandImpl")
public class SfaVisitAssitPlanServiceImpl<M extends BaseMapper<T>, T> extends ServiceImpl<SfaVisitPlanMapper, SfaVisitPlanEntity> implements ISfaVisitAssitPlanService {

    @Resource
    private SfaVisitPlanMapper sfaVisitPlanMapper;
    @Resource
    private SfaVisitPlanRangeMapper sfaVisitPlanRangeMapper;

    @Autowired
    private ISfaVisitPlanRangeService iSfaVisitPlanRangeService;

    /**
     * 列表
     * @param reqVo
     * @return
     */
    @Override
    public PageResult<SfaVisitAssitPlanRespVo> findList(SfaVisitAssitPlanReqVo reqVo){
        Page<SfaVisitAssitPlanRespVo> page = new Page<>(reqVo.getPageNum(), reqVo.getPageSize());
        List<SfaVisitAssitPlanRespVo> list = sfaVisitPlanMapper.findAssitList(page, reqVo);
        return PageResult.<SfaVisitAssitPlanRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    /**
     * 查询
     * @param reqVo
     * @return sfaVisitPlanRespVo
     */
    @Override
    public SfaVisitAssitPlanRespVo query(SfaVisitAssitPlanReqVo reqVo){
        if (null==reqVo||(StringUtils.isEmpty(reqVo.getId())&& CollectionUtil.listEmpty(reqVo.getIds()))){
            return new SfaVisitAssitPlanRespVo();
        }
        List<SfaVisitAssitPlanRespVo> list = this.findList(reqVo).getData();
        if (CollectionUtil.listEmpty(list)){
            return new SfaVisitAssitPlanRespVo();
        }
        SfaVisitAssitPlanRespVo respVo = list.get(0);
        //查询对应客户信息
        SfaVisitPlanRangeReqVo sfaVisitPlanRangeReqVo = new SfaVisitPlanRangeReqVo();
        sfaVisitPlanRangeReqVo.setVisitPlanCode(reqVo.getVisitPlanCode());
        List<SfaVisitPlanRangeRespVo> sfaVisitPlanRangeRespVos = iSfaVisitPlanRangeService.findList(sfaVisitPlanRangeReqVo).getData();
        respVo.setSfaVisitPlanRangeRespVos(sfaVisitPlanRangeRespVos);
        return respVo;
    }

    public void saveCheck(SfaVisitAssitPlanReqVo reqVo){
        AssertUtils.isNotEmpty(reqVo.getPlanType(),"拜访类型不能为空");
        if (!SfaVisitEnum.visitType.GETMAP.containsKey(reqVo.getPlanType())){
            throw new BusinessException("拜访类型有误,不存在该拜访类型(01:临时拜访、02:计划拜访、03:协访)");
        }
        AssertUtils.isNotEmpty(reqVo.getRouteType(),"维度类型不能为空(1:线路组、2:网点、3:频率)");
        if (!SfaVisitEnum.routeTypeEnum.GETMAP.containsKey(reqVo.getRouteType())){
            throw new BusinessException("维度类型有误,不存在该维度(1:线路组、2:网点、3:频率)");
        }
        AssertUtils.isNotEmpty(reqVo.getVisitUserId(),"人员ID不能为空");
        AssertUtils.isNotEmpty(reqVo.getVisitUserName(),"人员编码不能为空");
        AssertUtils.isNotEmpty(reqVo.getVisitRealName(),"请选择人员姓名");
        AssertUtils.isNotEmpty(reqVo.getVisitPosId(),"人员职位ID不能为空");
        AssertUtils.isNotEmpty(reqVo.getVisitPosCode(),"人员职位编码不能为空");
        AssertUtils.isNotEmpty(reqVo.getVisitPosName(),"人员职位名称不能为空");
        AssertUtils.isNotEmpty(reqVo.getVisitOrgId(),"人员所属组织ID不能为空");
        AssertUtils.isNotEmpty(reqVo.getVisitOrgCode(),"人员所属组织编码不能为空");
        AssertUtils.isNotEmpty(reqVo.getVisitOrgName(),"人员所属组织名称不能为空");
        AssertUtils.isNotEmpty(reqVo.getCvUserId(),"被协访的人员ID不能为空");
        AssertUtils.isNotEmpty(reqVo.getCvUserName(),"被协访的人员编码不能为空");
        AssertUtils.isNotEmpty(reqVo.getCvRealName(),"请选择被协访的人员姓名");
        AssertUtils.isNotEmpty(reqVo.getCvPosId(),"被协访的人员职位ID不能为空");
        AssertUtils.isNotEmpty(reqVo.getCvPosCode(),"被协访的人员职位编码不能为空");
        AssertUtils.isNotEmpty(reqVo.getCvPosName(),"被协访的人员职位名称不能为空");
        AssertUtils.isNotEmpty(reqVo.getCvOrgId(),"被协访的人员所属组织ID不能为空");
        AssertUtils.isNotEmpty(reqVo.getCvOrgCode(),"被协访的人员所属组织编码不能为空");
        AssertUtils.isNotEmpty(reqVo.getCvOrgName(),"被协访的人员所属组织名称不能为空");
        AssertUtils.isNotEmpty(reqVo.getCvVisitDate(),"协访日期不能为空");
        SimpleDateFormat ymd  =new SimpleDateFormat("yyyy-MM-dd");
        try{
            Date cvVisitDate = (Date) ymd.parse(reqVo.getCvVisitDate());
        }catch(Exception e){
            throw new BusinessException("协访日期格式错误");
        }
        if (CollectionUtil.listNotEmpty(reqVo.getSfaVisitPlanRangeReqVos())){
            throw new BusinessException("拜访计划制定范围不能为空");
        }
        int i = 1;
        for (SfaVisitPlanRangeReqVo sfaVisitPlanRangeReqVo:reqVo.getSfaVisitPlanRangeReqVos()){
            AssertUtils.isNotEmpty(sfaVisitPlanRangeReqVo.getClientId(),"第"+i+"行,客户id不能为空");
            AssertUtils.isNotEmpty(sfaVisitPlanRangeReqVo.getClientCode(),"第"+i+"行,客户编码不能为空");
            AssertUtils.isNotEmpty(sfaVisitPlanRangeReqVo.getClientName(),"第"+i+"行,客户名称不能为空");
            AssertUtils.isNotEmpty(sfaVisitPlanRangeReqVo.getClientType(),"第"+i+"行,客户类型不能为空");
            reqVo.setRouteType(SfaVisitEnum.routeTypeEnum.R2.getVal());
            sfaVisitPlanRangeReqVo.setFirstVisitDate(reqVo.getCvVisitDate());
            i++;
        }
    }

    /**
     * 新增
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void save(SfaVisitAssitPlanReqVo reqVo){
        this.saveCheck(reqVo);
        SfaVisitPlanEntity entity = CrmBeanUtil.copy(reqVo,SfaVisitPlanEntity.class);
        //TODO 编码
        String code = CodeUtil.createCode();
        entity.setVisitPlanCode(code);
        entity.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
        this.save(entity);
        this.saveData(reqVo,entity);
    }

    public void saveData(SfaVisitAssitPlanReqVo reqVo,SfaVisitPlanEntity entity){
        if (CollectionUtil.listNotEmptyNotSizeZero(reqVo.getSfaVisitPlanRangeReqVos())){
            List<SfaVisitPlanRangeEntity> visitPlanRangeEntities = reqVo.getSfaVisitPlanRangeReqVos().stream().map(o -> {
                SfaVisitPlanRangeEntity receivingEntity = new SfaVisitPlanRangeEntity();
                CrmBeanUtil.copyProperties(o, receivingEntity);
                receivingEntity.setVisitPlanCode(entity.getVisitPlanCode());
                return receivingEntity;
            }).collect(Collectors.toList());
            iSfaVisitPlanRangeService.saveBatch(visitPlanRangeEntities);
        }
    }

    /**
     * 更新
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void update(SfaVisitAssitPlanReqVo reqVo){
        if(StringUtils.isEmpty(reqVo.getId())){
            throw new BusinessException("数据主键不能为空");
        }
        SfaVisitPlanEntity entity = this.getById(reqVo.getId());
        if(Objects.isNull(entity)){
            throw new BusinessException("数据不存在");
        }
        this.saveCheck(reqVo);
        CrmBeanUtil.copyPropertiesIgnoreEmpty(reqVo,entity);
        this.updateById(entity);
        reqVo.setVisitPlanCode(entity.getVisitPlanCode());
        this.deleteBatchDate(reqVo);
        this.saveData(reqVo,entity);
    }

    /**
     * 删除
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteBatch(SfaVisitAssitPlanReqVo reqVo){
        if(StringUtils.isEmpty(reqVo.getId())&&CollectionUtil.listEmpty(reqVo.getIds())){
            throw new BusinessException("数据主键不能为空");
        }
        reqVo.setPageSize(-1);
        List<SfaVisitAssitPlanRespVo> list = this.findList(reqVo).getData();
        if(CollectionUtil.listEmpty(list)){
            throw new BusinessException("数据不存在");
        }
        sfaVisitPlanMapper.deleteProductsByParamsAssit(reqVo);
        List<String> visitPlanCodes = list.stream().map(SfaVisitAssitPlanRespVo :: getVisitPlanCode).collect(Collectors.toList());
        reqVo.setVisitPlanCodes(visitPlanCodes);
        this.deleteBatchDate(reqVo);
    }

    public void deleteBatchDate(SfaVisitAssitPlanReqVo reqVo){
        if(StringUtils.isEmpty(reqVo.getVisitPlanCode())&&CollectionUtil.listEmpty(reqVo.getVisitPlanCodes())){
            throw new BusinessException("数据主键不能为空");
        }
        SfaVisitPlanRangeReqVo visitPlanRangeReqVo = new SfaVisitPlanRangeReqVo();
        visitPlanRangeReqVo.setVisitPlanCode(reqVo.getVisitPlanCode());
        visitPlanRangeReqVo.setVisitPlanCodes(reqVo.getVisitPlanCodes());
        sfaVisitPlanRangeMapper.deleteProductsByParams(visitPlanRangeReqVo);
    }

    /**
     * 启用
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void enableBatch(SfaVisitAssitPlanReqVo reqVo){
        if (org.apache.commons.lang3.StringUtils.isNotEmpty(reqVo.getId())){
            List<String> ids = new ArrayList<>();
            if (CollectionUtil.listNotEmptyNotSizeZero(reqVo.getIds())){
                ids = reqVo.getIds();
            }
            ids.add(reqVo.getId());
            reqVo.setIds(ids);
        }
        //设置状态为启用
        List<SfaVisitPlanEntity> sfaVisitPlanEntities = sfaVisitPlanMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(sfaVisitPlanEntities)){
            sfaVisitPlanEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
            });
        }
        this.updateBatchById(sfaVisitPlanEntities);
    }

    /**
     * 禁用
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void disableBatch(SfaVisitAssitPlanReqVo reqVo){
        if(StringUtils.isEmpty(reqVo.getId())&&CollectionUtil.listEmpty(reqVo.getIds())){
            throw new BusinessException("数据主键不能为空");
        }
        if (StringUtils.isNotEmpty(reqVo.getId())){
            List<String> ids = new ArrayList<>();
            if (CollectionUtil.listNotEmptyNotSizeZero(reqVo.getIds())){
                ids = reqVo.getIds();
            }
            ids.add(reqVo.getId());
            reqVo.setIds(ids);
        }
        //设置状态为禁用
        List<SfaVisitPlanEntity> sfaVisitPlanEntities = sfaVisitPlanMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(sfaVisitPlanEntities)){
                sfaVisitPlanEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode());
            });
        }
        this.updateBatchById(sfaVisitPlanEntities);
    }
}
