package com.biz.crm.visitnote.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BusinessException;
import com.biz.crm.common.PageResult;
import com.biz.crm.config.CrmDictMethod;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.nebular.sfa.visitnote.req.SfaVisitPlanRangeReqVo;
import com.biz.crm.nebular.sfa.visitnote.resp.SfaVisitPlanRangeRespVo;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.visitnote.mapper.SfaVisitPlanRangeMapper;
import com.biz.crm.visitnote.model.SfaVisitPlanRangeEntity;
import com.biz.crm.visitnote.service.ISfaVisitPlanRangeService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.List;

/**
 * 拜访计划制定范围表 接口实现
 *
 * @author liuhongming
 * @date 2020-09-21 14:35:05
 */
@Slf4j
@Service
@ConditionalOnMissingBean(name="SfaVisitPlanRangeServiceExpandImpl")
public class SfaVisitPlanRangeServiceImpl<M extends BaseMapper<T>, T> extends ServiceImpl<SfaVisitPlanRangeMapper, SfaVisitPlanRangeEntity> implements ISfaVisitPlanRangeService {

    @Resource
    private SfaVisitPlanRangeMapper sfaVisitPlanRangeMapper;

    /**
     * 列表
     * @param reqVo
     * @return
     */
    @Override
    @CrmDictMethod
    public PageResult<SfaVisitPlanRangeRespVo> findList(SfaVisitPlanRangeReqVo reqVo){
        Page<SfaVisitPlanRangeRespVo> page = new Page<>(reqVo.getPageNum(), reqVo.getPageSize());
        List<SfaVisitPlanRangeRespVo> list = sfaVisitPlanRangeMapper.findList(page, reqVo);
        return PageResult.<SfaVisitPlanRangeRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    /**
     * 查询
     * @param reqVo
     * @return sfaVisitPlanRangeRespVo
     */
    @Override
    public SfaVisitPlanRangeRespVo query(SfaVisitPlanRangeReqVo reqVo){
        return null;
    }

    /**
     * 新增
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void save(SfaVisitPlanRangeReqVo reqVo){
        SfaVisitPlanRangeEntity entity = CrmBeanUtil.copy(reqVo,SfaVisitPlanRangeEntity.class);
        this.save(entity);
    }

    /**
     * 更新
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void update(SfaVisitPlanRangeReqVo reqVo){
        SfaVisitPlanRangeEntity entity = this.getById(reqVo.getId());
        this.updateById(entity);
    }

    /**
     * 删除
     * @param ids
     * @return
     */
    @Override
    public void deleteBatch(List<String> ids){
        if (!CollectionUtil.listNotEmptyNotSizeZero(ids)){
            throw new BusinessException("数据主键不能为空");
        }
        List<SfaVisitPlanRangeEntity> sfaVisitPlanRangeEntities = sfaVisitPlanRangeMapper.selectBatchIds(ids);
        if(CollectionUtils.isNotEmpty(sfaVisitPlanRangeEntities)){
            sfaVisitPlanRangeEntities.forEach(o -> {
                 o.setDelFlag(CrmDelFlagEnum.DELETE.getCode());
            });
        }
        this.updateBatchById(sfaVisitPlanRangeEntities);
    }

    /**
     * 启用
     * @param ids
     * @return
     */
    @Override
    public void enableBatch(List<String> ids){
        if (!CollectionUtil.listNotEmptyNotSizeZero(ids)){
            throw new BusinessException("数据主键不能为空");
        }
        //设置状态为启用
        List<SfaVisitPlanRangeEntity> sfaVisitPlanRangeEntities = sfaVisitPlanRangeMapper.selectBatchIds(ids);
        if(CollectionUtils.isNotEmpty(sfaVisitPlanRangeEntities)){
            sfaVisitPlanRangeEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
            });
        }
        this.updateBatchById(sfaVisitPlanRangeEntities);
    }

    /**
     * 禁用
     * @param ids
     * @return
     */
    @Override
    public void disableBatch(List<String> ids){
        if (!CollectionUtil.listNotEmptyNotSizeZero(ids)){
            throw new BusinessException("数据主键不能为空");
        }
        //设置状态为禁用
        List<SfaVisitPlanRangeEntity> sfaVisitPlanRangeEntities = sfaVisitPlanRangeMapper.selectBatchIds(ids);
        if(CollectionUtils.isNotEmpty(sfaVisitPlanRangeEntities)){
                sfaVisitPlanRangeEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode());
            });
        }
        this.updateBatchById(sfaVisitPlanRangeEntities);
    }
}
