package com.biz.crm.visitnote.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BusinessException;
import com.biz.crm.common.PageResult;
import com.biz.crm.config.CrmDictMethod;
import com.biz.crm.enums.SfaVisitRoleEnum;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.nebular.sfa.visitnote.req.SfaVisitclientRelReqVo;
import com.biz.crm.nebular.sfa.visitnote.resp.SfaVisitclientRelRespVo;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.visitnote.mapper.SfaVisitclientRelMapper;
import com.biz.crm.visitnote.model.SfaVisitclientRelEntity;
import com.biz.crm.visitnote.service.ISfaVisitclientRelService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.List;

/**
 * 线路组对应客户信息 接口实现
 *
 * @author liuhongming
 * @date 2020-09-18 16:53:00
 */
@Slf4j
@Service
@ConditionalOnMissingBean(name="SfaVisitclientRelServiceExpandImpl")
@Transactional
public class SfaVisitclientRelServiceImpl<M extends BaseMapper<T>, T> extends ServiceImpl<SfaVisitclientRelMapper, SfaVisitclientRelEntity> implements ISfaVisitclientRelService {

    @Resource
    private SfaVisitclientRelMapper sfaVisitclientRelMapper;

    /**
     * 列表
     * @param reqVo
     * @return
     */
    @Override
    @CrmDictMethod
    public PageResult<SfaVisitclientRelRespVo> findList(SfaVisitclientRelReqVo reqVo){
        Page<SfaVisitclientRelRespVo> page = new Page<>(reqVo.getPageNum(), reqVo.getPageSize());
        List<SfaVisitclientRelRespVo> list = sfaVisitclientRelMapper.findList(page, reqVo);
        list.forEach(data->{
            data.setClientTypeName(SfaVisitRoleEnum.getSfaVisitRole(data.getClientType()).getDesc());
        });
        return PageResult.<SfaVisitclientRelRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    /**
     * 查询
     * @param reqVo
     * @return sfaVisitclientRelRespVo
     */
    @Override
    public SfaVisitclientRelRespVo query(SfaVisitclientRelReqVo reqVo){
        return null;
    }

    /**
     * 新增
     * @param reqVo
     * @return
     */
    @Override
    public void save(SfaVisitclientRelReqVo reqVo){
        SfaVisitclientRelEntity entity = CrmBeanUtil.copy(reqVo,SfaVisitclientRelEntity.class);
        this.save(entity);
    }

    /**
     * 更新
     * @param reqVo
     * @return
     */
    @Override
    public void update(SfaVisitclientRelReqVo reqVo){
        SfaVisitclientRelEntity entity = this.getById(reqVo.getId());
        this.updateById(entity);
    }

    /**
     * 删除
     * @param ids
     * @return
     */
    @Override
    public void deleteBatch(List<String> ids){
        if (!CollectionUtil.listNotEmptyNotSizeZero(ids)){
            throw new BusinessException("数据主键不能为空");
        }
        List<SfaVisitclientRelEntity> sfaVisitclientRelEntities = sfaVisitclientRelMapper.selectBatchIds(ids);
        if(CollectionUtils.isNotEmpty(sfaVisitclientRelEntities)){
            sfaVisitclientRelEntities.forEach(o -> {
                 o.setDelFlag(CrmDelFlagEnum.DELETE.getCode());
            });
        }
        this.updateBatchById(sfaVisitclientRelEntities);
    }

    /**
     * 启用
     * @param ids
     * @return
     */
    @Override
    public void enableBatch(List<String> ids){
        if (!CollectionUtil.listNotEmptyNotSizeZero(ids)){
            throw new BusinessException("数据主键不能为空");
        }
        //设置状态为启用
        List<SfaVisitclientRelEntity> sfaVisitclientRelEntities = sfaVisitclientRelMapper.selectBatchIds(ids);
        if(CollectionUtils.isNotEmpty(sfaVisitclientRelEntities)){
            sfaVisitclientRelEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
            });
        }
        this.updateBatchById(sfaVisitclientRelEntities);
    }

    /**
     * 禁用
     * @param ids
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void disableBatch(List<String> ids){
        if (!CollectionUtil.listNotEmptyNotSizeZero(ids)){
            throw new BusinessException("数据主键不能为空");
        }
        //设置状态为禁用
        List<SfaVisitclientRelEntity> sfaVisitclientRelEntities = sfaVisitclientRelMapper.selectBatchIds(ids);
        if(CollectionUtils.isNotEmpty(sfaVisitclientRelEntities)){
                sfaVisitclientRelEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode());
            });
        }
        this.updateBatchById(sfaVisitclientRelEntities);
    }
}
